/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import java.util.Collection;
import javax.annotation.Nonnull;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.content.qio.IQIOFrequencyHolder;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityQIOComponent
extends TileEntityMekanism
implements IQIOFrequencyHolder {
    private EnumColor lastColor;

    public TileEntityQIOComponent(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.frequencyComponent.track(FrequencyType.QIO, true, true, true);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
    }

    public EnumColor getColor() {
        return this.lastColor;
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        EnumColor prev = this.lastColor;
        QIOFrequency frequency = this.getQIOFrequency();
        EnumColor enumColor = this.lastColor = frequency == null ? null : frequency.getColor();
        if (prev != this.lastColor) {
            this.sendUpdatePacket();
        }
        if (this.f_58857_.m_46467_() % 10L == 0L) {
            this.setActive(frequency != null);
        }
    }

    @Override
    @Nonnull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        if (this.lastColor != null) {
            NBTUtils.writeEnum(updateTag, "color", this.lastColor);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.lastColor = tag.m_128425_("color", 3) ? EnumColor.byIndexStatic(tag.m_128451_("color")) : null;
        WorldUtils.updateBlock(this.m_58904_(), this.m_58899_(), this.m_58900_());
    }

    @ComputerMethod
    private Collection<QIOFrequency> getFrequencies() {
        return FrequencyType.QIO.getManagerWrapper().getPublicManager().getFrequencies();
    }

    @ComputerMethod
    private boolean hasFrequency() {
        QIOFrequency frequency = this.getQIOFrequency();
        return frequency != null && frequency.isValid();
    }

    @ComputerMethod(nameOverride="getFrequency")
    protected QIOFrequency computerGetFrequency() throws ComputerException {
        QIOFrequency frequency = this.getQIOFrequency();
        if (frequency == null || !frequency.isValid()) {
            throw new ComputerException("No frequency is currently selected.");
        }
        return frequency;
    }

    @ComputerMethod
    private void setFrequency(String name) throws ComputerException {
        this.validateSecurityIsPublic();
        QIOFrequency frequency = FrequencyType.QIO.getManagerWrapper().getPublicManager().getFrequency(name);
        if (frequency == null) {
            throw new ComputerException("No public QIO frequency with name '%s' found.", name);
        }
        this.setFrequency(FrequencyType.QIO, frequency.getIdentity(), this.getOwnerUUID());
    }

    @ComputerMethod
    private void createFrequency(String name) throws ComputerException {
        this.validateSecurityIsPublic();
        QIOFrequency frequency = FrequencyType.QIO.getManagerWrapper().getPublicManager().getFrequency(name);
        if (frequency != null) {
            throw new ComputerException("Unable to create public QIO frequency with name '%s' as one already exists.", name);
        }
        this.setFrequency(FrequencyType.QIO, new Frequency.FrequencyIdentity(name, true), this.getOwnerUUID());
    }

    @ComputerMethod
    private EnumColor getFrequencyColor() throws ComputerException {
        return this.computerGetFrequency().getColor();
    }

    @ComputerMethod
    private void setFrequencyColor(EnumColor color) throws ComputerException {
        this.validateSecurityIsPublic();
        this.computerGetFrequency().setColor(color);
    }

    @ComputerMethod
    private void incrementFrequencyColor() throws ComputerException {
        this.validateSecurityIsPublic();
        QIOFrequency frequency = this.computerGetFrequency();
        frequency.setColor((EnumColor)frequency.getColor().getNext());
    }

    @ComputerMethod
    private void decrementFrequencyColor() throws ComputerException {
        this.validateSecurityIsPublic();
        QIOFrequency frequency = this.computerGetFrequency();
        frequency.setColor((EnumColor)frequency.getColor().getPrevious());
    }
}

