/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache.type;

import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.common.lib.HashedFluid;
import mekanism.common.recipe.ingredient.creator.FluidStackIngredientCreator;
import mekanism.common.recipe.lookup.cache.type.NBTSensitiveInputCache;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidInputCache<RECIPE extends MekanismRecipe>
extends NBTSensitiveInputCache<Fluid, HashedFluid, FluidStack, FluidStackIngredient, RECIPE> {
    @Override
    public boolean mapInputs(RECIPE recipe, FluidStackIngredient inputIngredient) {
        if (inputIngredient instanceof FluidStackIngredientCreator.SingleFluidStackIngredient) {
            FluidStackIngredientCreator.SingleFluidStackIngredient single = (FluidStackIngredientCreator.SingleFluidStackIngredient)inputIngredient;
            HashedFluid input = HashedFluid.create(single.getInputRaw());
            this.addNbtInputCache(input, recipe);
        } else if (inputIngredient instanceof FluidStackIngredientCreator.TaggedFluidStackIngredient) {
            FluidStackIngredientCreator.TaggedFluidStackIngredient tagged = (FluidStackIngredientCreator.TaggedFluidStackIngredient)inputIngredient;
            for (Fluid input : tagged.getRawInput()) {
                this.addInputCache(input, recipe);
            }
        } else {
            if (inputIngredient instanceof FluidStackIngredientCreator.MultiFluidStackIngredient) {
                FluidStackIngredientCreator.MultiFluidStackIngredient multi = (FluidStackIngredientCreator.MultiFluidStackIngredient)inputIngredient;
                return this.mapMultiInputs(recipe, multi);
            }
            return true;
        }
        return false;
    }

    @Override
    protected Fluid createKey(FluidStack stack) {
        return stack.getFluid();
    }

    @Override
    protected HashedFluid createNbtKey(FluidStack stack) {
        return HashedFluid.raw(stack);
    }

    @Override
    public boolean isEmpty(FluidStack input) {
        return input.isEmpty();
    }
}

