/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup;

import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public interface IDoubleRecipeLookupHandler<INPUT_A, INPUT_B, RECIPE extends MekanismRecipe, INPUT_CACHE extends DoubleInputRecipeCache<INPUT_A, ?, INPUT_B, ?, RECIPE, ?, ?>>
extends IRecipeLookupHandler.IRecipeTypedLookupHandler<RECIPE, INPUT_CACHE> {
    default public boolean containsRecipeAB(INPUT_A inputA, INPUT_B inputB) {
        return ((DoubleInputRecipeCache)this.getRecipeType().getInputCache()).containsInputAB(this.getHandlerWorld(), inputA, inputB);
    }

    default public boolean containsRecipeBA(INPUT_A inputA, INPUT_B inputB) {
        return ((DoubleInputRecipeCache)this.getRecipeType().getInputCache()).containsInputBA(this.getHandlerWorld(), inputA, inputB);
    }

    default public boolean containsRecipeA(INPUT_A input) {
        return ((DoubleInputRecipeCache)this.getRecipeType().getInputCache()).containsInputA(this.getHandlerWorld(), input);
    }

    default public boolean containsRecipeB(INPUT_B input) {
        return ((DoubleInputRecipeCache)this.getRecipeType().getInputCache()).containsInputB(this.getHandlerWorld(), input);
    }

    @Nullable
    default public RECIPE findFirstRecipe(INPUT_A inputA, INPUT_B inputB) {
        return ((DoubleInputRecipeCache)this.getRecipeType().getInputCache()).findFirstRecipe(this.getHandlerWorld(), inputA, inputB);
    }

    @Nullable
    default public RECIPE findFirstRecipe(IInputHandler<INPUT_A> inputAHandler, IInputHandler<INPUT_B> inputBHandler) {
        return this.findFirstRecipe(inputAHandler.getInput(), inputBHandler.getInput());
    }

    public static interface FluidChemicalRecipeLookupHandler<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends MekanismRecipe>
    extends ObjectChemicalRecipeLookupHandler<FluidStack, CHEMICAL, STACK, RECIPE, InputRecipeCache.FluidChemical<CHEMICAL, STACK, RECIPE>> {
    }

    public static interface ItemChemicalRecipeLookupHandler<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends MekanismRecipe>
    extends ObjectChemicalRecipeLookupHandler<ItemStack, CHEMICAL, STACK, RECIPE, InputRecipeCache.ItemChemical<CHEMICAL, STACK, RECIPE>> {
    }

    public static interface ObjectChemicalRecipeLookupHandler<INPUT, CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends MekanismRecipe, INPUT_CACHE extends DoubleInputRecipeCache<INPUT, ?, STACK, ?, RECIPE, ?, ?>>
    extends IDoubleRecipeLookupHandler<INPUT, STACK, RECIPE, INPUT_CACHE> {
        @Override
        default public boolean containsRecipeBA(INPUT inputA, CHEMICAL inputB) {
            return this.containsRecipeBA(inputA, (CHEMICAL)ChemicalUtil.withAmount(inputB, 1L));
        }

        @Override
        default public boolean containsRecipeB(CHEMICAL input) {
            return this.containsRecipeB((CHEMICAL)ChemicalUtil.withAmount(input, 1L));
        }
    }

    public static interface DoubleItemRecipeLookupHandler<RECIPE extends MekanismRecipe>
    extends IDoubleRecipeLookupHandler<ItemStack, ItemStack, RECIPE, InputRecipeCache.DoubleItem<RECIPE>> {
    }
}

