/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public interface IMekanismRecipeTypeProvider<RECIPE extends MekanismRecipe, INPUT_CACHE extends IInputRecipeCache> {
    default public ResourceLocation getRegistryName() {
        return this.getRecipeType().getRegistryName();
    }

    public MekanismRecipeType<RECIPE, INPUT_CACHE> getRecipeType();

    default public INPUT_CACHE getInputCache() {
        return this.getRecipeType().getInputCache();
    }

    @Nonnull
    default public List<RECIPE> getRecipes(@Nullable Level world) {
        return this.getRecipeType().getRecipes(world);
    }

    default public Stream<RECIPE> stream(@Nullable Level world) {
        return this.getRecipes(world).stream();
    }

    @Nullable
    default public RECIPE findFirst(@Nullable Level world, Predicate<RECIPE> matchCriteria) {
        return (RECIPE)((MekanismRecipe)this.stream(world).filter(matchCriteria).findFirst().orElse(null));
    }

    default public boolean contains(@Nullable Level world, Predicate<RECIPE> matchCriteria) {
        return this.stream(world).anyMatch(matchCriteria);
    }
}

