/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.particle;

import mekanism.common.content.sps.SPSMultiblockData;
import mekanism.common.lib.Color;
import mekanism.common.lib.effect.CustomEffect;
import mekanism.common.lib.math.Quaternion;
import mekanism.common.util.MekanismUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class SPSOrbitEffect
extends CustomEffect {
    private static final ResourceLocation TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "sps_orbit_effect.png");
    private final Vec3 center;
    private final Vec3 start;
    private final Vec3 axis;
    private float speed = 0.5f;
    private final float radius;
    private SPSMultiblockData multiblock;

    public SPSOrbitEffect(SPSMultiblockData multiblock, Vec3 center) {
        super(TEXTURE, 1);
        this.multiblock = multiblock;
        this.center = center;
        this.radius = 1.0f + (float)this.rand.nextDouble();
        this.start = this.randVec().m_82490_((double)this.radius);
        this.pos = center.m_82549_(this.start);
        this.axis = this.randVec();
        this.scale = 0.01f + this.rand.nextFloat() * 0.04f;
        this.color = Color.rgbai(102, 215, 237, 240);
    }

    public void updateMultiblock(SPSMultiblockData multiblock) {
        this.multiblock = multiblock;
    }

    @Override
    public boolean tick() {
        if (super.tick()) {
            return true;
        }
        this.speed = (float)Math.log10(this.multiblock.lastReceivedEnergy.doubleValue());
        return !this.multiblock.isFormed();
    }

    @Override
    public Vec3 getPos(float partialTick) {
        return this.center.m_82549_((Vec3)Quaternion.rotate(this.start, this.axis, ((float)this.ticker + partialTick) * this.speed));
    }
}

