/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import javax.annotation.Nonnull;
import mekanism.api.RelativeSide;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketConfigurationUpdate
implements IMekanismPacket {
    private final ConfigurationPacket packetType;
    private final BlockPos pos;
    private TransmissionType transmission;
    private RelativeSide inputSide;
    private int clickType;

    public PacketConfigurationUpdate(@Nonnull ConfigurationPacket type, BlockPos pos, TransmissionType trans) {
        this.packetType = type;
        this.pos = pos;
        this.transmission = trans;
    }

    public PacketConfigurationUpdate(BlockPos pos, int click) {
        this.packetType = ConfigurationPacket.EJECT_COLOR;
        this.pos = pos;
        this.clickType = click;
    }

    public PacketConfigurationUpdate(BlockPos pos) {
        this.packetType = ConfigurationPacket.STRICT_INPUT;
        this.pos = pos;
    }

    public PacketConfigurationUpdate(@Nonnull ConfigurationPacket type, BlockPos pos, int click, RelativeSide inputSide, TransmissionType trans) {
        this.packetType = type;
        this.pos = pos;
        switch (this.packetType) {
            case EJECT: 
            case CLEAR_ALL: {
                this.transmission = trans;
                break;
            }
            case EJECT_COLOR: {
                this.clickType = click;
                break;
            }
            case SIDE_DATA: {
                this.clickType = click;
                this.inputSide = inputSide;
                this.transmission = trans;
                break;
            }
            case INPUT_COLOR: {
                this.clickType = click;
                this.inputSide = inputSide;
            }
        }
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)player.f_19853_, this.pos);
        if (tile instanceof ISideConfiguration) {
            ISideConfiguration config = (ISideConfiguration)tile;
            switch (this.packetType) {
                case EJECT: {
                    ConfigInfo info = config.getConfig().getConfig(this.transmission);
                    if (info == null) break;
                    info.setEjecting(!info.isEjecting());
                    WorldUtils.saveChunk(tile);
                    break;
                }
                case CLEAR_ALL: {
                    TileComponentConfig configComponent = config.getConfig();
                    ConfigInfo info = configComponent.getConfig(this.transmission);
                    if (info == null) break;
                    for (RelativeSide side : EnumUtils.SIDES) {
                        if (!info.isSideEnabled(side) || info.getDataType(side) == DataType.NONE) continue;
                        info.setDataType(DataType.NONE, side);
                        configComponent.sideChanged(this.transmission, side);
                    }
                    break;
                }
                case SIDE_DATA: {
                    TileComponentConfig configComponent = config.getConfig();
                    ConfigInfo info = configComponent.getConfig(this.transmission);
                    if (info == null) break;
                    DataType type = info.getDataType(this.inputSide);
                    boolean changed = false;
                    if (this.clickType == 0) {
                        changed = type != info.incrementDataType(this.inputSide);
                    } else if (this.clickType == 1) {
                        changed = type != info.decrementDataType(this.inputSide);
                    } else if (this.clickType == 2 && type != DataType.NONE) {
                        changed = true;
                        info.setDataType(DataType.NONE, this.inputSide);
                    }
                    if (!changed) break;
                    configComponent.sideChanged(this.transmission, this.inputSide);
                    break;
                }
                case EJECT_COLOR: {
                    TileComponentEjector ejector = config.getEjector();
                    switch (this.clickType) {
                        case 0: {
                            ejector.setOutputColor(TransporterUtils.increment(ejector.getOutputColor()));
                            break;
                        }
                        case 1: {
                            ejector.setOutputColor(TransporterUtils.decrement(ejector.getOutputColor()));
                            break;
                        }
                        case 2: {
                            ejector.setOutputColor(null);
                        }
                    }
                    break;
                }
                case INPUT_COLOR: {
                    TileComponentEjector ejector = config.getEjector();
                    switch (this.clickType) {
                        case 0: {
                            ejector.setInputColor(this.inputSide, TransporterUtils.increment(ejector.getInputColor(this.inputSide)));
                            break;
                        }
                        case 1: {
                            ejector.setInputColor(this.inputSide, TransporterUtils.decrement(ejector.getInputColor(this.inputSide)));
                            break;
                        }
                        case 2: {
                            ejector.setInputColor(this.inputSide, null);
                        }
                    }
                    break;
                }
                case STRICT_INPUT: {
                    TileComponentEjector ejector = config.getEjector();
                    ejector.setStrictInput(!ejector.hasStrictInput());
                }
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.packetType);
        buffer.m_130064_(this.pos);
        switch (this.packetType) {
            case EJECT: 
            case CLEAR_ALL: {
                buffer.m_130068_((Enum)this.transmission);
                break;
            }
            case SIDE_DATA: {
                buffer.m_130130_(this.clickType);
                buffer.m_130068_((Enum)this.inputSide);
                buffer.m_130068_((Enum)this.transmission);
                break;
            }
            case EJECT_COLOR: {
                buffer.m_130130_(this.clickType);
                break;
            }
            case INPUT_COLOR: {
                buffer.m_130130_(this.clickType);
                buffer.m_130068_((Enum)this.inputSide);
            }
        }
    }

    public static PacketConfigurationUpdate decode(FriendlyByteBuf buffer) {
        ConfigurationPacket packetType = (ConfigurationPacket)buffer.m_130066_(ConfigurationPacket.class);
        BlockPos pos = buffer.m_130135_();
        int clickType = 0;
        RelativeSide inputSide = null;
        TransmissionType transmission = null;
        switch (packetType) {
            case EJECT: 
            case CLEAR_ALL: {
                transmission = (TransmissionType)buffer.m_130066_(TransmissionType.class);
                break;
            }
            case SIDE_DATA: {
                clickType = buffer.m_130242_();
                inputSide = (RelativeSide)buffer.m_130066_(RelativeSide.class);
                transmission = (TransmissionType)buffer.m_130066_(TransmissionType.class);
                break;
            }
            case EJECT_COLOR: {
                clickType = buffer.m_130242_();
                break;
            }
            case INPUT_COLOR: {
                clickType = buffer.m_130242_();
                inputSide = (RelativeSide)buffer.m_130066_(RelativeSide.class);
            }
        }
        return new PacketConfigurationUpdate(packetType, pos, clickType, inputSide, transmission);
    }

    public static enum ConfigurationPacket {
        EJECT,
        SIDE_DATA,
        EJECT_COLOR,
        INPUT_COLOR,
        STRICT_INPUT,
        CLEAR_ALL;

    }
}

