/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.DataHandlerUtils;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IMekanismHeatHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.StackUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;

public class MultiblockCache<T extends MultiblockData>
implements IMekanismInventory,
IMekanismFluidHandler,
IMekanismStrictEnergyHandler,
IMekanismHeatHandler,
IGasTracker,
IInfusionTracker,
IPigmentTracker,
ISlurryTracker {
    private final List<IInventorySlot> inventorySlots = new ArrayList<IInventorySlot>();
    private final List<IExtendedFluidTank> fluidTanks = new ArrayList<IExtendedFluidTank>();
    private final List<IGasTank> gasTanks = new ArrayList<IGasTank>();
    private final List<IInfusionTank> infusionTanks = new ArrayList<IInfusionTank>();
    private final List<IPigmentTank> pigmentTanks = new ArrayList<IPigmentTank>();
    private final List<ISlurryTank> slurryTanks = new ArrayList<ISlurryTank>();
    private final List<IEnergyContainer> energyContainers = new ArrayList<IEnergyContainer>();
    private final List<IHeatCapacitor> heatCapacitors = new ArrayList<IHeatCapacitor>();

    public void apply(T data) {
        for (CacheSubstance<?, INBTSerializable<CompoundTag>> type : CacheSubstance.VALUES) {
            List<INBTSerializable<CompoundTag>> containers = type.getContainerList(data);
            if (containers == null) continue;
            List<INBTSerializable<CompoundTag>> cacheContainers = type.getContainerList(this);
            for (int i = 0; i < cacheContainers.size(); ++i) {
                if (i >= containers.size()) continue;
                containers.get(i).deserializeNBT((Tag)((CompoundTag)cacheContainers.get(i).serializeNBT()));
            }
        }
    }

    public void sync(T data) {
        for (CacheSubstance<?, INBTSerializable<CompoundTag>> type : CacheSubstance.VALUES) {
            List<INBTSerializable<CompoundTag>> containersToCopy = type.getContainerList(data);
            if (containersToCopy == null) continue;
            List<INBTSerializable<CompoundTag>> cacheContainers = type.getContainerList(this);
            if (cacheContainers.isEmpty()) {
                type.prefab(this, containersToCopy.size());
            }
            for (int i = 0; i < containersToCopy.size(); ++i) {
                type.sync(cacheContainers.get(i), containersToCopy.get(i));
            }
        }
    }

    public void load(CompoundTag nbtTags) {
        for (CacheSubstance<?, INBTSerializable<CompoundTag>> type : CacheSubstance.VALUES) {
            type.prefab(this, nbtTags.m_128451_(type.getTagKey() + "_stored"));
            DataHandlerUtils.readContainers(type.getContainerList(this), nbtTags.m_128437_(type.getTagKey(), 10));
        }
    }

    public void save(CompoundTag nbtTags) {
        for (CacheSubstance<?, INBTSerializable<CompoundTag>> type : CacheSubstance.VALUES) {
            nbtTags.m_128405_(type.getTagKey() + "_stored", type.getContainerList(this).size());
            nbtTags.m_128365_(type.getTagKey(), (Tag)DataHandlerUtils.writeContainers(type.getContainerList(this)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void merge(MultiblockCache<T> mergeCache, List<ItemStack> rejectedItems) {
        void var6_10;
        for (CacheSubstance<T, INBTSerializable<CompoundTag>> cacheSubstance : CacheSubstance.VALUES) {
            cacheSubstance.preHandleMerge(this, mergeCache);
        }
        rejectedItems.addAll(StackUtils.getMergeRejects(this.getInventorySlots(null), mergeCache.getInventorySlots(null)));
        StackUtils.merge(this.getInventorySlots(null), mergeCache.getInventorySlots(null));
        List<IExtendedFluidTank> cacheFluidTanks = this.getFluidTanks(null);
        for (int i = 0; i < cacheFluidTanks.size(); ++i) {
            StorageUtils.mergeTanks(cacheFluidTanks.get(i), mergeCache.getFluidTanks(null).get(i));
        }
        List<IGasTank> cacheGasTanks = this.getGasTanks(null);
        for (int i = 0; i < cacheGasTanks.size(); ++i) {
            StorageUtils.mergeTanks(cacheGasTanks.get(i), mergeCache.getGasTanks(null).get(i));
        }
        List<IInfusionTank> cacheInfusionTanks = this.getInfusionTanks(null);
        boolean bl = false;
        while (var6_10 < cacheInfusionTanks.size()) {
            StorageUtils.mergeTanks(cacheInfusionTanks.get((int)var6_10), mergeCache.getInfusionTanks(null).get((int)var6_10));
            ++var6_10;
        }
        List<IPigmentTank> list = this.getPigmentTanks(null);
        for (int i = 0; i < list.size(); ++i) {
            StorageUtils.mergeTanks(list.get(i), mergeCache.getPigmentTanks(null).get(i));
        }
        List<ISlurryTank> cacheSlurryTanks = this.getSlurryTanks(null);
        for (int i = 0; i < cacheSlurryTanks.size(); ++i) {
            StorageUtils.mergeTanks(cacheSlurryTanks.get(i), mergeCache.getSlurryTanks(null).get(i));
        }
        List<IEnergyContainer> cacheContainers = this.getEnergyContainers(null);
        for (int i = 0; i < cacheContainers.size(); ++i) {
            StorageUtils.mergeContainers(cacheContainers.get(i), mergeCache.getEnergyContainers(null).get(i));
        }
        List<IHeatCapacitor> cacheCapacitors = this.getHeatCapacitors(null);
        for (int i = 0; i < cacheCapacitors.size(); ++i) {
            StorageUtils.mergeContainers(cacheCapacitors.get(i), mergeCache.getHeatCapacitors(null).get(i));
        }
    }

    @Override
    public void onContentsChanged() {
    }

    @Override
    @Nonnull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.inventorySlots;
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    @Nonnull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasTanks;
    }

    @Override
    @Nonnull
    public List<IInfusionTank> getInfusionTanks(@Nullable Direction side) {
        return this.infusionTanks;
    }

    @Override
    @Nonnull
    public List<IPigmentTank> getPigmentTanks(@Nullable Direction side) {
        return this.pigmentTanks;
    }

    @Override
    @Nonnull
    public List<ISlurryTank> getSlurryTanks(@Nullable Direction side) {
        return this.slurryTanks;
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    @Override
    @Nonnull
    public List<IHeatCapacitor> getHeatCapacitors(Direction side) {
        return this.heatCapacitors;
    }

    public static abstract class CacheSubstance<HANDLER, ELEMENT> {
        public static final CacheSubstance<IMekanismInventory, IInventorySlot> ITEMS = new CacheSubstance<IMekanismInventory, IInventorySlot>("Items"){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.inventorySlots.add(BasicInventorySlot.at(cache, 0, 0));
            }

            @Override
            protected List<IInventorySlot> containerList(IMekanismInventory iMekanismInventory) {
                return iMekanismInventory.getInventorySlots(null);
            }

            @Override
            public void sync(IInventorySlot cache, IInventorySlot data) {
                cache.setStack(data.getStack());
            }
        };
        public static final CacheSubstance<IMekanismFluidHandler, IExtendedFluidTank> FLUID = new CacheSubstance<IMekanismFluidHandler, IExtendedFluidTank>("FluidTanks"){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.fluidTanks.add(BasicFluidTank.create(Integer.MAX_VALUE, cache));
            }

            @Override
            protected List<IExtendedFluidTank> containerList(IMekanismFluidHandler iMekanismFluidHandler) {
                return iMekanismFluidHandler.getFluidTanks(null);
            }

            @Override
            public void sync(IExtendedFluidTank cache, IExtendedFluidTank data) {
                cache.setStack(data.getFluid());
            }
        };
        public static final CacheSubstance<IGasTracker, IGasTank> GAS = new CacheSubstance<IGasTracker, IGasTank>("GasTanks"){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.gasTanks.add(ChemicalTankBuilder.GAS.createAllValid(Long.MAX_VALUE, cache));
            }

            @Override
            protected List<IGasTank> containerList(IGasTracker holder) {
                return holder.getGasTanks(null);
            }

            @Override
            public void sync(IGasTank cache, IGasTank data) {
                cache.setStack((GasStack)data.getStack());
            }
        };
        public static final CacheSubstance<IInfusionTracker, IInfusionTank> INFUSION = new CacheSubstance<IInfusionTracker, IInfusionTank>("InfusionTanks"){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.infusionTanks.add(ChemicalTankBuilder.INFUSION.createAllValid(Long.MAX_VALUE, cache));
            }

            @Override
            protected List<IInfusionTank> containerList(IInfusionTracker holder) {
                return holder.getInfusionTanks(null);
            }

            @Override
            public void sync(IInfusionTank cache, IInfusionTank data) {
                cache.setStack((InfusionStack)data.getStack());
            }
        };
        public static final CacheSubstance<IPigmentTracker, IPigmentTank> PIGMENT = new CacheSubstance<IPigmentTracker, IPigmentTank>("PigmentTanks"){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.pigmentTanks.add(ChemicalTankBuilder.PIGMENT.createAllValid(Long.MAX_VALUE, cache));
            }

            @Override
            protected List<IPigmentTank> containerList(IPigmentTracker holder) {
                return holder.getPigmentTanks(null);
            }

            @Override
            public void sync(IPigmentTank cache, IPigmentTank data) {
                cache.setStack((PigmentStack)data.getStack());
            }
        };
        public static final CacheSubstance<ISlurryTracker, ISlurryTank> SLURRY = new CacheSubstance<ISlurryTracker, ISlurryTank>("SlurryTanks"){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.slurryTanks.add(ChemicalTankBuilder.SLURRY.createAllValid(Long.MAX_VALUE, cache));
            }

            @Override
            protected List<ISlurryTank> containerList(ISlurryTracker holder) {
                return holder.getSlurryTanks(null);
            }

            @Override
            public void sync(ISlurryTank cache, ISlurryTank data) {
                cache.setStack((SlurryStack)data.getStack());
            }
        };
        public static final CacheSubstance<IMekanismStrictEnergyHandler, IEnergyContainer> ENERGY = new CacheSubstance<IMekanismStrictEnergyHandler, IEnergyContainer>("EnergyContainers"){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.energyContainers.add(BasicEnergyContainer.create(FloatingLong.MAX_VALUE, cache));
            }

            @Override
            protected List<IEnergyContainer> containerList(IMekanismStrictEnergyHandler holder) {
                return holder.getEnergyContainers(null);
            }

            @Override
            public void sync(IEnergyContainer cache, IEnergyContainer data) {
                cache.setEnergy(data.getEnergy());
            }
        };
        public static final CacheSubstance<IMekanismHeatHandler, IHeatCapacitor> HEAT = new CacheSubstance<IMekanismHeatHandler, IHeatCapacitor>("HeatCapacitors"){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.heatCapacitors.add(BasicHeatCapacitor.create(1.0, null, cache));
            }

            @Override
            protected List<IHeatCapacitor> containerList(IMekanismHeatHandler holder) {
                return holder.getHeatCapacitors(null);
            }

            @Override
            public void sync(IHeatCapacitor cache, IHeatCapacitor data) {
                cache.setHeat(data.getHeat());
                if (cache instanceof BasicHeatCapacitor) {
                    BasicHeatCapacitor heatCapacitor = (BasicHeatCapacitor)cache;
                    heatCapacitor.setHeatCapacity(data.getHeatCapacity(), false);
                }
            }
        };
        public static final CacheSubstance<?, INBTSerializable<CompoundTag>>[] VALUES = new CacheSubstance[]{ITEMS, FLUID, GAS, INFUSION, PIGMENT, SLURRY, ENERGY, HEAT};
        private final String tagKey;

        public CacheSubstance(String tagKey) {
            this.tagKey = tagKey;
        }

        protected abstract void defaultPrefab(MultiblockCache<?> var1);

        protected abstract List<ELEMENT> containerList(HANDLER var1);

        private void prefab(MultiblockCache<?> cache, int count) {
            for (int i = 0; i < count; ++i) {
                this.defaultPrefab(cache);
            }
        }

        public List<ELEMENT> getContainerList(Object holder) {
            return this.containerList(holder);
        }

        public abstract void sync(ELEMENT var1, ELEMENT var2);

        public void preHandleMerge(MultiblockCache<?> cache, MultiblockCache<?> merge) {
            int diff = this.getContainerList(merge).size() - this.getContainerList(cache).size();
            if (diff > 0) {
                this.prefab(cache, diff);
            }
        }

        public String getTagKey() {
            return this.tagKey;
        }
    }
}

