/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.content;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.zencode.scriptrun.ScriptRunConfiguration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.robit.RobitSkin;
import mekanism.common.integration.crafttweaker.CrTConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CrTContentUtils {
    private static Map<ResourceLocation, Gas> queuedGases = new HashMap<ResourceLocation, Gas>();
    private static Map<ResourceLocation, InfuseType> queuedInfuseTypes = new HashMap<ResourceLocation, InfuseType>();
    private static Map<ResourceLocation, Pigment> queuedPigments = new HashMap<ResourceLocation, Pigment>();
    private static Map<ResourceLocation, Slurry> queuedSlurries = new HashMap<ResourceLocation, Slurry>();
    private static Map<ResourceLocation, RobitSkin> queuedRobitSkins = new HashMap<ResourceLocation, RobitSkin>();

    public static void queueGasForRegistration(ResourceLocation registryName, Gas gas) {
        CrTContentUtils.queueForRegistration("Gas", queuedGases, registryName, gas);
    }

    public static void queueInfuseTypeForRegistration(ResourceLocation registryName, InfuseType infuseType) {
        CrTContentUtils.queueForRegistration("Infuse Type", queuedInfuseTypes, registryName, infuseType);
    }

    public static void queuePigmentForRegistration(ResourceLocation registryName, Pigment pigment) {
        CrTContentUtils.queueForRegistration("Pigment", queuedPigments, registryName, pigment);
    }

    public static void queueSlurryForRegistration(ResourceLocation registryName, Slurry slurry) {
        CrTContentUtils.queueForRegistration("Slurry", queuedSlurries, registryName, slurry);
    }

    public static void queueRobitSkinForRegistration(ResourceLocation registryName, RobitSkin skin) {
        CrTContentUtils.queueForRegistration("Robit Skin", queuedRobitSkins, registryName, skin);
    }

    private static <V extends IForgeRegistryEntry<V>> void queueForRegistration(String type, @Nullable Map<ResourceLocation, V> queued, ResourceLocation registryName, V element) {
        if (queued != null) {
            if (queued.put(registryName, element) == null) {
                CraftTweakerAPI.LOGGER.info("Queueing {} '{}' for registration.", (Object)type, (Object)registryName);
            } else {
                CraftTweakerAPI.LOGGER.warn("Registration for {} '{}' is already queued, skipping duplicate.", (Object)type, (Object)registryName);
            }
        }
    }

    public static void registerCrTGases(RegistryEvent.Register<Gas> event) {
        try {
            CraftTweakerAPI.getScriptRunManager().createScriptRun(new ScriptRunConfiguration("mekanismcontent", CrTConstants.CONTENT_LOADER_SOURCE_ID, ScriptRunConfiguration.RunKind.EXECUTE)).execute();
        }
        catch (Throwable e) {
            CraftTweakerAPI.LOGGER.error("Unable to register chemicals due to an error.", e);
        }
        CrTContentUtils.registerQueued(event, queuedGases, () -> {
            queuedGases = null;
        }, "Gas", "gases");
    }

    public static void registerCrTInfuseTypes(RegistryEvent.Register<InfuseType> event) {
        CrTContentUtils.registerQueued(event, queuedInfuseTypes, () -> {
            queuedInfuseTypes = null;
        }, "Infuse Type", "infuse types");
    }

    public static void registerCrTPigments(RegistryEvent.Register<Pigment> event) {
        CrTContentUtils.registerQueued(event, queuedPigments, () -> {
            queuedPigments = null;
        }, "Pigment", "pigments");
    }

    public static void registerCrTSlurries(RegistryEvent.Register<Slurry> event) {
        CrTContentUtils.registerQueued(event, queuedSlurries, () -> {
            queuedSlurries = null;
        }, "Slurry", "slurries");
    }

    public static void registerCrTRobitSkins(RegistryEvent.Register<RobitSkin> event) {
        CrTContentUtils.registerQueued(event, queuedRobitSkins, () -> {
            queuedRobitSkins = null;
        }, "Robit Skin", "robit skins");
    }

    private static <V extends IForgeRegistryEntry<V>> void registerQueued(RegistryEvent.Register<V> event, Map<ResourceLocation, V> queued, Runnable setNull, String type, String plural) {
        if (queued != null) {
            setNull.run();
            int count = queued.size();
            CraftTweakerAPI.LOGGER.info("Registering {} custom {}.", (Object)count, (Object)(count == 1 ? type.toLowerCase(Locale.ROOT) : plural));
            for (Map.Entry<ResourceLocation, V> entry : queued.entrySet()) {
                ResourceLocation registryName = entry.getKey();
                event.getRegistry().register((IForgeRegistryEntry)((IForgeRegistryEntry)entry.getValue()).setRegistryName(registryName));
                CraftTweakerAPI.LOGGER.info("Registered {}: '{}'.", (Object)type, (Object)registryName);
            }
        }
    }
}

