/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.bracket;

import com.blamejared.crafttweaker.api.annotation.BracketResolver;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.function.Function;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.gear.ModuleData;
import mekanism.api.robit.RobitSkin;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.api.BracketHandlers")
public class CrTBracketHandlers {
    @ZenCodeType.Method
    @BracketResolver(value="gas")
    public static ICrTChemicalStack.ICrTGasStack getGasStack(String tokens) {
        return CrTBracketHandlers.getChemicalStack("gas", tokens, MekanismAPI.gasRegistry(), CrTUtils::stackFromGas);
    }

    @ZenCodeType.Method
    @BracketResolver(value="infuse_type")
    public static ICrTChemicalStack.ICrTInfusionStack getInfusionStack(String tokens) {
        return CrTBracketHandlers.getChemicalStack("infuse_type", tokens, MekanismAPI.infuseTypeRegistry(), CrTUtils::stackFromInfuseType);
    }

    @ZenCodeType.Method
    @BracketResolver(value="pigment")
    public static ICrTChemicalStack.ICrTPigmentStack getPigmentStack(String tokens) {
        return CrTBracketHandlers.getChemicalStack("pigment", tokens, MekanismAPI.pigmentRegistry(), CrTUtils::stackFromPigment);
    }

    @ZenCodeType.Method
    @BracketResolver(value="slurry")
    public static ICrTChemicalStack.ICrTSlurryStack getSlurryStack(String tokens) {
        return CrTBracketHandlers.getChemicalStack("slurry", tokens, MekanismAPI.slurryRegistry(), CrTUtils::stackFromSlurry);
    }

    @ZenCodeType.Method
    @BracketResolver(value="robit_skin")
    public static RobitSkin getRobitSkin(String tokens) {
        return CrTBracketHandlers.getValue("robit_skin", tokens, MekanismAPI.robitSkinRegistry());
    }

    @ZenCodeType.Method
    @BracketResolver(value="module_data")
    public static ModuleData<?> getModuleData(String tokens) {
        return CrTBracketHandlers.getValue("module_data", tokens, MekanismAPI.moduleRegistry());
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, CRT_STACK extends ICrTChemicalStack<CHEMICAL, ?, CRT_STACK>> CRT_STACK getChemicalStack(String bracket, String tokens, IForgeRegistry<CHEMICAL> registry, Function<CHEMICAL, CRT_STACK> getter) {
        return (CRT_STACK)((ICrTChemicalStack)getter.apply((Chemical)CrTBracketHandlers.getValue(bracket, tokens, registry)));
    }

    private static <V extends IForgeRegistryEntry<V>> V getValue(String bracket, String tokens, IForgeRegistry<V> registry) {
        ResourceLocation registryName = ResourceLocation.m_135820_((String)tokens);
        if (registryName == null) {
            String typeName = bracket.replace("_", " ");
            throw new IllegalArgumentException("Could not get " + typeName + " for <" + bracket + ":" + tokens + ">. Syntax is <" + bracket + ":modid:" + bracket + "_name>");
        }
        if (!registry.containsKey(registryName)) {
            String typeName = bracket.replace("_", " ");
            throw new IllegalArgumentException("Could not get " + typeName + " for <" + bracket + ":" + tokens + ">, " + typeName + " does not appear to exist!");
        }
        return (V)registry.getValue(registryName);
    }
}

