/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer.opencomputers2;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import li.cil.oc2.api.bus.device.rpc.RPCInvocation;
import li.cil.oc2.api.bus.device.rpc.RPCMethod;
import li.cil.oc2.api.bus.device.rpc.RPCParameter;
import mekanism.common.integration.computer.BoundComputerMethod;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.opencomputers2.MekanismRPCParameter;
import mekanism.common.integration.computer.opencomputers2.OC2ArgumentWrapper;
import net.minecraft.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MekanismRPCMethod
implements RPCMethod {
    private final BoundComputerMethod.ThreadAwareMethodHandle methodHandle;
    private final RPCParameter[] parameters;
    private final Class<?> returnType;
    final BoundComputerMethod method;
    private final String name;

    MekanismRPCMethod(String name, BoundComputerMethod method, BoundComputerMethod.ThreadAwareMethodHandle methodHandle) {
        this.method = method;
        this.methodHandle = methodHandle;
        this.name = name;
        this.returnType = OC2ArgumentWrapper.wrapType(methodHandle.returnType());
        List<Class<?>> parameterTypes = methodHandle.parameterTypes();
        List<String> parameterNames = methodHandle.paramNames();
        int parameterNameCount = parameterNames.size();
        int params = parameterTypes.size();
        RPCParameter[] parameters = new RPCParameter[params];
        for (int i = 0; i < params; ++i) {
            Class<?> parameterType = OC2ArgumentWrapper.wrapType(parameterTypes.get(i));
            parameters[i] = new MekanismRPCParameter(parameterType, i < parameterNameCount ? parameterNames.get(i) : null);
        }
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSynchronized() {
        return !this.methodHandle.threadSafe();
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public RPCParameter[] getParameters() {
        return this.parameters;
    }

    @Nullable
    public Object invoke(RPCInvocation invocation) throws ComputerException {
        return this.invoke(new OC2ArgumentWrapper(invocation));
    }

    @Nullable
    Object invoke(OC2ArgumentWrapper argumentWrapper) throws ComputerException {
        BoundComputerMethod.SelectedMethodInfo selected = this.method.findMatchingImplementation(argumentWrapper, this.methodHandle);
        if (selected == null) {
            throw argumentWrapper.error("Parameters do not match signature of %s.", this.getName());
        }
        return this.method.run(argumentWrapper, selected);
    }
}

