/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import mekanism.api.math.FloatingLong;
import mekanism.common.integration.computer.BoundComputerMethod;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.ComputerMethodMapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.util.UnitDisplayUtils;

public class ComputerEnergyHelper {
    public static Map<String, BoundComputerMethod> getMethods() {
        LinkedHashMap<String, BoundComputerMethod> boundMethods = new LinkedHashMap<String, BoundComputerMethod>();
        ComputerMethodMapper.INSTANCE.getAndBindToHandler(ComputerEnergyHelper.class, null, boundMethods);
        return boundMethods;
    }

    @ComputerMethod
    private static FloatingLong joulesToFE(FloatingLong joules) throws ComputerException {
        return ComputerEnergyHelper.convert(UnitDisplayUtils.EnergyUnit.FORGE_ENERGY, joules, true);
    }

    @ComputerMethod
    private static FloatingLong feToJoules(FloatingLong fe) throws ComputerException {
        return ComputerEnergyHelper.convert(UnitDisplayUtils.EnergyUnit.FORGE_ENERGY, fe, false);
    }

    @ComputerMethod(requiredMods={"ic2"})
    private static FloatingLong joulesToEU(FloatingLong joules) throws ComputerException {
        return ComputerEnergyHelper.convert(UnitDisplayUtils.EnergyUnit.ELECTRICAL_UNITS, joules, true);
    }

    @ComputerMethod(requiredMods={"ic2"})
    private static FloatingLong euToJoules(FloatingLong eu) throws ComputerException {
        return ComputerEnergyHelper.convert(UnitDisplayUtils.EnergyUnit.ELECTRICAL_UNITS, eu, false);
    }

    private static FloatingLong convert(UnitDisplayUtils.EnergyUnit type, FloatingLong energy, boolean to) throws ComputerException {
        if (type.isEnabled()) {
            return to ? type.convertToAsFloatingLong(energy) : type.convertFrom(energy);
        }
        String name = type.name().replace('_', ' ').toLowerCase(Locale.ROOT);
        String between = to ? "Joules and " + name : name + " and Joules";
        throw new ComputerException("Conversion between " + between + " is disabled in Mekanism's config or missing required mods.");
    }
}

