/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismEntityTypes;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;

public class EntityFlame
extends Projectile
implements IEntityAdditionalSpawnData {
    public static final int LIFESPAN = 80;
    private static final int DAMAGE = 10;
    private ItemFlamethrower.FlamethrowerMode mode = ItemFlamethrower.FlamethrowerMode.COMBAT;

    public EntityFlame(EntityType<EntityFlame> type, Level world) {
        super(type, world);
    }

    @Nullable
    public static EntityFlame create(Player player) {
        EntityFlame flame = (EntityFlame)((EntityType)MekanismEntityTypes.FLAME.get()).m_20615_(player.f_19853_);
        if (flame == null) {
            return null;
        }
        Pos3D playerPos = new Pos3D(player.m_20185_(), player.m_20188_() - 0.1, player.m_20189_());
        Pos3D flameVec = new Pos3D(1.0, 1.0, 1.0);
        Vec3 lookVec = player.m_20154_();
        flameVec = flameVec.multiply(lookVec).yRot(6.0f);
        Vec3 mergedVec = playerPos.m_82549_(flameVec);
        flame.m_6034_(mergedVec.f_82479_, mergedVec.f_82480_, mergedVec.f_82481_);
        flame.m_5602_((Entity)player);
        ItemStack selected = player.m_150109_().m_36056_();
        flame.mode = ((ItemFlamethrower)selected.m_41720_()).getMode(selected);
        flame.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.5f, 1.0f);
        BlockHitResult blockRayTrace = player.f_19853_.m_45547_(new ClipContext((Vec3)playerPos, mergedVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)flame));
        if (blockRayTrace.m_6662_() != HitResult.Type.MISS) {
            flame.m_6532_((HitResult)blockRayTrace);
        }
        return flame;
    }

    public void m_6075_() {
        if (!this.m_6084_()) {
            return;
        }
        ++this.f_19797_;
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        Vec3 motion = this.m_20184_();
        this.m_20343_(this.m_20185_() + motion.m_7096_(), this.m_20186_() + motion.m_7098_(), this.m_20189_() + motion.m_7094_());
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.calculateVector();
        if (this.f_19797_ > 80) {
            this.m_146870_();
        }
    }

    private void calculateVector() {
        EntityHitResult entityResult;
        Vec3 localVec = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vec3 motion = this.m_20184_();
        Vec3 motionVec = new Vec3(this.m_20185_() + motion.m_7096_() * 2.0, this.m_20186_() + motion.m_7098_() * 2.0, this.m_20189_() + motion.m_7094_() * 2.0);
        BlockHitResult blockRayTrace = this.f_19853_.m_45547_(new ClipContext(localVec, motionVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this));
        localVec = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        motionVec = new Vec3(this.m_20185_() + motion.m_7096_(), this.m_20186_() + motion.m_7098_(), this.m_20189_() + motion.m_7094_());
        if (blockRayTrace.m_6662_() != HitResult.Type.MISS) {
            motionVec = blockRayTrace.m_82450_();
        }
        this.m_6532_((HitResult)((entityResult = ProjectileUtil.m_37304_((Level)this.f_19853_, (Entity)this, (Vec3)localVec, (Vec3)motionVec, (AABB)this.m_142469_().m_82369_(this.m_20184_()).m_82377_(1.0, 1.0, 1.0), (Predicate)EntitySelector.f_20408_)) == null ? blockRayTrace : entityResult));
    }

    /*
     * Unable to fully structure code
     */
    protected void m_5790_(EntityHitResult entityResult) {
        block5: {
            entity = entityResult.m_82443_();
            if (entity instanceof Player) {
                player = (Player)entity;
                owner = this.m_37282_();
                if (player.m_150110_().f_35934_ || owner instanceof Player && !(o = (Player)owner).m_7099_(player)) {
                    return;
                }
            }
            if (entity.m_5825_()) break block5;
            if (!(entity instanceof ItemEntity)) ** GOTO lbl-1000
            item = (ItemEntity)entity;
            if (this.mode == ItemFlamethrower.FlamethrowerMode.HEAT) {
                if (entity.f_19797_ > 100 && !this.smeltItem(item)) {
                    this.burn(entity);
                }
            } else lbl-1000:
            // 2 sources

            {
                this.burn(entity);
            }
        }
        this.m_146870_();
    }

    protected void m_8060_(@Nonnull BlockHitResult blockRayTrace) {
        boolean hitFluid;
        super.m_8060_(blockRayTrace);
        BlockPos hitPos = blockRayTrace.m_82425_();
        Direction hitSide = blockRayTrace.m_82434_();
        BlockState hitState = this.f_19853_.m_8055_(hitPos);
        boolean bl = hitFluid = !hitState.m_60819_().m_76178_();
        if (!this.f_19853_.f_46443_ && MekanismConfig.general.aestheticWorldDamage.get() && !hitFluid) {
            if (this.mode == ItemFlamethrower.FlamethrowerMode.HEAT) {
                Entity owner = this.m_37282_();
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    this.smeltBlock(player, hitState, hitPos, hitSide);
                }
            } else if (this.mode == ItemFlamethrower.FlamethrowerMode.INFERNO) {
                Entity owner = this.m_37282_();
                BlockPos sidePos = hitPos.m_142300_(hitSide);
                if (CampfireBlock.m_51321_((BlockState)hitState)) {
                    this.tryPlace(owner, hitPos, hitSide, (BlockState)hitState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
                } else if (BaseFireBlock.m_49255_((Level)this.f_19853_, (BlockPos)sidePos, (Direction)hitSide)) {
                    this.tryPlace(owner, sidePos, hitSide, BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)sidePos));
                } else if (hitState.isFlammable((BlockGetter)this.f_19853_, hitPos, hitSide)) {
                    LivingEntity livingEntity;
                    hitState.onCaughtFire(this.f_19853_, hitPos, hitSide, owner instanceof LivingEntity ? (livingEntity = (LivingEntity)owner) : null);
                    if (hitState.m_60734_() instanceof TntBlock) {
                        this.f_19853_.m_7471_(hitPos, false);
                    }
                }
            }
        }
        if (hitFluid) {
            this.spawnParticlesAt(this.m_142538_());
            this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
        }
        this.m_146870_();
    }

    private boolean tryPlace(@Nullable Entity shooter, BlockPos pos, Direction hitSide, BlockState newState) {
        BlockSnapshot blockSnapshot = BlockSnapshot.create((ResourceKey)this.f_19853_.m_46472_(), (LevelAccessor)this.f_19853_, (BlockPos)pos);
        this.f_19853_.m_46597_(pos, newState);
        if (ForgeEventFactory.onBlockPlace((Entity)shooter, (BlockSnapshot)blockSnapshot, (Direction)hitSide)) {
            this.f_19853_.restoringBlockSnapshots = true;
            blockSnapshot.restore(true, false);
            this.f_19853_.restoringBlockSnapshots = false;
            return false;
        }
        return true;
    }

    private boolean smeltItem(ItemEntity item) {
        Optional recipe = MekanismRecipeType.getRecipeFor(RecipeType.f_44108_, new SimpleContainer(new ItemStack[]{item.m_32055_()}), this.f_19853_);
        if (recipe.isPresent()) {
            ItemStack result = ((SmeltingRecipe)recipe.get()).m_8043_();
            item.m_32045_(StackUtils.size(result, item.m_32055_().m_41613_()));
            item.f_19797_ = 0;
            this.spawnParticlesAt(item.m_142538_());
            this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private void smeltBlock(Player shooter, BlockState hitState, BlockPos blockPos, Direction hitSide) {
        Optional recipe;
        if (hitState.m_60795_()) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)hitState.m_60734_());
        if (stack.m_41619_()) {
            return;
        }
        try {
            recipe = MekanismRecipeType.getRecipeFor(RecipeType.f_44108_, new SimpleContainer(new ItemStack[]{stack}), this.f_19853_);
        }
        catch (Exception e) {
            return;
        }
        if (recipe.isPresent() && !this.f_19853_.f_46443_) {
            if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.f_19853_, blockPos, hitState, shooter))) {
                return;
            }
            ItemStack result = ((SmeltingRecipe)recipe.get()).m_8043_();
            if (!(result.m_41720_() instanceof BlockItem) || !this.tryPlace((Entity)shooter, blockPos, hitSide, Block.m_49814_((Item)result.m_41720_()).m_49966_())) {
                this.f_19853_.m_7471_(blockPos, false);
                ItemEntity item = new ItemEntity(this.f_19853_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, result.m_41777_());
                item.m_20334_(0.0, 0.0, 0.0);
                this.f_19853_.m_7967_((Entity)item);
            }
            this.f_19853_.m_46796_(2001, blockPos, Block.m_49956_((BlockState)hitState));
            this.spawnParticlesAt((ServerLevel)this.f_19853_, blockPos);
        }
    }

    private void burn(Entity entity) {
        if (!(entity instanceof ItemEntity) || MekanismConfig.gear.flamethrowerDestroyItems.get()) {
            entity.m_20254_(20);
            entity.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_()), 10.0f);
        }
    }

    private void spawnParticlesAt(BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + ((double)this.f_19796_.nextFloat() - 0.5), (double)pos.m_123342_() + ((double)this.f_19796_.nextFloat() - 0.5), (double)pos.m_123343_() + ((double)this.f_19796_.nextFloat() - 0.5), 0.0, 0.0, 0.0);
        }
    }

    private void spawnParticlesAt(ServerLevel world, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            world.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + ((double)this.f_19796_.nextFloat() - 0.5), (double)pos.m_123342_() + ((double)this.f_19796_.nextFloat() - 0.5), (double)pos.m_123343_() + ((double)this.f_19796_.nextFloat() - 0.5), 3, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void m_8097_() {
    }

    public void m_7378_(@Nonnull CompoundTag nbtTags) {
        super.m_7378_(nbtTags);
        NBTUtils.setEnumIfPresent(nbtTags, "mode", ItemFlamethrower.FlamethrowerMode::byIndexStatic, mode -> {
            this.mode = mode;
        });
    }

    public void m_7380_(@Nonnull CompoundTag nbtTags) {
        super.m_7380_(nbtTags);
        NBTUtils.writeEnum(nbtTags, "mode", this.mode);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf dataStream) {
        dataStream.m_130068_((Enum)this.mode);
    }

    public void readSpawnData(FriendlyByteBuf dataStream) {
        this.mode = (ItemFlamethrower.FlamethrowerMode)dataStream.m_130066_(ItemFlamethrower.FlamethrowerMode.class);
    }
}

