/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.fluid.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ItemStackMekanismFluidHandler
extends ItemCapabilityWrapper.ItemCapability
implements IMekanismFluidHandler,
IFluidHandlerItem {
    protected List<IExtendedFluidTank> tanks;

    protected abstract List<IExtendedFluidTank> getInitialTanks();

    @Override
    protected void init() {
        super.init();
        this.tanks = this.getInitialTanks();
    }

    @Override
    protected void load() {
        super.load();
        ItemDataUtils.readContainers(this.getStack(), "FluidTanks", this.getFluidTanks(null));
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.tanks;
    }

    @Override
    public void onContentsChanged() {
        ItemDataUtils.writeContainers(this.getStack(), "FluidTanks", this.getFluidTanks(null));
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.getStack();
    }

    @Override
    protected void gatherCapabilityResolvers(Consumer<ICapabilityResolver> consumer) {
        consumer.accept(BasicCapabilityResolver.constant(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, this));
    }
}

