/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.energy.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.resolver.EnergyCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ItemStackEnergyHandler
extends ItemCapabilityWrapper.ItemCapability
implements IMekanismStrictEnergyHandler {
    protected List<IEnergyContainer> energyContainers;

    protected abstract List<IEnergyContainer> getInitialContainers();

    @Override
    protected void init() {
        super.init();
        this.energyContainers = this.getInitialContainers();
    }

    @Override
    protected void load() {
        super.load();
        ItemDataUtils.readContainers(this.getStack(), "EnergyContainers", this.getEnergyContainers(null));
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    @Override
    public void onContentsChanged() {
        ItemDataUtils.writeContainers(this.getStack(), "EnergyContainers", this.getEnergyContainers(null));
    }

    @Override
    protected void gatherCapabilityResolvers(Consumer<ICapabilityResolver> consumer) {
        consumer.accept(new EnergyCapabilityResolver(this));
    }
}

