/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.states;

import java.util.ArrayList;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeState;
import mekanism.common.block.states.FluidLogType;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.block.states.IStateStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Contract;

public class BlockStateHelper {
    public static final BooleanProperty storageProperty = BooleanProperty.m_61465_((String)"storage");
    public static final EnumProperty<FluidLogType> FLUID_LOGGED = EnumProperty.m_61587_((String)"fluid_logged", FluidLogType.class);
    public static final BlockBehaviour.StatePredicate NEVER_PREDICATE = (state, world, pos) -> false;

    private BlockStateHelper() {
    }

    public static BlockState getDefaultState(@Nonnull BlockState state) {
        Block block = state.m_60734_();
        for (Attribute attr : Attribute.getAll(block)) {
            if (!(attr instanceof AttributeState)) continue;
            AttributeState atr = (AttributeState)attr;
            state = atr.getDefaultState(state);
        }
        if (block instanceof IStateFluidLoggable) {
            IStateFluidLoggable fluidLoggable = (IStateFluidLoggable)block;
            state = fluidLoggable.setState(state, Fluids.f_76191_);
        }
        return state;
    }

    public static void fillBlockStateContainer(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        ArrayList properties = new ArrayList();
        for (Attribute attr : Attribute.getAll(block)) {
            if (!(attr instanceof AttributeState)) continue;
            AttributeState atr = (AttributeState)attr;
            atr.fillBlockStateContainer(block, properties);
        }
        if (block instanceof IStateStorage) {
            properties.add((Property<?>)storageProperty);
        }
        if (block instanceof IStateFluidLoggable) {
            IStateFluidLoggable fluidLoggable = (IStateFluidLoggable)block;
            properties.add((Property<?>)fluidLoggable.getFluidLoggedProperty());
        }
        if (!properties.isEmpty()) {
            builder.m_61104_(properties.toArray(new Property[0]));
        }
    }

    public static BlockBehaviour.Properties applyLightLevelAdjustments(BlockBehaviour.Properties properties) {
        return BlockStateHelper.applyLightLevelAdjustments(properties, state -> {
            Block block = state.m_60734_();
            if (block instanceof IStateFluidLoggable) {
                IStateFluidLoggable fluidLoggable = (IStateFluidLoggable)block;
                return fluidLoggable.getFluid((BlockState)state).m_76152_().getAttributes().getLuminosity();
            }
            return 0;
        });
    }

    public static BlockBehaviour.Properties applyLightLevelAdjustments(BlockBehaviour.Properties properties, ToIntFunction<BlockState> toApply) {
        ToIntFunction existingLightLevelFunction = properties.f_60886_;
        return properties.m_60953_(state -> Math.max(existingLightLevelFunction.applyAsInt(state), toApply.applyAsInt((BlockState)state)));
    }

    @Contract(value="_, null, _ -> null")
    public static BlockState getStateForPlacement(Block block, @Nullable BlockState state, BlockPlaceContext context) {
        return BlockStateHelper.getStateForPlacement(block, state, (LevelAccessor)context.m_43725_(), context.m_8083_(), context.m_43723_(), context.m_43719_());
    }

    @Contract(value="_, null, _, _, _, _ -> null")
    public static BlockState getStateForPlacement(Block block, @Nullable BlockState state, @Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nullable Player player, @Nonnull Direction face) {
        if (state == null) {
            return null;
        }
        for (Attribute attr : Attribute.getAll(block)) {
            if (!(attr instanceof AttributeState)) continue;
            AttributeState atr = (AttributeState)attr;
            state = atr.getStateForPlacement(block, state, world, pos, player, face);
        }
        if (block instanceof IStateFluidLoggable) {
            IStateFluidLoggable fluidLoggable = (IStateFluidLoggable)block;
            FluidState fluidState = world.m_6425_(pos);
            state = fluidLoggable.setState(state, fluidState.m_76152_());
        }
        return state;
    }

    public static BlockState copyStateData(BlockState oldState, IBlockProvider newBlockProvider) {
        return BlockStateHelper.copyStateData(oldState, newBlockProvider.getBlock().m_49966_());
    }

    public static BlockState copyStateData(BlockState oldState, BlockState newState) {
        Block oldBlock = oldState.m_60734_();
        Block newBlock = newState.m_60734_();
        for (Attribute attr : Attribute.getAll(oldBlock)) {
            if (!(attr instanceof AttributeState)) continue;
            AttributeState atr = (AttributeState)attr;
            newState = atr.copyStateData(oldState, newState);
        }
        if (oldBlock instanceof IStateStorage && newBlock instanceof IStateStorage) {
            newState = (BlockState)newState.m_61124_((Property)storageProperty, (Comparable)((Boolean)oldState.m_61143_((Property)storageProperty)));
        }
        if (newBlock instanceof IStateFluidLoggable) {
            IStateFluidLoggable newFluidLoggable = (IStateFluidLoggable)newBlock;
            FluidState oldFluidState = oldState.m_60819_();
            if (!oldFluidState.m_76178_()) {
                newState = newFluidLoggable.setState(newState, oldFluidState.m_76152_());
            }
        }
        return newState;
    }
}

