/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.data.ChemicalRenderData;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;

@ParametersAreNonnullByDefault
public class RenderThermoelectricBoiler
extends MekanismTileEntityRenderer<TileEntityBoilerCasing> {
    public RenderThermoelectricBoiler(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void render(TileEntityBoilerCasing tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        BoilerMultiblockData multiblock;
        if (tile.isMaster() && (multiblock = (BoilerMultiblockData)tile.getMultiblock()).isFormed() && multiblock.renderLocation != null && multiblock.upperRenderLocation != null) {
            int glow;
            RenderData data;
            int height;
            BlockPos pos = tile.m_58899_();
            VertexConsumer buffer = null;
            if (!multiblock.waterTank.isEmpty() && (height = multiblock.upperRenderLocation.m_123342_() - 1 - multiblock.renderLocation.m_123342_()) >= 1) {
                data = new FluidRenderData(multiblock.waterTank.getFluid());
                ((FluidRenderData)data).location = multiblock.renderLocation;
                ((FluidRenderData)data).height = height;
                ((FluidRenderData)data).length = multiblock.length();
                ((FluidRenderData)data).width = multiblock.width();
                glow = ((FluidRenderData)data).calculateGlowLight(MekanismRenderer.FULL_SKY_LIGHT);
                matrix.m_85836_();
                matrix.m_85837_((double)(((FluidRenderData)data).location.m_123341_() - pos.m_123341_()), (double)(((FluidRenderData)data).location.m_123342_() - pos.m_123342_()), (double)(((FluidRenderData)data).location.m_123343_() - pos.m_123343_()));
                buffer = renderer.m_6299_(Sheets.m_110792_());
                MekanismRenderer.Model3D model = ModelRenderer.getModel(data, multiblock.prevWaterScale);
                MekanismRenderer.renderObject(model, matrix, buffer, ((FluidRenderData)data).getColorARGB(multiblock.prevWaterScale), glow, overlayLight, this.getFaceDisplay(data, model));
                matrix.m_85849_();
                MekanismRenderer.renderValves(matrix, buffer, multiblock.valves, (FluidRenderData)data, pos, glow, overlayLight, this.isInsideMultiblock(data));
            }
            if (!multiblock.steamTank.isEmpty() && (height = multiblock.renderLocation.m_123342_() + multiblock.height() - 2 - multiblock.upperRenderLocation.m_123342_()) >= 1) {
                data = new ChemicalRenderData.GasRenderData((GasStack)multiblock.steamTank.getStack());
                ((ChemicalRenderData.GasRenderData)data).location = multiblock.upperRenderLocation;
                ((ChemicalRenderData.GasRenderData)data).height = height;
                ((ChemicalRenderData.GasRenderData)data).length = multiblock.length();
                ((ChemicalRenderData.GasRenderData)data).width = multiblock.width();
                if (buffer == null) {
                    buffer = renderer.m_6299_(Sheets.m_110792_());
                }
                glow = data.calculateGlowLight(MekanismRenderer.FULL_SKY_LIGHT);
                matrix.m_85836_();
                matrix.m_85837_((double)(((ChemicalRenderData.GasRenderData)data).location.m_123341_() - pos.m_123341_()), (double)(((ChemicalRenderData.GasRenderData)data).location.m_123342_() - pos.m_123342_()), (double)(((ChemicalRenderData.GasRenderData)data).location.m_123343_() - pos.m_123343_()));
                MekanismRenderer.Model3D gasModel = ModelRenderer.getModel(data, 1.0);
                MekanismRenderer.renderObject(gasModel, matrix, buffer, ((ChemicalRenderData)data).getColorARGB(multiblock.prevSteamScale), glow, overlayLight, this.getFaceDisplay(data, gasModel));
                matrix.m_85849_();
            }
        }
    }

    @Override
    protected String getProfilerSection() {
        return "thermoelectricBoiler";
    }

    public boolean shouldRenderOffScreen(TileEntityBoilerCasing tile) {
        if (tile.isMaster()) {
            BoilerMultiblockData multiblock = (BoilerMultiblockData)tile.getMultiblock();
            return multiblock.isFormed() && multiblock.renderLocation != null && multiblock.upperRenderLocation != null;
        }
        return false;
    }
}

