/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.machine.TileEntityDimensionalStabilizer;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
public class RenderDimensionalStabilizer
extends MekanismTileEntityRenderer<TileEntityDimensionalStabilizer> {
    private static MekanismRenderer.Model3D model;
    private static final int[] colors;

    public static void resetCachedVisuals() {
        model = null;
    }

    public RenderDimensionalStabilizer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void render(TileEntityDimensionalStabilizer stabilizer, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        if (model == null) {
            model = new MekanismRenderer.Model3D();
            model.setTexture(MekanismRenderer.whiteIcon);
            model.setSideRender(Direction.UP, false);
            model.setSideRender(Direction.DOWN, false);
            RenderDimensionalStabilizer.model.minX = 0.0f;
            RenderDimensionalStabilizer.model.minY = 0.0f;
            RenderDimensionalStabilizer.model.minZ = 0.0f;
            RenderDimensionalStabilizer.model.maxX = 1.0f;
            RenderDimensionalStabilizer.model.maxY = 1.0f;
            RenderDimensionalStabilizer.model.maxZ = 1.0f;
        }
        boolean[][][] allRenderSides = new boolean[5][5][5];
        for (int x = 0; x < allRenderSides.length; ++x) {
            boolean[][] rowRenderSides = allRenderSides[x];
            for (int z = 0; z < rowRenderSides.length; ++z) {
                boolean[] previousRenderSides;
                if (!stabilizer.isChunkLoadingAt(x, z)) continue;
                boolean[] renderSides = rowRenderSides[z];
                Arrays.fill(renderSides, true);
                if (x > 0 && (previousRenderSides = allRenderSides[x - 1][z])[Direction.EAST.m_122416_()]) {
                    renderSides[Direction.WEST.m_122416_()] = false;
                    previousRenderSides[Direction.EAST.m_122416_()] = false;
                }
                if (z <= 0 || !(previousRenderSides = rowRenderSides[z - 1])[Direction.SOUTH.m_122416_()]) continue;
                renderSides[Direction.NORTH.m_122416_()] = false;
                previousRenderSides[Direction.SOUTH.m_122416_()] = false;
            }
        }
        Level level = stabilizer.m_58904_();
        int minY = level.m_141937_();
        int height = level.m_151558_() - minY;
        BlockPos pos = stabilizer.m_58899_();
        int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)pos.m_123343_());
        VertexConsumer buffer = renderer.m_6299_(Sheets.m_110792_());
        for (RenderPiece piece : this.calculateRenderPieces(allRenderSides)) {
            model.setSideRender(Direction.NORTH, piece.renderNorth);
            model.setSideRender(Direction.EAST, piece.renderEast);
            model.setSideRender(Direction.SOUTH, piece.renderSouth);
            model.setSideRender(Direction.WEST, piece.renderWest);
            int xChunkOffset = piece.x - 2;
            int zChunkOffset = piece.z - 2;
            ChunkPos startChunk = new ChunkPos(chunkX + xChunkOffset, chunkZ + zChunkOffset);
            ChunkPos endChunk = new ChunkPos(startChunk.f_45578_ + piece.xLength - 1, startChunk.f_45579_ + piece.zLength - 1);
            double xShift = 0.01;
            double zShift = 0.01;
            float xScaleShift = 0.02f;
            float zScaleShift = 0.02f;
            if (piece.renderEast && piece.renderWest && !piece.renderNorth) {
                zShift = -0.01;
                zScaleShift = piece.renderSouth ? 0.0f : -0.02f;
            } else if (piece.renderNorth && !piece.renderSouth) {
                zScaleShift = 0.0f;
            } else if (piece.renderNorth && piece.renderWest && !piece.renderEast) {
                xScaleShift = 0.0f;
            } else if (piece.renderNorth && !piece.renderWest) {
                xShift = -0.01;
                xScaleShift = piece.renderEast ? 0.0f : -0.02f;
            } else if (piece.renderSouth && piece.renderEast != piece.renderWest) {
                zShift = -0.01;
                zScaleShift = 0.0f;
            }
            matrix.m_85836_();
            matrix.m_85837_((double)(startChunk.m_45604_() - pos.m_123341_()) + xShift, (double)(minY - pos.m_123342_()), (double)(startChunk.m_45605_() - pos.m_123343_()) + zShift);
            matrix.m_85841_((float)(16 * piece.xLength) - xScaleShift, (float)height, (float)(16 * piece.zLength) - zScaleShift);
            RenderResizableCuboid.FaceDisplay faceDisplay = this.isInsideBounds(startChunk.m_45604_(), Double.NEGATIVE_INFINITY, startChunk.m_45605_(), endChunk.m_45608_() + 1, Double.POSITIVE_INFINITY, endChunk.m_45609_() + 1) ? RenderResizableCuboid.FaceDisplay.BACK : RenderResizableCuboid.FaceDisplay.BOTH;
            MekanismRenderer.renderObject(model, matrix, buffer, colors, 0xF000F0, overlayLight, faceDisplay);
            matrix.m_85849_();
        }
    }

    @Override
    protected String getProfilerSection() {
        return "dimensionalStabilizer";
    }

    public boolean shouldRenderOffScreen(TileEntityDimensionalStabilizer tile) {
        return true;
    }

    public boolean shouldRender(TileEntityDimensionalStabilizer tile, Vec3 camera) {
        return tile.isClientRendering() && tile.canDisplayVisuals() && super.m_142756_((BlockEntity)tile, camera);
    }

    private List<RenderPiece> calculateRenderPieces(boolean[][][] allRenderSides) {
        record MinimalRowPieceData(int x, boolean renderEast, boolean renderWest) {
        }
        record MinimalColumnPieceData(int z, int zLength, boolean renderNorth, boolean renderSouth) {
        }
        HashMap<MinimalColumnPieceData, List> columnData = new HashMap<MinimalColumnPieceData, List>();
        for (int x = 0; x < allRenderSides.length; ++x) {
            int zLength;
            boolean[][] rowRenderSides = allRenderSides[x];
            for (int z = 0; z < rowRenderSides.length; z += zLength) {
                boolean[] nextColumnRenderSides;
                zLength = 1;
                boolean[] renderSides = rowRenderSides[z];
                if (!renderSides[4]) continue;
                boolean renderNorth = renderSides[Direction.NORTH.m_122416_()];
                boolean renderSouth = renderSides[Direction.SOUTH.m_122416_()];
                boolean renderEast = renderSides[Direction.EAST.m_122416_()];
                boolean renderWest = renderSides[Direction.WEST.m_122416_()];
                while (!renderSouth && z + zLength < rowRenderSides.length && renderEast == (nextColumnRenderSides = rowRenderSides[z + zLength])[Direction.EAST.m_122416_()] && renderWest == nextColumnRenderSides[Direction.WEST.m_122416_()]) {
                    ++zLength;
                    renderSouth = nextColumnRenderSides[Direction.SOUTH.m_122416_()];
                }
                columnData.computeIfAbsent(new MinimalColumnPieceData(z, zLength, renderNorth, renderSouth), piece -> new ArrayList(5)).add(new MinimalRowPieceData(x, renderEast, renderWest));
            }
        }
        ArrayList<RenderPiece> pieces = new ArrayList<RenderPiece>();
        for (Map.Entry entry : columnData.entrySet()) {
            int xLength;
            MinimalColumnPieceData minimalColumnPiece = (MinimalColumnPieceData)entry.getKey();
            List rows = (List)entry.getValue();
            for (int row = 0; row < rows.size(); row += xLength) {
                xLength = 1;
                MinimalRowPieceData minimalRowPiece = (MinimalRowPieceData)rows.get(row);
                boolean renderEast = minimalRowPiece.renderEast;
                while (!renderEast && row + xLength < rows.size()) {
                    MinimalRowPieceData nextRowPiece = (MinimalRowPieceData)rows.get(row + xLength);
                    if (minimalRowPiece.x + xLength != nextRowPiece.x) break;
                    ++xLength;
                    renderEast = nextRowPiece.renderEast;
                }
                pieces.add(new RenderPiece(minimalRowPiece.x, xLength, minimalColumnPiece.z, minimalColumnPiece.zLength, minimalColumnPiece.renderNorth, minimalColumnPiece.renderSouth, renderEast, minimalRowPiece.renderWest));
            }
        }
        return pieces;
    }

    static {
        colors = new int[EnumUtils.DIRECTIONS.length];
        RenderDimensionalStabilizer.colors[Direction.NORTH.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.82f);
        RenderDimensionalStabilizer.colors[Direction.SOUTH.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.82f);
        RenderDimensionalStabilizer.colors[Direction.WEST.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.78f);
        RenderDimensionalStabilizer.colors[Direction.EAST.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.78f);
    }

    private record RenderPiece(int x, int xLength, int z, int zLength, boolean renderNorth, boolean renderSouth, boolean renderEast, boolean renderWest) {
    }
}

