/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;

@ParametersAreNonnullByDefault
public class RenderDigitalMiner
extends MekanismTileEntityRenderer<TileEntityDigitalMiner> {
    private static MekanismRenderer.Model3D model;
    private static final int[] colors;

    public static void resetCachedVisuals() {
        model = null;
    }

    public RenderDigitalMiner(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void render(TileEntityDigitalMiner miner, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        if (miner.isClientRendering() && miner.canDisplayVisuals()) {
            if (model == null) {
                model = new MekanismRenderer.Model3D();
                model.setTexture(MekanismRenderer.whiteIcon);
                RenderDigitalMiner.model.minX = 0.0f;
                RenderDigitalMiner.model.minY = 0.0f;
                RenderDigitalMiner.model.minZ = 0.0f;
                RenderDigitalMiner.model.maxX = 1.0f;
                RenderDigitalMiner.model.maxY = 1.0f;
                RenderDigitalMiner.model.maxZ = 1.0f;
            }
            matrix.m_85836_();
            matrix.m_85837_((double)(-miner.getRadius()) + 0.01, (double)(miner.getMinY() - miner.m_58899_().m_123342_()) + 0.01, (double)(-miner.getRadius()) + 0.01);
            float diameter = (float)miner.getDiameter() - 0.02f;
            matrix.m_85841_(diameter, (float)(miner.getMaxY() - miner.getMinY()) - 0.02f, diameter);
            RenderResizableCuboid.FaceDisplay faceDisplay = this.isInsideBounds(miner.m_58899_().m_123341_() - miner.getRadius(), miner.getMinY(), miner.m_58899_().m_123343_() - miner.getRadius(), miner.m_58899_().m_123341_() + miner.getRadius() + 1, miner.getMaxY(), miner.m_58899_().m_123343_() + miner.getRadius() + 1) ? RenderResizableCuboid.FaceDisplay.BACK : RenderResizableCuboid.FaceDisplay.BOTH;
            MekanismRenderer.renderObject(model, matrix, renderer.m_6299_(Sheets.m_110792_()), colors, 0xF000F0, overlayLight, faceDisplay);
            matrix.m_85849_();
        }
    }

    @Override
    protected String getProfilerSection() {
        return "digitalMiner";
    }

    public boolean shouldRenderOffScreen(TileEntityDigitalMiner tile) {
        return true;
    }

    static {
        colors = new int[EnumUtils.DIRECTIONS.length];
        RenderDigitalMiner.colors[Direction.DOWN.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.82f);
        RenderDigitalMiner.colors[Direction.UP.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.82f);
        RenderDigitalMiner.colors[Direction.NORTH.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.8f);
        RenderDigitalMiner.colors[Direction.SOUTH.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.8f);
        RenderDigitalMiner.colors[Direction.WEST.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.78f);
        RenderDigitalMiner.colors[Direction.EAST.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.78f);
    }
}

