/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import mekanism.client.render.lib.Vertex;
import mekanism.common.lib.Color;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class Quad {
    private static final VertexFormat FORMAT = DefaultVertexFormat.f_85811_;
    private static final int SIZE = DefaultVertexFormat.f_85811_.m_86023_().size();
    private final Vertex[] vertices;
    private Direction side;
    private TextureAtlasSprite sprite;
    private int tintIndex = -1;
    private boolean applyDiffuseLighting;

    public Quad(TextureAtlasSprite sprite, Direction side, Vertex[] vertices) {
        this(sprite, side, vertices, -1, false);
    }

    public Quad(TextureAtlasSprite sprite, Direction side, Vertex[] vertices, int tintIndex, boolean applyDiffuseLighting) {
        this.sprite = sprite;
        this.side = side;
        this.vertices = vertices;
        this.tintIndex = tintIndex;
        this.applyDiffuseLighting = applyDiffuseLighting;
    }

    public Quad(BakedQuad quad) {
        this.vertices = new Vertex[4];
        quad.pipe((IVertexConsumer)new BakedQuadUnpacker());
    }

    public TextureAtlasSprite getTexture() {
        return this.sprite;
    }

    public void setTexture(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    public void vertexTransform(Consumer<Vertex> transformation) {
        for (Vertex v : this.vertices) {
            transformation.accept(v);
        }
    }

    public Quad transform(QuadTransformation ... transformations) {
        for (QuadTransformation transform : transformations) {
            transform.transform(this);
        }
        return this;
    }

    public Vertex[] getVertices() {
        return this.vertices;
    }

    public void setSide(Direction side) {
        this.side = side;
    }

    public Direction getSide() {
        return this.side;
    }

    public boolean getApplyDiffuseLighting() {
        return this.applyDiffuseLighting;
    }

    public void setApplyDiffuseLighting(boolean applyDiffuseLighting) {
        this.applyDiffuseLighting = applyDiffuseLighting;
    }

    public BakedQuad bake() {
        int[] ret = new int[FORMAT.m_86017_() * 4];
        for (int v = 0; v < this.vertices.length; ++v) {
            float[][] packed = this.vertices[v].pack(FORMAT);
            for (int e = 0; e < SIZE; ++e) {
                LightUtil.pack((float[])packed[e], (int[])ret, (VertexFormat)DefaultVertexFormat.f_85811_, (int)v, (int)e);
            }
        }
        return new BakedQuad(ret, this.tintIndex, this.side, this.sprite, this.applyDiffuseLighting);
    }

    public Quad copy() {
        Vertex[] newVertices = new Vertex[4];
        for (int i = 0; i < 4; ++i) {
            newVertices[i] = this.vertices[i].copy();
        }
        return new Quad(this.sprite, this.side, newVertices, this.tintIndex, this.applyDiffuseLighting);
    }

    public Quad flip() {
        Vertex[] flipped = new Vertex[4];
        flipped[3] = this.vertices[0].copy().normal(this.vertices[0].getNormal().m_82490_(-1.0));
        flipped[2] = this.vertices[1].copy().normal(this.vertices[1].getNormal().m_82490_(-1.0));
        flipped[1] = this.vertices[2].copy().normal(this.vertices[2].getNormal().m_82490_(-1.0));
        flipped[0] = this.vertices[3].copy().normal(this.vertices[3].getNormal().m_82490_(-1.0));
        return new Quad(this.sprite, this.side.m_122424_(), flipped, this.tintIndex, this.applyDiffuseLighting);
    }

    private class BakedQuadUnpacker
    implements IVertexConsumer {
        private Vertex vertex = new Vertex();
        private int vertexIndex = 0;

        private BakedQuadUnpacker() {
        }

        @Nonnull
        public VertexFormat getVertexFormat() {
            return FORMAT;
        }

        public void setQuadTint(int tint) {
            Quad.this.tintIndex = tint;
        }

        public void setQuadOrientation(@Nonnull Direction orientation) {
            Quad.this.side = orientation;
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
            Quad.this.applyDiffuseLighting = diffuse;
        }

        public void setTexture(@Nonnull TextureAtlasSprite texture) {
            Quad.this.sprite = texture;
        }

        public void put(int elementIndex, float ... data) {
            VertexFormatElement element = (VertexFormatElement)FORMAT.m_86023_().get(elementIndex);
            float f0 = data.length >= 1 ? data[0] : 0.0f;
            float f1 = data.length >= 2 ? data[1] : 0.0f;
            float f2 = data.length >= 3 ? data[2] : 0.0f;
            float f3 = data.length >= 4 ? data[3] : 0.0f;
            switch (element.m_86048_()) {
                case POSITION: {
                    this.vertex.pos(new Vec3((double)f0, (double)f1, (double)f2));
                    break;
                }
                case NORMAL: {
                    this.vertex.normal(new Vec3((double)f0, (double)f1, (double)f2));
                    break;
                }
                case COLOR: {
                    this.vertex.color(Color.rgbad(f0, f1, f2, f3));
                    break;
                }
                case UV: {
                    if (element.m_86049_() == 0) {
                        this.vertex.texRaw(f0, f1);
                        break;
                    }
                    if (element.m_86049_() != 2) break;
                    this.vertex.lightRaw(f0, f1);
                }
            }
            if (elementIndex == SIZE - 1) {
                Quad.this.vertices[this.vertexIndex++] = this.vertex;
                this.vertex = new Vertex();
            }
        }
    }

    public static class Builder {
        private TextureAtlasSprite texture;
        private final Direction side;
        private Vec3 vec1;
        private Vec3 vec2;
        private Vec3 vec3;
        private Vec3 vec4;
        private float minU;
        private float minV;
        private float maxU;
        private float maxV;
        private float lightU;
        private float lightV;
        private int tintIndex = -1;
        private boolean applyDiffuseLighting;
        private boolean contractUVs = true;

        public Builder(TextureAtlasSprite texture, Direction side) {
            this.texture = texture;
            this.side = side;
        }

        public Builder light(float u, float v) {
            this.lightU = u;
            this.lightV = v;
            return this;
        }

        public Builder uv(float minU, float minV, float maxU, float maxV) {
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
            return this;
        }

        public Builder tex(TextureAtlasSprite texture) {
            this.texture = texture;
            return this;
        }

        public Builder tint(int tintIndex) {
            this.tintIndex = tintIndex;
            return this;
        }

        public Builder applyDiffuseLighting(boolean applyDiffuseLighting) {
            this.applyDiffuseLighting = applyDiffuseLighting;
            return this;
        }

        public Builder contractUVs(boolean contractUVs) {
            this.contractUVs = contractUVs;
            return this;
        }

        public Builder pos(Vec3 tl, Vec3 bl, Vec3 br, Vec3 tr) {
            this.vec1 = tl;
            this.vec2 = bl;
            this.vec3 = br;
            this.vec4 = tr;
            return this;
        }

        public Builder rect(Vec3 start, double width, double height) {
            return this.rect(start, width, height, 0.0625);
        }

        public Builder rect(Vec3 start, double width, double height, double scale) {
            start = start.m_82490_(scale);
            return this.pos(start.m_82520_(0.0, height * scale, 0.0), start, start.m_82520_(width * scale, 0.0, 0.0), start.m_82520_(width * scale, height * scale, 0.0));
        }

        public Quad build() {
            Vertex[] vertices = new Vertex[4];
            Vec3 normal = this.vec3.m_82546_(this.vec2).m_82537_(this.vec1.m_82546_(this.vec2)).m_82541_();
            vertices[0] = Vertex.create(this.vec1, normal, this.texture, this.minU, this.minV).light(this.lightU, this.lightV);
            vertices[1] = Vertex.create(this.vec2, normal, this.texture, this.minU, this.maxV).light(this.lightU, this.lightV);
            vertices[2] = Vertex.create(this.vec3, normal, this.texture, this.maxU, this.maxV).light(this.lightU, this.lightV);
            vertices[3] = Vertex.create(this.vec4, normal, this.texture, this.maxU, this.minV).light(this.lightU, this.lightV);
            Quad quad = new Quad(this.texture, this.side, vertices, this.tintIndex, this.applyDiffuseLighting);
            if (this.contractUVs) {
                QuadUtils.contractUVs(quad);
            }
            return quad;
        }
    }
}

