/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.robit.RobitSkin;
import mekanism.client.RobitSpriteUploader;
import mekanism.client.model.MekanismModelCache;
import mekanism.common.Mekanism;
import mekanism.common.entity.EntityRobit;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;

public class RenderRobit
extends MobRenderer<EntityRobit, RobitModelWrapper> {
    public RenderRobit(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new RobitModelWrapper(), 0.5f);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull EntityRobit robit) {
        return RobitSpriteUploader.ATLAS_LOCATION;
    }

    public static class RobitModelWrapper
    extends EntityModel<EntityRobit> {
        @Nullable
        private EntityRobit robit;

        RobitModelWrapper() {
        }

        public void setupAnim(@Nonnull EntityRobit robit, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.robit = robit;
        }

        public void m_7695_(@Nonnull PoseStack matrix, @Nonnull VertexConsumer builder, int light, int overlayLight, float red, float green, float blue, float alpha) {
            if (this.robit == null) {
                return;
            }
            RobitSkin skin = this.robit.getSkin();
            BakedModel model = MekanismModelCache.INSTANCE.getRobitSkin(skin);
            if (model == null) {
                Mekanism.logger.warn("Robit with skin: {} does not have a model.", (Object)skin.getRegistryName());
            } else {
                matrix.m_85836_();
                matrix.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                matrix.m_85837_(-0.5, -1.5, -0.5);
                PoseStack.Pose last = matrix.m_85850_();
                for (BakedQuad quad : model.getQuads(null, null, this.robit.f_19853_.f_46441_, this.robit.getModelData())) {
                    builder.putBulkData(last, quad, red, green, blue, alpha, light, overlayLight);
                }
                matrix.m_85849_();
            }
            this.robit = null;
        }
    }
}

