/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.text.EnumColor;
import mekanism.api.tier.BaseTier;
import mekanism.client.SpecialColors;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.model.baked.DigitalMinerBakedModel;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.data.ValveRenderData;
import mekanism.client.render.item.block.RenderFluidTankItem;
import mekanism.client.render.lib.ColorAtlas;
import mekanism.client.render.tileentity.RenderDigitalMiner;
import mekanism.client.render.tileentity.RenderDimensionalStabilizer;
import mekanism.client.render.tileentity.RenderFluidTank;
import mekanism.client.render.tileentity.RenderNutritionalLiquifier;
import mekanism.client.render.tileentity.RenderPigmentMixer;
import mekanism.client.render.tileentity.RenderTeleporter;
import mekanism.client.render.transmitter.RenderLogisticalTransporter;
import mekanism.client.render.transmitter.RenderMechanicalPipe;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.Mekanism;
import mekanism.common.lib.Color;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="mekanism", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class MekanismRenderer {
    public static final int FULL_LIGHT = 0xF000F0;
    public static final int FULL_SKY_LIGHT = LightTexture.m_109885_((int)0, (int)15);
    public static TextureAtlasSprite energyIcon;
    public static TextureAtlasSprite heatIcon;
    public static TextureAtlasSprite whiteIcon;
    public static TextureAtlasSprite teleporterPortal;
    public static TextureAtlasSprite redstoneTorch;
    public static TextureAtlasSprite redstonePulse;
    public static final Map<TransmissionType, TextureAtlasSprite> overlays;

    public static TextureAtlasSprite getBaseFluidTexture(@Nonnull Fluid fluid, @Nonnull FluidType type) {
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getAttributes().getStillTexture() : fluid.getAttributes().getFlowingTexture();
        return MekanismRenderer.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getFluidTexture(@Nonnull FluidStack fluidStack, @Nonnull FluidType type) {
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getAttributes().getStillTexture(fluidStack) : fluid.getAttributes().getFlowingTexture(fluidStack);
        return MekanismRenderer.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getChemicalTexture(@Nonnull Chemical<?> chemical) {
        return MekanismRenderer.getSprite(chemical.getIcon());
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(spriteLocation);
    }

    public static void prepFlowing(Model3D model, @Nonnull FluidStack fluid) {
        Model3D.SpriteInfo still = new Model3D.SpriteInfo(MekanismRenderer.getFluidTexture(fluid, FluidType.STILL), 16);
        Model3D.SpriteInfo flowing = new Model3D.SpriteInfo(MekanismRenderer.getFluidTexture(fluid, FluidType.FLOWING), 8);
        model.setTextures(still, still, flowing, flowing, flowing, flowing);
    }

    public static void prepSingleFaceModelSize(Model3D model, Direction face) {
        switch (face) {
            case DOWN: {
                model.minX = 0.0f;
                model.maxX = 1.0f;
                model.minY = -0.01f;
                model.maxY = -0.001f;
                model.minZ = 0.0f;
                model.maxZ = 1.0f;
                break;
            }
            case UP: {
                model.minX = 0.0f;
                model.maxX = 1.0f;
                model.minY = 1.001f;
                model.maxY = 1.01f;
                model.minZ = 0.0f;
                model.maxZ = 1.0f;
                break;
            }
            case NORTH: {
                model.minX = 0.0f;
                model.maxX = 1.0f;
                model.minY = 0.0f;
                model.maxY = 1.0f;
                model.minZ = -0.01f;
                model.maxZ = -0.001f;
                break;
            }
            case SOUTH: {
                model.minX = 0.0f;
                model.maxX = 1.0f;
                model.minY = 0.0f;
                model.maxY = 1.0f;
                model.minZ = 1.001f;
                model.maxZ = 1.01f;
                break;
            }
            case WEST: {
                model.minX = -0.01f;
                model.maxX = -0.001f;
                model.minY = 0.0f;
                model.maxY = 1.0f;
                model.minZ = 0.0f;
                model.maxZ = 1.0f;
                break;
            }
            case EAST: {
                model.minX = 1.001f;
                model.maxX = 1.01f;
                model.minY = 0.0f;
                model.maxY = 1.0f;
                model.minZ = 0.0f;
                model.maxZ = 1.0f;
            }
        }
    }

    public static void renderObject(@Nullable Model3D object, @Nonnull PoseStack matrix, VertexConsumer buffer, int argb, int light, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay) {
        MekanismRenderer.renderObject(object, matrix, buffer, argb, light, overlay, faceDisplay, true);
    }

    public static void renderObject(@Nullable Model3D object, @Nonnull PoseStack matrix, VertexConsumer buffer, int argb, int light, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay, boolean fakeDisableDiffuse) {
        if (object != null) {
            RenderResizableCuboid.renderCube(object, matrix, buffer, argb, light, overlay, faceDisplay, fakeDisableDiffuse);
        }
    }

    public static void renderObject(@Nullable Model3D object, @Nonnull PoseStack matrix, VertexConsumer buffer, int[] colors, int light, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay) {
        if (object != null) {
            RenderResizableCuboid.renderCube(object, matrix, buffer, colors, light, overlay, faceDisplay, true);
        }
    }

    public static void renderValves(PoseStack matrix, VertexConsumer buffer, Set<IValveHandler.ValveData> valves, FluidRenderData data, BlockPos pos, int glow, int overlay, BooleanSupplier inMultiblock) {
        if (!valves.isEmpty()) {
            RenderResizableCuboid.FaceDisplay faceDisplay = inMultiblock.getAsBoolean() ? RenderResizableCuboid.FaceDisplay.BOTH : RenderResizableCuboid.FaceDisplay.FRONT;
            for (IValveHandler.ValveData valveData : valves) {
                matrix.m_85836_();
                matrix.m_85837_((double)(valveData.location.m_123341_() - pos.m_123341_()), (double)(valveData.location.m_123342_() - pos.m_123342_()), (double)(valveData.location.m_123343_() - pos.m_123343_()));
                MekanismRenderer.renderObject(ModelRenderer.getValveModel(ValveRenderData.get(data, valveData)), matrix, buffer, data.getColorARGB(), glow, overlay, faceDisplay);
                matrix.m_85849_();
            }
        }
    }

    public static void resetColor() {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void color(int color) {
        RenderSystem.m_157429_((float)MekanismRenderer.getRed(color), (float)MekanismRenderer.getGreen(color), (float)MekanismRenderer.getBlue(color), (float)MekanismRenderer.getAlpha(color));
    }

    public static void color(ColorAtlas.ColorRegistryObject colorRO) {
        MekanismRenderer.color(colorRO.get());
    }

    public static void color(Color color) {
        RenderSystem.m_157429_((float)color.rf(), (float)color.gf(), (float)color.bf(), (float)color.af());
    }

    public static void color(@Nonnull FluidStack fluid) {
        if (!fluid.isEmpty()) {
            MekanismRenderer.color(fluid.getFluid().getAttributes().getColor(fluid));
        }
    }

    public static void color(@Nonnull ChemicalStack<?> chemicalStack) {
        if (!chemicalStack.isEmpty()) {
            MekanismRenderer.color(chemicalStack.getType());
        }
    }

    public static void color(@Nonnull Chemical<?> chemical) {
        if (!chemical.isEmptyType()) {
            int color = chemical.getTint();
            RenderSystem.m_157429_((float)MekanismRenderer.getRed(color), (float)MekanismRenderer.getGreen(color), (float)MekanismRenderer.getBlue(color), (float)1.0f);
        }
    }

    public static void color(@Nonnull BaseTier tier) {
        MekanismRenderer.color(tier.getColor());
    }

    public static void color(@Nullable EnumColor color) {
        MekanismRenderer.color(color, 1.0f);
    }

    public static void color(@Nullable EnumColor color, float alpha) {
        if (color != null) {
            RenderSystem.m_157429_((float)color.getColor(0), (float)color.getColor(1), (float)color.getColor(2), (float)alpha);
        }
    }

    public static int getColorARGB(EnumColor color, float alpha) {
        return MekanismRenderer.getColorARGB(color.getRgbCode()[0], color.getRgbCode()[1], color.getRgbCode()[2], alpha);
    }

    public static int getColorARGB(@Nonnull FluidStack fluidStack) {
        return fluidStack.getFluid().getAttributes().getColor(fluidStack);
    }

    public static int getColorARGB(@Nonnull FluidStack fluidStack, float fluidScale) {
        if (fluidStack.isEmpty()) {
            return -1;
        }
        int color = MekanismRenderer.getColorARGB(fluidStack);
        if (fluidStack.getFluid().getAttributes().isGaseous(fluidStack)) {
            return MekanismRenderer.getColorARGB(MekanismRenderer.getRed(color), MekanismRenderer.getGreen(color), MekanismRenderer.getBlue(color), Math.min(1.0f, fluidScale + 0.2f));
        }
        return color;
    }

    public static int getColorARGB(@Nonnull ChemicalStack<?> stack, float scale, boolean gaseous) {
        if (stack.isEmpty()) {
            return -1;
        }
        int color = stack.getChemicalTint();
        return MekanismRenderer.getColorARGB(MekanismRenderer.getRed(color), MekanismRenderer.getGreen(color), MekanismRenderer.getBlue(color), gaseous ? Math.min(1.0f, scale + 0.2f) : 1.0f);
    }

    public static int getColorARGB(float red, float green, float blue, float alpha) {
        return MekanismRenderer.getColorARGB((int)(255.0f * red), (int)(255.0f * green), (int)(255.0f * blue), alpha);
    }

    public static int getColorARGB(int red, int green, int blue, float alpha) {
        if (alpha < 0.0f) {
            alpha = 0.0f;
        } else if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        int argb = (int)(255.0f * alpha) << 24;
        argb |= red << 16;
        argb |= green << 8;
        return argb |= blue;
    }

    public static int calculateGlowLight(int combinedLight, @Nonnull FluidStack fluid) {
        return fluid.isEmpty() ? combinedLight : MekanismRenderer.calculateGlowLight(combinedLight, fluid.getFluid().getAttributes().getLuminosity(fluid));
    }

    public static int calculateGlowLight(int combinedLight, int glow) {
        return combinedLight & 0xFFFF0000 | Math.max(Math.min(glow, 15) << 4, combinedLight & 0xFFFF);
    }

    public static void renderColorOverlay(PoseStack matrix, int x, int y, int width, int height, int color) {
        float r = MekanismRenderer.getRed(color);
        float g = MekanismRenderer.getGreen(color);
        float b = MekanismRenderer.getBlue(color);
        float a = MekanismRenderer.getAlpha(color);
        RenderSystem.m_69465_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        bufferbuilder.m_85982_(matrix4f, (float)width, (float)y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferbuilder.m_85982_(matrix4f, (float)x, (float)y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferbuilder.m_85982_(matrix4f, (float)x, (float)height, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferbuilder.m_85982_(matrix4f, (float)width, (float)height, 0.0f).m_85950_(r, g, b, a).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        RenderSystem.m_69482_();
    }

    public static float getPartialTick() {
        return Minecraft.m_91087_().m_91296_();
    }

    public static void rotate(PoseStack matrix, Direction facing, float north, float south, float west, float east) {
        switch (facing) {
            case NORTH: {
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(north));
                break;
            }
            case SOUTH: {
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(south));
                break;
            }
            case WEST: {
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(west));
                break;
            }
            case EAST: {
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(east));
            }
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Pre event) {
        if (!event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            return;
        }
        for (TransmissionType type : EnumUtils.TRANSMISSION_TYPES) {
            event.addSprite(Mekanism.rl("block/overlay/" + type.getTransmission() + "_overlay"));
        }
        event.addSprite(Mekanism.rl("block/overlay/overlay_white"));
        event.addSprite(Mekanism.rl("liquid/energy"));
        event.addSprite(Mekanism.rl("liquid/heat"));
        event.addSprite(Mekanism.rl("icon/redstone_control_pulse"));
        event.addSprite(Mekanism.rl("block/teleporter_portal"));
        event.addSprite(Mekanism.rl("entity/armor/blank"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_player"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_body"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_helmet"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_exoskeleton"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_gravitational_modulator"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_elytra"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_modules"));
        event.addSprite(Mekanism.rl("entity/armor/mekatool"));
        DigitalMinerBakedModel.preStitch(event);
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.gasRegistry());
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.infuseTypeRegistry());
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.pigmentRegistry());
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.slurryRegistry());
        ModelRenderer.resetCachedModels();
        RenderDigitalMiner.resetCachedVisuals();
        RenderDimensionalStabilizer.resetCachedVisuals();
        RenderFluidTank.resetCachedModels();
        RenderFluidTankItem.resetCachedModels();
        RenderNutritionalLiquifier.resetCachedModels();
        RenderPigmentMixer.resetCached();
        RenderMechanicalPipe.onStitch();
        RenderTickHandler.resetCached();
        RenderTeleporter.resetCachedModels();
        MekanismRenderer.parseColorAtlas(Mekanism.rl("textures/colormap/primary.png"));
        SpecialColors.GUI_OBJECTS.parse(Mekanism.rl("textures/colormap/gui_objects.png"));
        SpecialColors.GUI_TEXT.parse(Mekanism.rl("textures/colormap/gui_text.png"));
        GuiElementHolder.updateBackgroundColor();
    }

    private static void parseColorAtlas(ResourceLocation rl) {
        List<Color> parsed = ColorAtlas.load(rl, EnumUtils.COLORS.length);
        if (parsed.size() < EnumUtils.COLORS.length) {
            Mekanism.logger.error("Failed to parse primary color atlas.");
            return;
        }
        for (int i = 0; i < EnumUtils.COLORS.length; ++i) {
            EnumUtils.COLORS[i].setColorFromAtlas(parsed.get(i).rgbArray());
        }
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>> void addChemicalSprites(TextureStitchEvent.Pre event, IForgeRegistry<CHEMICAL> chemicalRegistry) {
        for (Chemical chemical : chemicalRegistry.getValues()) {
            event.addSprite(chemical.getIcon());
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Post event) {
        TextureAtlas map = event.getAtlas();
        if (!map.m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            return;
        }
        for (TransmissionType type : EnumUtils.TRANSMISSION_TYPES) {
            overlays.put(type, map.m_118316_(Mekanism.rl("block/overlay/" + type.getTransmission() + "_overlay")));
        }
        whiteIcon = map.m_118316_(Mekanism.rl("block/overlay/overlay_white"));
        energyIcon = map.m_118316_(Mekanism.rl("liquid/energy"));
        heatIcon = map.m_118316_(Mekanism.rl("liquid/heat"));
        redstoneTorch = map.m_118316_(new ResourceLocation("minecraft:block/redstone_torch"));
        redstonePulse = map.m_118316_(Mekanism.rl("icon/redstone_control_pulse"));
        teleporterPortal = map.m_118316_(Mekanism.rl("block/teleporter_portal"));
        DigitalMinerBakedModel.onStitch(event);
        RenderLogisticalTransporter.onStitch(map);
        RenderTransmitterBase.onStitch();
    }

    static {
        overlays = new EnumMap<TransmissionType, TextureAtlasSprite>(TransmissionType.class);
    }

    public static enum FluidType {
        STILL,
        FLOWING;

    }

    public static class Model3D {
        public float minX;
        public float minY;
        public float minZ;
        public float maxX;
        public float maxY;
        public float maxZ;
        private final SpriteInfo[] textures = new SpriteInfo[6];
        private final boolean[] renderSides = new boolean[]{true, true, true, true, true, true};

        public void setSideRender(Direction side, boolean value) {
            this.renderSides[side.ordinal()] = value;
        }

        public Model3D copy() {
            Model3D copy = new Model3D();
            System.arraycopy(this.textures, 0, copy.textures, 0, this.textures.length);
            System.arraycopy(this.renderSides, 0, copy.renderSides, 0, this.renderSides.length);
            copy.minX = this.minX;
            copy.minY = this.minY;
            copy.minZ = this.minZ;
            copy.maxX = this.maxX;
            copy.maxY = this.maxY;
            copy.maxZ = this.maxZ;
            return copy;
        }

        @Nullable
        public SpriteInfo getSpriteToRender(Direction side) {
            int ordinal = side.ordinal();
            if (this.renderSides[ordinal]) {
                return this.textures[ordinal];
            }
            return null;
        }

        public void setTexture(Direction side, SpriteInfo spriteInfo) {
            this.textures[side.ordinal()] = spriteInfo;
        }

        public void setTexture(TextureAtlasSprite tex) {
            this.setTexture(tex, 16);
        }

        public void setTexture(TextureAtlasSprite tex, int size) {
            Arrays.fill(this.textures, new SpriteInfo(tex, size));
        }

        public void setTextures(SpriteInfo down, SpriteInfo up, SpriteInfo north, SpriteInfo south, SpriteInfo west, SpriteInfo east) {
            this.textures[0] = down;
            this.textures[1] = up;
            this.textures[2] = north;
            this.textures[3] = south;
            this.textures[4] = west;
            this.textures[5] = east;
        }

        public record SpriteInfo(TextureAtlasSprite sprite, int size) {
        }
    }
}

