/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.baked;

import java.util.List;
import javax.annotation.Nullable;
import mekanism.client.model.baked.ExtensionBakedModel;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import mekanism.common.tile.qio.TileEntityQIORedstoneAdapter;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class QIORedstoneAdapterBakedModel
extends ExtensionBakedModel<Boolean> {
    private final QuadTransformation TORCH_TRANSFORM = QuadTransformation.list(QuadTransformation.fullbright, QuadTransformation.texture(MekanismRenderer.redstoneTorch));

    public QIORedstoneAdapterBakedModel(BakedModel original) {
        super(original);
    }

    @Override
    public List<BakedQuad> createQuads(ExtensionBakedModel.QuadsKey<Boolean> key) {
        List<BakedQuad> quads = key.getQuads();
        if (key.getData().booleanValue()) {
            quads = QuadUtils.transformBakedQuads(quads, QuadTransformation.TextureFilteredTransformation.of(this.TORCH_TRANSFORM, s -> s.m_135815_().contains("redstone")));
        }
        return quads;
    }

    @Override
    @Nullable
    public ExtensionBakedModel.QuadsKey<Boolean> createKey(ExtensionBakedModel.QuadsKey<Boolean> key, IModelData data) {
        Boolean powering = (Boolean)data.getData(TileEntityQIORedstoneAdapter.POWERING_PROPERTY);
        if (powering == null) {
            return null;
        }
        return key.data(powering, Boolean.hashCode(powering), Boolean::equals);
    }

    protected QIORedstoneAdapterBakedModel wrapModel(BakedModel model) {
        return new QIORedstoneAdapterBakedModel(model);
    }
}

