/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuiArrowSelection
extends GuiTexturedElement {
    private static final ResourceLocation ARROW = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "arrow_selection.png");
    private final Supplier<Component> textComponentSupplier;

    public GuiArrowSelection(IGuiWrapper gui, int x, int y, Supplier<Component> textComponentSupplier) {
        super(ARROW, gui, x, y, 33, 19);
        this.textComponentSupplier = textComponentSupplier;
    }

    @Override
    public boolean m_5953_(double xAxis, double yAxis) {
        return this.f_93623_ && this.f_93624_ && xAxis >= (double)(this.f_93620_ + 16) && xAxis < (double)(this.f_93620_ + this.f_93618_ - 1) && yAxis >= (double)(this.f_93621_ + 1) && yAxis < (double)(this.f_93621_ + this.f_93619_ - 1);
    }

    @Override
    public void m_7428_(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        Component component = this.textComponentSupplier.get();
        if (component != null) {
            int tooltipX = mouseX + 5;
            int tooltipY = mouseY - 5;
            GuiUtils.renderBackgroundTexture(matrix, GuiInnerScreen.SCREEN, GuiInnerScreen.SCREEN_SIZE, GuiInnerScreen.SCREEN_SIZE, tooltipX - 3, tooltipY - 4, this.getStringWidth(component) + 6, 16, 256, 256);
            MultiBufferSource.BufferSource renderType = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            matrix.m_85836_();
            matrix.m_85837_(0.0, 0.0, 300.0);
            this.getFont().m_92841_(component, (float)tooltipX, (float)tooltipY, this.screenTextColor(), false, matrix.m_85850_().m_85861_(), (MultiBufferSource)renderType, false, 0, 0xF000F0);
            matrix.m_85849_();
            renderType.m_109911_();
        }
    }

    @Override
    public void drawBackground(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getResource());
        GuiArrowSelection.m_93133_((PoseStack)matrix, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)0.0f, (int)this.f_93618_, (int)this.f_93619_, (int)this.f_93618_, (int)this.f_93619_);
    }
}

