/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiUpArrow;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.BasicColorButton;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.element.tab.GuiVisualsTab;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.FixedUsageEnergyContainer;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.interfaces.IHasVisualization;
import mekanism.common.tile.machine.TileEntityDimensionalStabilizer;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GuiDimensionalStabilizer
extends GuiMekanismTile<TileEntityDimensionalStabilizer, MekanismTileContainer<TileEntityDimensionalStabilizer>> {
    public GuiDimensionalStabilizer(MekanismTileContainer<TileEntityDimensionalStabilizer> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.f_97731_ += 2;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityDimensionalStabilizer)this.tile).getEnergyContainer(), 164, 15)).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, () -> {
            FixedUsageEnergyContainer<TileEntityDimensionalStabilizer> energyContainer = ((TileEntityDimensionalStabilizer)this.tile).getEnergyContainer();
            return energyContainer.getEnergyPerTick().greaterThan(energyContainer.getEnergy());
        });
        this.addRenderableWidget(new GuiVisualsTab(this, (IHasVisualization)((Object)this.tile)));
        this.addRenderableWidget(new GuiEnergyTab((IGuiWrapper)this, ((TileEntityDimensionalStabilizer)this.tile).getEnergyContainer()));
        int tileChunkX = SectionPos.m_123171_((int)((TileEntityDimensionalStabilizer)this.tile).m_58899_().m_123341_());
        int tileChunkZ = SectionPos.m_123171_((int)((TileEntityDimensionalStabilizer)this.tile).m_58899_().m_123343_());
        for (int x = -2; x <= 2; ++x) {
            int shiftedX = x + 2;
            int chunkX = tileChunkX + x;
            for (int z = -2; z <= 2; ++z) {
                int shiftedZ = z + 2;
                int chunkZ = tileChunkZ + z;
                if (x == 0 && z == 0) {
                    this.addRenderableWidget(BasicColorButton.renderActive(this, 63 + 10 * shiftedX, 19 + 10 * shiftedZ, 10, EnumColor.DARK_BLUE, this.getOnHover(() -> MekanismLang.STABILIZER_CENTER.translate(chunkX, chunkZ))));
                    continue;
                }
                int packetTarget = shiftedX * 5 + shiftedZ;
                this.addRenderableWidget(BasicColorButton.toggle(this, 63 + 10 * shiftedX, 19 + 10 * shiftedZ, 10, EnumColor.DARK_BLUE, () -> ((TileEntityDimensionalStabilizer)this.tile).isChunkLoadingAt(shiftedX, shiftedZ), () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.TOGGLE_CHUNKLOAD, (BlockEntity)this.tile, packetTarget)), this.getOnHover(() -> MekanismLang.STABILIZER_TOGGLE_LOADING.translate(BooleanStateDisplay.OnOff.of(((TileEntityDimensionalStabilizer)this.tile).isChunkLoadingAt(shiftedX, shiftedZ), true), chunkX, chunkZ))));
            }
        }
        this.addRenderableWidget(new GuiUpArrow(this, 52, 28));
    }

    @Override
    protected void drawForegroundText(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        this.drawTextExact(matrix, (Component)MekanismLang.NORTH_SHORT.translate(new Object[0]), 53.5f, 41.0f, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

