/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.slurry;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.providers.ISlurryProvider;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class SlurryStack
extends ChemicalStack<Slurry> {
    public static final SlurryStack EMPTY = new SlurryStack(MekanismAPI.EMPTY_SLURRY, 0L);

    public SlurryStack(ISlurryProvider slurryProvider, long amount) {
        super((Slurry)slurryProvider.getChemical(), amount);
    }

    public SlurryStack(SlurryStack stack, long amount) {
        this((ISlurryProvider)stack.getType(), amount);
    }

    @Override
    protected IRegistryDelegate<Slurry> getDelegate(Slurry slurry) {
        if (MekanismAPI.slurryRegistry().getKey((IForgeRegistryEntry)slurry) == null) {
            MekanismAPI.logger.fatal("Failed attempt to create a SlurryStack for an unregistered Slurry {} (type {})", (Object)slurry.getRegistryName(), (Object)slurry.getClass().getName());
            throw new IllegalArgumentException("Cannot create a SlurryStack from an unregistered Slurry");
        }
        return slurry.delegate;
    }

    @Override
    protected Slurry getEmptyChemical() {
        return MekanismAPI.EMPTY_SLURRY;
    }

    public static SlurryStack readFromNBT(@Nullable CompoundTag nbtTags) {
        if (nbtTags == null || nbtTags.m_128456_()) {
            return EMPTY;
        }
        Slurry type = Slurry.readFromNBT(nbtTags);
        if (type.isEmptyType()) {
            return EMPTY;
        }
        long amount = nbtTags.m_128454_("amount");
        if (amount <= 0L) {
            return EMPTY;
        }
        return new SlurryStack(type, amount);
    }

    public static SlurryStack readFromPacket(FriendlyByteBuf buf) {
        Slurry slurry = (Slurry)buf.readRegistryId();
        long amount = buf.m_130258_();
        if (slurry.isEmptyType()) {
            return EMPTY;
        }
        return new SlurryStack(slurry, amount);
    }

    public SlurryStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new SlurryStack(this, this.getAmount());
    }
}

