/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.registries;

import java.util.function.BiFunction;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registration.impl.ItemRegistryObject;
import mekanism.tools.common.config.MekanismToolsConfig;
import mekanism.tools.common.item.ItemMekanismArmor;
import mekanism.tools.common.item.ItemMekanismAxe;
import mekanism.tools.common.item.ItemMekanismHoe;
import mekanism.tools.common.item.ItemMekanismPaxel;
import mekanism.tools.common.item.ItemMekanismPickaxe;
import mekanism.tools.common.item.ItemMekanismShield;
import mekanism.tools.common.item.ItemMekanismShovel;
import mekanism.tools.common.item.ItemMekanismSword;
import mekanism.tools.common.item.ItemRefinedGlowstoneArmor;
import mekanism.tools.common.material.BaseMekanismMaterial;
import mekanism.tools.common.material.MaterialCreator;
import mekanism.tools.common.material.VanillaPaxelMaterialCreator;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tiers;

public class ToolsItems {
    public static final ItemDeferredRegister ITEMS = new ItemDeferredRegister("mekanismtools");
    public static final ItemRegistryObject<ItemMekanismPaxel> WOOD_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.tools.wood);
    public static final ItemRegistryObject<ItemMekanismPaxel> STONE_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.tools.stone);
    public static final ItemRegistryObject<ItemMekanismPaxel> IRON_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.tools.iron);
    public static final ItemRegistryObject<ItemMekanismPaxel> DIAMOND_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.tools.diamond);
    public static final ItemRegistryObject<ItemMekanismPaxel> GOLD_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.tools.gold);
    public static final ItemRegistryObject<ItemMekanismPaxel> NETHERITE_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.tools.netherite);
    public static final ItemRegistryObject<ItemMekanismPickaxe> BRONZE_PICKAXE = ToolsItems.registerPickaxe(MekanismToolsConfig.tools.bronze);
    public static final ItemRegistryObject<ItemMekanismAxe> BRONZE_AXE = ToolsItems.registerAxe(MekanismToolsConfig.tools.bronze);
    public static final ItemRegistryObject<ItemMekanismShovel> BRONZE_SHOVEL = ToolsItems.registerShovel(MekanismToolsConfig.tools.bronze);
    public static final ItemRegistryObject<ItemMekanismHoe> BRONZE_HOE = ToolsItems.registerHoe(MekanismToolsConfig.tools.bronze);
    public static final ItemRegistryObject<ItemMekanismSword> BRONZE_SWORD = ToolsItems.registerSword(MekanismToolsConfig.tools.bronze);
    public static final ItemRegistryObject<ItemMekanismPaxel> BRONZE_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.tools.bronze);
    public static final ItemRegistryObject<ItemMekanismArmor> BRONZE_HELMET = ToolsItems.registerArmor(MekanismToolsConfig.tools.bronze, EquipmentSlot.HEAD);
    public static final ItemRegistryObject<ItemMekanismArmor> BRONZE_CHESTPLATE = ToolsItems.registerArmor(MekanismToolsConfig.tools.bronze, EquipmentSlot.CHEST);
    public static final ItemRegistryObject<ItemMekanismArmor> BRONZE_LEGGINGS = ToolsItems.registerArmor(MekanismToolsConfig.tools.bronze, EquipmentSlot.LEGS);
    public static final ItemRegistryObject<ItemMekanismArmor> BRONZE_BOOTS = ToolsItems.registerArmor(MekanismToolsConfig.tools.bronze, EquipmentSlot.FEET);
    public static final ItemRegistryObject<ItemMekanismShield> BRONZE_SHIELD = ToolsItems.registerShield(MekanismToolsConfig.tools.bronze);
    public static final ItemRegistryObject<ItemMekanismPickaxe> LAPIS_LAZULI_PICKAXE = ToolsItems.registerPickaxe(MekanismToolsConfig.tools.lapisLazuli);
    public static final ItemRegistryObject<ItemMekanismAxe> LAPIS_LAZULI_AXE = ToolsItems.registerAxe(MekanismToolsConfig.tools.lapisLazuli);
    public static final ItemRegistryObject<ItemMekanismShovel> LAPIS_LAZULI_SHOVEL = ToolsItems.registerShovel(MekanismToolsConfig.tools.lapisLazuli);
    public static final ItemRegistryObject<ItemMekanismHoe> LAPIS_LAZULI_HOE = ToolsItems.registerHoe(MekanismToolsConfig.tools.lapisLazuli);
    public static final ItemRegistryObject<ItemMekanismSword> LAPIS_LAZULI_SWORD = ToolsItems.registerSword(MekanismToolsConfig.tools.lapisLazuli);
    public static final ItemRegistryObject<ItemMekanismPaxel> LAPIS_LAZULI_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.tools.lapisLazuli);
    public static final ItemRegistryObject<ItemMekanismArmor> LAPIS_LAZULI_HELMET = ToolsItems.registerArmor(MekanismToolsConfig.tools.lapisLazuli, EquipmentSlot.HEAD);
    public static final ItemRegistryObject<ItemMekanismArmor> LAPIS_LAZULI_CHESTPLATE = ToolsItems.registerArmor(MekanismToolsConfig.tools.lapisLazuli, EquipmentSlot.CHEST);
    public static final ItemRegistryObject<ItemMekanismArmor> LAPIS_LAZULI_LEGGINGS = ToolsItems.registerArmor(MekanismToolsConfig.tools.lapisLazuli, EquipmentSlot.LEGS);
    public static final ItemRegistryObject<ItemMekanismArmor> LAPIS_LAZULI_BOOTS = ToolsItems.registerArmor(MekanismToolsConfig.tools.lapisLazuli, EquipmentSlot.FEET);
    public static final ItemRegistryObject<ItemMekanismShield> LAPIS_LAZULI_SHIELD = ToolsItems.registerShield(MekanismToolsConfig.tools.lapisLazuli);
    public static final ItemRegistryObject<ItemMekanismPickaxe> OSMIUM_PICKAXE = ToolsItems.registerPickaxe(MekanismToolsConfig.tools.osmium);
    public static final ItemRegistryObject<ItemMekanismAxe> OSMIUM_AXE = ToolsItems.registerAxe(MekanismToolsConfig.tools.osmium);
    public static final ItemRegistryObject<ItemMekanismShovel> OSMIUM_SHOVEL = ToolsItems.registerShovel(MekanismToolsConfig.tools.osmium);
    public static final ItemRegistryObject<ItemMekanismHoe> OSMIUM_HOE = ToolsItems.registerHoe(MekanismToolsConfig.tools.osmium);
    public static final ItemRegistryObject<ItemMekanismSword> OSMIUM_SWORD = ToolsItems.registerSword(MekanismToolsConfig.tools.osmium);
    public static final ItemRegistryObject<ItemMekanismPaxel> OSMIUM_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.tools.osmium);
    public static final ItemRegistryObject<ItemMekanismArmor> OSMIUM_HELMET = ToolsItems.registerArmor(MekanismToolsConfig.tools.osmium, EquipmentSlot.HEAD);
    public static final ItemRegistryObject<ItemMekanismArmor> OSMIUM_CHESTPLATE = ToolsItems.registerArmor(MekanismToolsConfig.tools.osmium, EquipmentSlot.CHEST);
    public static final ItemRegistryObject<ItemMekanismArmor> OSMIUM_LEGGINGS = ToolsItems.registerArmor(MekanismToolsConfig.tools.osmium, EquipmentSlot.LEGS);
    public static final ItemRegistryObject<ItemMekanismArmor> OSMIUM_BOOTS = ToolsItems.registerArmor(MekanismToolsConfig.tools.osmium, EquipmentSlot.FEET);
    public static final ItemRegistryObject<ItemMekanismShield> OSMIUM_SHIELD = ToolsItems.registerShield(MekanismToolsConfig.tools.osmium);
    public static final ItemRegistryObject<ItemMekanismPickaxe> REFINED_GLOWSTONE_PICKAXE = ToolsItems.registerPickaxe(MekanismToolsConfig.tools.refinedGlowstone);
    public static final ItemRegistryObject<ItemMekanismAxe> REFINED_GLOWSTONE_AXE = ToolsItems.registerAxe(MekanismToolsConfig.tools.refinedGlowstone);
    public static final ItemRegistryObject<ItemMekanismShovel> REFINED_GLOWSTONE_SHOVEL = ToolsItems.registerShovel(MekanismToolsConfig.tools.refinedGlowstone);
    public static final ItemRegistryObject<ItemMekanismHoe> REFINED_GLOWSTONE_HOE = ToolsItems.registerHoe(MekanismToolsConfig.tools.refinedGlowstone);
    public static final ItemRegistryObject<ItemMekanismSword> REFINED_GLOWSTONE_SWORD = ToolsItems.registerSword(MekanismToolsConfig.tools.refinedGlowstone);
    public static final ItemRegistryObject<ItemMekanismPaxel> REFINED_GLOWSTONE_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.tools.refinedGlowstone);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_GLOWSTONE_HELMET = ToolsItems.registerArmor(MekanismToolsConfig.tools.refinedGlowstone, EquipmentSlot.HEAD, ItemRefinedGlowstoneArmor::new);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_GLOWSTONE_CHESTPLATE = ToolsItems.registerArmor(MekanismToolsConfig.tools.refinedGlowstone, EquipmentSlot.CHEST, ItemRefinedGlowstoneArmor::new);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_GLOWSTONE_LEGGINGS = ToolsItems.registerArmor(MekanismToolsConfig.tools.refinedGlowstone, EquipmentSlot.LEGS, ItemRefinedGlowstoneArmor::new);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_GLOWSTONE_BOOTS = ToolsItems.registerArmor(MekanismToolsConfig.tools.refinedGlowstone, EquipmentSlot.FEET, ItemRefinedGlowstoneArmor::new);
    public static final ItemRegistryObject<ItemMekanismShield> REFINED_GLOWSTONE_SHIELD = ToolsItems.registerShield(MekanismToolsConfig.tools.refinedGlowstone);
    public static final ItemRegistryObject<ItemMekanismPickaxe> REFINED_OBSIDIAN_PICKAXE = ToolsItems.registerPickaxe(MekanismToolsConfig.tools.refinedObsidian);
    public static final ItemRegistryObject<ItemMekanismAxe> REFINED_OBSIDIAN_AXE = ToolsItems.registerAxe(MekanismToolsConfig.tools.refinedObsidian);
    public static final ItemRegistryObject<ItemMekanismShovel> REFINED_OBSIDIAN_SHOVEL = ToolsItems.registerShovel(MekanismToolsConfig.tools.refinedObsidian);
    public static final ItemRegistryObject<ItemMekanismHoe> REFINED_OBSIDIAN_HOE = ToolsItems.registerHoe(MekanismToolsConfig.tools.refinedObsidian);
    public static final ItemRegistryObject<ItemMekanismSword> REFINED_OBSIDIAN_SWORD = ToolsItems.registerSword(MekanismToolsConfig.tools.refinedObsidian);
    public static final ItemRegistryObject<ItemMekanismPaxel> REFINED_OBSIDIAN_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.tools.refinedObsidian);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_OBSIDIAN_HELMET = ToolsItems.registerArmor(MekanismToolsConfig.tools.refinedObsidian, EquipmentSlot.HEAD);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_OBSIDIAN_CHESTPLATE = ToolsItems.registerArmor(MekanismToolsConfig.tools.refinedObsidian, EquipmentSlot.CHEST);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_OBSIDIAN_LEGGINGS = ToolsItems.registerArmor(MekanismToolsConfig.tools.refinedObsidian, EquipmentSlot.LEGS);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_OBSIDIAN_BOOTS = ToolsItems.registerArmor(MekanismToolsConfig.tools.refinedObsidian, EquipmentSlot.FEET);
    public static final ItemRegistryObject<ItemMekanismShield> REFINED_OBSIDIAN_SHIELD = ToolsItems.registerShield(MekanismToolsConfig.tools.refinedObsidian);
    public static final ItemRegistryObject<ItemMekanismPickaxe> STEEL_PICKAXE = ToolsItems.registerPickaxe(MekanismToolsConfig.tools.steel);
    public static final ItemRegistryObject<ItemMekanismAxe> STEEL_AXE = ToolsItems.registerAxe(MekanismToolsConfig.tools.steel);
    public static final ItemRegistryObject<ItemMekanismShovel> STEEL_SHOVEL = ToolsItems.registerShovel(MekanismToolsConfig.tools.steel);
    public static final ItemRegistryObject<ItemMekanismHoe> STEEL_HOE = ToolsItems.registerHoe(MekanismToolsConfig.tools.steel);
    public static final ItemRegistryObject<ItemMekanismSword> STEEL_SWORD = ToolsItems.registerSword(MekanismToolsConfig.tools.steel);
    public static final ItemRegistryObject<ItemMekanismPaxel> STEEL_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.tools.steel);
    public static final ItemRegistryObject<ItemMekanismArmor> STEEL_HELMET = ToolsItems.registerArmor(MekanismToolsConfig.tools.steel, EquipmentSlot.HEAD);
    public static final ItemRegistryObject<ItemMekanismArmor> STEEL_CHESTPLATE = ToolsItems.registerArmor(MekanismToolsConfig.tools.steel, EquipmentSlot.CHEST);
    public static final ItemRegistryObject<ItemMekanismArmor> STEEL_LEGGINGS = ToolsItems.registerArmor(MekanismToolsConfig.tools.steel, EquipmentSlot.LEGS);
    public static final ItemRegistryObject<ItemMekanismArmor> STEEL_BOOTS = ToolsItems.registerArmor(MekanismToolsConfig.tools.steel, EquipmentSlot.FEET);
    public static final ItemRegistryObject<ItemMekanismShield> STEEL_SHIELD = ToolsItems.registerShield(MekanismToolsConfig.tools.steel);

    private ToolsItems() {
    }

    private static ItemRegistryObject<ItemMekanismShield> registerShield(MaterialCreator material) {
        return ToolsItems.register(ItemMekanismShield::new, "_shield", material);
    }

    private static ItemRegistryObject<ItemMekanismPickaxe> registerPickaxe(MaterialCreator material) {
        return ToolsItems.register(ItemMekanismPickaxe::new, "_pickaxe", material);
    }

    private static ItemRegistryObject<ItemMekanismAxe> registerAxe(MaterialCreator material) {
        return ToolsItems.register(ItemMekanismAxe::new, "_axe", material);
    }

    private static ItemRegistryObject<ItemMekanismShovel> registerShovel(MaterialCreator material) {
        return ToolsItems.register(ItemMekanismShovel::new, "_shovel", material);
    }

    private static ItemRegistryObject<ItemMekanismHoe> registerHoe(MaterialCreator material) {
        return ToolsItems.register(ItemMekanismHoe::new, "_hoe", material);
    }

    private static ItemRegistryObject<ItemMekanismSword> registerSword(MaterialCreator material) {
        return ToolsItems.register(ItemMekanismSword::new, "_sword", material);
    }

    private static ItemRegistryObject<ItemMekanismPaxel> registerPaxel(MaterialCreator material) {
        return ToolsItems.register(ItemMekanismPaxel::new, "_paxel", material);
    }

    private static ItemRegistryObject<ItemMekanismPaxel> registerPaxel(VanillaPaxelMaterialCreator material) {
        if (material.getVanillaTier() == Tiers.NETHERITE) {
            return ITEMS.registerUnburnable(material.getRegistryPrefix() + "_paxel", properties -> new ItemMekanismPaxel(material, (Item.Properties)properties));
        }
        return ITEMS.register(material.getRegistryPrefix() + "_paxel", properties -> new ItemMekanismPaxel(material, (Item.Properties)properties));
    }

    private static ItemRegistryObject<ItemMekanismArmor> registerArmor(MaterialCreator material, EquipmentSlot slot) {
        return ToolsItems.registerArmor(material, slot, ItemMekanismArmor::new);
    }

    private static ItemRegistryObject<ItemMekanismArmor> registerArmor(MaterialCreator material, EquipmentSlot slot, ArmorCreator armorCreator) {
        String suffix = slot == EquipmentSlot.HEAD ? "_helmet" : (slot == EquipmentSlot.CHEST ? "_chestplate" : (slot == EquipmentSlot.LEGS ? "_leggings" : "_boots"));
        return ITEMS.register(material.getRegistryPrefix() + suffix, () -> armorCreator.create(material, slot, ToolsItems.getBaseProperties(material)));
    }

    private static <ITEM extends Item> ItemRegistryObject<ITEM> register(BiFunction<MaterialCreator, Item.Properties, ITEM> itemCreator, String suffix, MaterialCreator material) {
        return ITEMS.register(material.getRegistryPrefix() + suffix, () -> (Item)itemCreator.apply(material, ToolsItems.getBaseProperties(material)));
    }

    private static Item.Properties getBaseProperties(BaseMekanismMaterial material) {
        Item.Properties properties = ItemDeferredRegister.getMekBaseProperties();
        if (!material.burnsInFire()) {
            properties = properties.m_41486_();
        }
        return properties;
    }

    @FunctionalInterface
    private static interface ArmorCreator {
        public ItemMekanismArmor create(MaterialCreator var1, EquipmentSlot var2, Item.Properties var3);
    }
}

