/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.material;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.tools.common.material.BaseMekanismMaterial;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class MaterialCreator
extends BaseMekanismMaterial {
    private final BaseMekanismMaterial fallBack;
    private final CachedIntValue shieldDurability;
    public final CachedFloatValue swordDamage;
    public final CachedFloatValue swordAtkSpeed;
    public final CachedFloatValue shovelDamage;
    public final CachedFloatValue shovelAtkSpeed;
    public final CachedFloatValue axeDamage;
    public final CachedFloatValue axeAtkSpeed;
    public final CachedFloatValue pickaxeDamage;
    public final CachedFloatValue pickaxeAtkSpeed;
    public final CachedFloatValue hoeDamage;
    public final CachedFloatValue hoeAtkSpeed;
    public final CachedFloatValue paxelDamage;
    public final CachedFloatValue paxelAtkSpeed;
    private final CachedFloatValue paxelEfficiency;
    private final CachedIntValue paxelEnchantability;
    private final CachedIntValue paxelMaxUses;
    private final CachedIntValue toolMaxUses;
    private final CachedFloatValue efficiency;
    public final CachedFloatValue attackDamage;
    private final CachedIntValue enchantability;
    public final CachedFloatValue toughness;
    public final CachedFloatValue knockbackResistance;
    private final CachedIntValue bootDurability;
    private final CachedIntValue leggingDurability;
    private final CachedIntValue chestplateDurability;
    private final CachedIntValue helmetDurability;
    public final CachedIntValue bootArmor;
    public final CachedIntValue leggingArmor;
    public final CachedIntValue chestplateArmor;
    public final CachedIntValue helmetArmor;

    public MaterialCreator(IMekanismConfig config, ForgeConfigSpec.Builder builder, BaseMekanismMaterial materialDefaults) {
        this.fallBack = materialDefaults;
        String toolKey = this.getRegistryPrefix();
        String name = this.getConfigCommentName();
        builder.comment("Material Settings for " + name).push(toolKey);
        this.attackDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Base attack damage of " + name + " items.").defineInRange(toolKey + "AttackDamage", (double)materialDefaults.m_6631_(), 0.0, 3.4028234663852886E38));
        Predicate<Object> damageModifierPredicate = value -> {
            if (value instanceof Double) {
                double val = (Double)value;
                float actualValue = val > 3.4028234663852886E38 ? Float.MAX_VALUE : (val < -3.4028234663852886E38 ? -3.4028235E38f : (float)val);
                float baseDamage = this.attackDamage.get();
                return actualValue >= -baseDamage && actualValue <= Float.MAX_VALUE - baseDamage;
            }
            return false;
        };
        this.shieldDurability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " shields.").defineInRange(toolKey + "ShieldDurability", materialDefaults.getShieldDurability(), 0, Integer.MAX_VALUE));
        this.swordDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " swords.").define(toolKey + "SwordDamage", (Object)materialDefaults.getSwordDamage(), damageModifierPredicate));
        this.swordAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " swords.").define(toolKey + "SwordAtkSpeed", (Object)materialDefaults.getSwordAtkSpeed()));
        this.shovelDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " shovels.").define(toolKey + "ShovelDamage", (Object)materialDefaults.getShovelDamage(), damageModifierPredicate));
        this.shovelAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " shovels.").define(toolKey + "ShovelAtkSpeed", (Object)materialDefaults.getShovelAtkSpeed()));
        this.axeDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " axes.").define(toolKey + "AxeDamage", (Object)materialDefaults.getAxeDamage(), damageModifierPredicate));
        this.axeAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " axes.").define(toolKey + "AxeAtkSpeed", (Object)materialDefaults.getAxeAtkSpeed()));
        this.pickaxeDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " pickaxes.").define(toolKey + "PickaxeDamage", (Object)materialDefaults.getPickaxeDamage(), damageModifierPredicate));
        this.pickaxeAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " pickaxes.").define(toolKey + "PickaxeAtkSpeed", (Object)materialDefaults.getPickaxeAtkSpeed()));
        this.hoeDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " hoes.").define(toolKey + "HoeDamage", (Object)materialDefaults.getHoeDamage(), damageModifierPredicate));
        this.hoeAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " hoes.").define(toolKey + "HoeAtkSpeed", (Object)materialDefaults.getHoeAtkSpeed()));
        this.toolMaxUses = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " tools.").defineInRange(toolKey + "ToolMaxUses", materialDefaults.m_6609_(), 1, Integer.MAX_VALUE));
        this.efficiency = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Efficiency of " + name + " tools.").define(toolKey + "Efficiency", (Object)materialDefaults.m_6624_()));
        this.paxelDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " paxels.").define(toolKey + "PaxelDamage", (Object)materialDefaults.getPaxelDamage(), damageModifierPredicate));
        this.paxelAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " paxels.").define(toolKey + "PaxelAtkSpeed", (Object)materialDefaults.getPaxelAtkSpeed()));
        this.paxelEfficiency = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Efficiency of " + name + " paxels.").define(toolKey + "PaxelEfficiency", (Object)materialDefaults.getPaxelEfficiency()));
        this.paxelEnchantability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Natural enchantability factor of " + name + " paxels.").defineInRange(toolKey + "PaxelEnchantability", materialDefaults.getPaxelEnchantability(), 0, Integer.MAX_VALUE));
        this.paxelMaxUses = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " paxels.").defineInRange(toolKey + "PaxelMaxUses", materialDefaults.getPaxelMaxUses(), 1, Integer.MAX_VALUE));
        this.enchantability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Natural enchantability factor of " + name + " items.").defineInRange(toolKey + "Enchantability", materialDefaults.getCommonEnchantability(), 0, Integer.MAX_VALUE));
        this.toughness = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Base armor toughness value of " + name + " armor.").defineInRange(toolKey + "Toughness", (double)materialDefaults.m_6651_(), 0.0, 3.4028234663852886E38));
        this.knockbackResistance = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Base armor knockback resistance value of " + name + " armor.").defineInRange(toolKey + "KnockbackResistance", (double)materialDefaults.m_6649_(), 0.0, 3.4028234663852886E38));
        this.bootDurability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " boots.").defineInRange(toolKey + "BootDurability", materialDefaults.m_7366_(EquipmentSlot.FEET), 1, Integer.MAX_VALUE));
        this.leggingDurability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " leggings.").defineInRange(toolKey + "LeggingDurability", materialDefaults.m_7366_(EquipmentSlot.LEGS), 1, Integer.MAX_VALUE));
        this.chestplateDurability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " chestplates.").defineInRange(toolKey + "ChestplateDurability", materialDefaults.m_7366_(EquipmentSlot.CHEST), 1, Integer.MAX_VALUE));
        this.helmetDurability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " helmets.").defineInRange(toolKey + "HelmetDurability", materialDefaults.m_7366_(EquipmentSlot.HEAD), 1, Integer.MAX_VALUE));
        this.bootArmor = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Protection value of " + name + " boots.").defineInRange(toolKey + "BootArmor", materialDefaults.m_7365_(EquipmentSlot.FEET), 0, Integer.MAX_VALUE));
        this.leggingArmor = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Protection value of " + name + " leggings.").defineInRange(toolKey + "LeggingArmor", materialDefaults.m_7365_(EquipmentSlot.LEGS), 0, Integer.MAX_VALUE));
        this.chestplateArmor = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Protection value of " + name + " chestplates.").defineInRange(toolKey + "ChestplateArmor", materialDefaults.m_7365_(EquipmentSlot.CHEST), 0, Integer.MAX_VALUE));
        this.helmetArmor = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Protection value of " + name + " helmets.").defineInRange(toolKey + "HelmetArmor", materialDefaults.m_7365_(EquipmentSlot.HEAD), 0, Integer.MAX_VALUE));
        builder.pop();
    }

    @Override
    public int getShieldDurability() {
        return this.shieldDurability.get();
    }

    @Override
    public float getSwordDamage() {
        return this.swordDamage.get();
    }

    @Override
    public float getSwordAtkSpeed() {
        return this.swordAtkSpeed.get();
    }

    @Override
    public float getShovelDamage() {
        return this.shovelDamage.get();
    }

    @Override
    public float getShovelAtkSpeed() {
        return this.shovelAtkSpeed.get();
    }

    @Override
    public float getAxeDamage() {
        return this.axeDamage.get();
    }

    @Override
    public float getAxeAtkSpeed() {
        return this.axeAtkSpeed.get();
    }

    @Override
    public float getPickaxeDamage() {
        return this.pickaxeDamage.get();
    }

    @Override
    public float getPickaxeAtkSpeed() {
        return this.pickaxeAtkSpeed.get();
    }

    @Override
    public float getHoeDamage() {
        return this.hoeDamage.get();
    }

    @Override
    public float getHoeAtkSpeed() {
        return this.hoeAtkSpeed.get();
    }

    @Override
    public int getPaxelMaxUses() {
        return this.paxelMaxUses.get();
    }

    @Override
    public float getPaxelEfficiency() {
        return this.paxelEfficiency.get();
    }

    @Override
    public float getPaxelDamage() {
        return this.paxelDamage.get();
    }

    @Override
    public float getPaxelAtkSpeed() {
        return this.paxelAtkSpeed.get();
    }

    public int m_6609_() {
        return this.toolMaxUses.get();
    }

    public float m_6624_() {
        return this.efficiency.get();
    }

    public float m_6631_() {
        return this.attackDamage.get();
    }

    @Deprecated
    public int m_6604_() {
        return this.fallBack.m_6604_();
    }

    @Override
    @Nullable
    public TagKey<Block> getTag() {
        return this.fallBack.getTag();
    }

    public int m_7366_(EquipmentSlot slotType) {
        return switch (slotType) {
            case EquipmentSlot.FEET -> this.bootDurability.get();
            case EquipmentSlot.LEGS -> this.leggingDurability.get();
            case EquipmentSlot.CHEST -> this.chestplateDurability.get();
            case EquipmentSlot.HEAD -> this.helmetDurability.get();
            default -> this.fallBack.m_7366_(slotType);
        };
    }

    public int m_7365_(EquipmentSlot slotType) {
        return switch (slotType) {
            case EquipmentSlot.FEET -> this.bootArmor.get();
            case EquipmentSlot.LEGS -> this.leggingArmor.get();
            case EquipmentSlot.CHEST -> this.chestplateArmor.get();
            case EquipmentSlot.HEAD -> this.helmetArmor.get();
            default -> this.fallBack.m_7365_(slotType);
        };
    }

    @Override
    public int getCommonEnchantability() {
        return this.enchantability.get();
    }

    @Override
    public boolean burnsInFire() {
        return this.fallBack.burnsInFire();
    }

    public float m_6651_() {
        return this.toughness.get();
    }

    @Nonnull
    public SoundEvent m_7344_() {
        return this.fallBack.m_7344_();
    }

    @Override
    @Nonnull
    public Ingredient getCommonRepairMaterial() {
        return this.fallBack.getCommonRepairMaterial();
    }

    @Override
    public String getConfigCommentName() {
        return this.fallBack.getConfigCommentName();
    }

    @Override
    @Nonnull
    public String m_6082_() {
        return this.fallBack.m_6082_();
    }

    @Override
    @Nonnull
    public String getRegistryPrefix() {
        return this.fallBack.getRegistryPrefix();
    }

    @Override
    public int getPaxelEnchantability() {
        return this.paxelEnchantability.get();
    }

    public float m_6649_() {
        return this.knockbackResistance.get();
    }
}

