/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;

public class SweepingEdgeModifier
extends IncrementalModifier {
    private static final Component SWEEPING_BONUS = TConstruct.makeTranslation("modifier", "sweeping_edge.attack_damage");

    public float getSweepingDamage(IToolStackView toolStack, float baseDamage) {
        int level = toolStack.getModifierLevel(this);
        float sweepingDamage = 1.0f;
        if (level > 4) {
            sweepingDamage += baseDamage;
        } else if (level > 0) {
            sweepingDamage += this.getScaledLevel(toolStack, level) * 0.25f * baseDamage;
        }
        return sweepingDamage;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float amount = this.getScaledLevel(tool, level) * 0.25f;
        tooltip.add((Component)this.applyStyle(new TextComponent(Util.PERCENT_FORMAT.format(amount)).m_130946_(" ").m_7220_(SWEEPING_BONUS)));
    }
}

