/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.armor;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.TotalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class RespirationModifier
extends TotalArmorLevelModifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> RESPIRATION = TConstruct.createKey("respiration");

    public RespirationModifier() {
        super(RESPIRATION);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingEvent.LivingUpdateEvent.class, RespirationModifier::livingTick);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isLosingAir(LivingEntity living) {
        if (!living.m_6084_()) return false;
        if (living.m_6040_()) return false;
        if (!living.m_204029_(FluidTags.f_13131_)) return false;
        if (MobEffectUtil.m_19588_((LivingEntity)living)) return false;
        if (living instanceof Player) {
            Player player = (Player)living;
            if (player.m_150110_().f_35934_) return false;
        }
        if (living.f_19853_.m_8055_(new BlockPos(living.m_20185_(), living.m_20188_(), living.m_20189_())).m_60713_(Blocks.f_50628_)) return false;
        return true;
    }

    private static void livingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living.m_5833_()) {
            return;
        }
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            int respiration = data.get(RESPIRATION, 0);
            int air = living.m_20146_();
            if (respiration > 0 && air < living.m_6062_() && RespirationModifier.isLosingAir(living) && RANDOM.nextInt(respiration + 1) > 0) {
                living.m_20301_(air + 1);
            }
        });
    }
}

