/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class DwarvenModifier
extends Modifier {
    private static final Component MINING_SPEED = TConstruct.makeTranslation("modifier", "dwarven.mining_speed");
    private static final float BOOST_DISTANCE = 64.0f;
    private static final float DEBUFF_RANGE = 128.0f;
    private static final float BONUS = 6.0f;

    private static float getBoost(Level world, int y, int level, float baseSpeed, float modifier) {
        if ((float)y < 64.0f) {
            float scale = Mth.m_14036_((float)((64.0f - (float)y) / 64.0f), (float)0.0f, (float)2.0f);
            return baseSpeed + (float)level * scale * 6.0f * modifier;
        }
        float baselineDebuff = Math.max((float)world.m_151558_() - 192.0f, 96.0f);
        if ((float)y > baselineDebuff) {
            if ((float)y >= baselineDebuff + 128.0f) {
                return baseSpeed * 0.25f;
            }
            return baseSpeed * (1.0f - ((float)y - baselineDebuff) / 128.0f * 0.75f);
        }
        return baseSpeed;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (!isEffective) {
            return;
        }
        event.setNewSpeed(DwarvenModifier.getBoost(event.getPlayer().f_19853_, event.getPos().m_123342_(), level, event.getNewSpeed(), miningSpeedModifier * tool.getMultiplier(ToolStats.MINING_SPEED)));
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        if (tool.hasTag(TinkerTags.Items.HARVEST)) {
            double boost;
            if (player != null && key == TooltipKey.SHIFT) {
                boost = DwarvenModifier.getBoost(player.f_19853_, (int)player.m_20186_(), level, 1.0f, 1.0f) - 1.0f;
                if (boost < 0.0) {
                    if (boost <= -0.01) {
                        this.addPercentTooltip(MINING_SPEED, boost, tooltip);
                    }
                    return;
                }
            } else {
                boost = 6.0f * (float)level;
            }
            if (boost >= 0.01) {
                this.addFlatBoost(MINING_SPEED, boost * (double)tool.getMultiplier(ToolStats.MINING_SPEED), tooltip);
            }
        }
    }
}

