/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.DifferenceIngredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.TrueCondition;
import slimeknights.mantle.recipe.data.ItemNameIngredient;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.data.BaseRecipeProvider;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.gadgets.entity.FrameType;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialIngredient;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.OverslimeModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.SwappableModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipeBuilder;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.ModifierRepairRecipeBuilder;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.tools.recipe.ArmorDyeingRecipe;
import slimeknights.tconstruct.tools.recipe.ModifierRemovalRecipe;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;

public class ModifierRecipeProvider
extends BaseRecipeProvider {
    public ModifierRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public String m_6055_() {
        return "Tinkers' Construct Modifier Recipes";
    }

    @Override
    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        this.addItemRecipes(consumer);
        this.addModifierRecipes(consumer);
        this.addTextureRecipes(consumer);
        this.addHeadRecipes(consumer);
        this.addSpillingRecipes(consumer);
    }

    private void addItemRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/modifiers/";
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.ironReinforcement).setFluidAndTime(TinkerFluids.moltenIron, true, 30).setCast((ItemLike)TinkerCommons.obsidianPane, true).save(consumer, this.prefix((Supplier)TinkerModifiers.ironReinforcement, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.slimesteelReinforcement).setFluidAndTime(TinkerFluids.moltenSlimesteel, false, 30).setCast((ItemLike)TinkerCommons.obsidianPane, true).save(consumer, this.prefix((Supplier)TinkerModifiers.slimesteelReinforcement, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.searedReinforcement).setFluid(FluidIngredient.of((FluidIngredient[])new FluidIngredient[]{FluidIngredient.of((TagKey)TinkerFluids.searedStone.getLocalTag(), (int)250), FluidIngredient.of((TagKey)TinkerFluids.scorchedStone.getLocalTag(), (int)250)})).setCoolingTime(TinkerFluids.searedStone.get().getAttributes().getTemperature() - 300, 250).setCast((ItemLike)TinkerCommons.obsidianPane, true).save(consumer, this.prefix((Supplier)TinkerModifiers.searedReinforcement, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.goldReinforcement).setFluidAndTime(TinkerFluids.moltenGold, true, 30).setCast((ItemLike)TinkerCommons.obsidianPane, true).save(consumer, this.prefix((Supplier)TinkerModifiers.goldReinforcement, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.emeraldReinforcement).setFluidAndTime(TinkerFluids.moltenEmerald, false, 25).setCast((ItemLike)TinkerCommons.obsidianPane, true).save(consumer, this.prefix((Supplier)TinkerModifiers.emeraldReinforcement, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.bronzeReinforcement).setFluidAndTime(TinkerFluids.moltenAmethystBronze, true, 30).setCast((ItemLike)TinkerCommons.obsidianPane, true).save(consumer, this.prefix((Supplier)TinkerModifiers.bronzeReinforcement, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.cobaltReinforcement).setFluidAndTime(TinkerFluids.moltenCobalt, true, 30).setCast((ItemLike)TinkerCommons.obsidianPane, true).save(consumer, this.prefix((Supplier)TinkerModifiers.cobaltReinforcement, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerCommons.jeweledApple).setFluidAndTime(TinkerFluids.moltenDiamond, false, 400).setCast((ItemLike)Items.f_42410_, true).save(consumer, this.prefix((Supplier)TinkerCommons.jeweledApple, folder));
        ShapedRecipeBuilder.m_126116_(TinkerModifiers.silkyCloth).m_206416_(Character.valueOf('s'), Tags.Items.STRING).m_206416_(Character.valueOf('g'), TinkerMaterials.roseGold.getIngotTag()).m_126130_("sss").m_126130_("sgs").m_126130_("sss").m_142284_("has_item", (CriterionTriggerInstance)ModifierRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_GOLD)).m_142700_(consumer, this.prefix((Supplier)TinkerModifiers.silkyCloth, folder));
        ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_42500_).m_206419_(TinkerTags.Items.WITHER_BONES).m_142284_("has_bone", (CriterionTriggerInstance)ModifierRecipeProvider.m_206406_(TinkerTags.Items.WITHER_BONES)).m_142700_(this.withCondition(consumer, new ICondition[]{ConfigEnabledCondition.WITHER_BONE_CONVERSION}), this.modResource(folder + "wither_bone_conversion"));
        String repairFolder = folder + "repair/";
        ModifierRepairRecipeBuilder.repair(ModifierIds.stringy, Ingredient.m_204132_((TagKey)Tags.Items.STRING), 25).buildCraftingTable(consumer, this.wrap(ModifierIds.stringy, folder, "_crafting_table")).save(consumer, this.wrap(ModifierIds.stringy, folder, "_tinker_station"));
        ModifierRepairRecipeBuilder.repair(TinkerModifiers.tasty, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerCommons.bacon}), 25).save(consumer, this.prefix(TinkerModifiers.tasty, folder));
    }

    private void addModifierRecipes(Consumer<FinishedRecipe> consumer) {
        String upgradeFolder = "tools/modifiers/upgrade/";
        String abilityFolder = "tools/modifiers/ability/";
        String slotlessFolder = "tools/modifiers/slotless/";
        String upgradeSalvage = "tools/modifiers/salvage/upgrade/";
        String abilitySalvage = "tools/modifiers/salvage/ability/";
        String slotlessSalvage = "tools/modifiers/salvage/slotless/";
        String defenseFolder = "tools/modifiers/defense/";
        String defenseSalvage = "tools/modifiers/salvage/defense/";
        String compatFolder = "tools/modifiers/compat/";
        String compatSalvage = "tools/modifiers/salvage/compat/";
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.reinforced).setInput((ItemLike)TinkerModifiers.ironReinforcement, 1, 24).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.DURABILITY))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.reinforced, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.reinforced, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.overforced).setInput((ItemLike)TinkerModifiers.slimesteelReinforcement, 1, 24).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.DURABILITY))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.overforced, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.overforced, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.emerald).addInput((TagKey<Item>)Tags.Items.GEMS_EMERALD).setMaxLevel(1))).setSlots(SlotType.UPGRADE, 1))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.emerald, upgradeSalvage))).save(consumer, this.prefix(ModifierIds.emerald, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.diamond).addInput((TagKey<Item>)Tags.Items.GEMS_DIAMOND).setMaxLevel(1))).setSlots(SlotType.UPGRADE, 1))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.diamond, upgradeSalvage))).save(consumer, this.prefix(ModifierIds.diamond, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.worldbound).addInput(TinkerTags.Items.INGOTS_NETHERITE_SCRAP).setMaxLevel(1))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.worldbound, slotlessSalvage))).save(consumer, this.prefix(ModifierIds.worldbound, slotlessFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.soulbound).addInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42747_, Items.f_42686_})).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.soulbound, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.soulbound, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.netherite).addInput((TagKey<Item>)Tags.Items.INGOTS_NETHERITE).setMaxLevel(1))).setSlots(SlotType.UPGRADE, 1))).setRequirements(ModifierMatch.list(1, ModifierMatch.entry(ModifierIds.diamond), ModifierMatch.entry(ModifierIds.emerald))))).setRequirementsError(ModifierRecipeProvider.makeRequirementsError("netherite_requirements")))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.netherite, upgradeSalvage))).save(consumer, this.prefix(ModifierIds.netherite, upgradeFolder));
        OverslimeModifierRecipeBuilder.modifier((ItemLike)TinkerCommons.slimeball.get((Enum)SlimeType.EARTH), 10).save(consumer, this.modResource(slotlessFolder + "overslime/earth_ball"));
        OverslimeModifierRecipeBuilder.modifier((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.EARTH), 45).save(consumer, this.modResource(slotlessFolder + "overslime/earth_congealed"));
        OverslimeModifierRecipeBuilder.modifier((ItemLike)TinkerWorld.slime.get((Enum)SlimeType.EARTH), 108).save(consumer, this.modResource(slotlessFolder + "overslime/earth_block"));
        OverslimeModifierRecipeBuilder.modifier((ItemLike)TinkerCommons.slimeball.get((Enum)SlimeType.SKY), 40).save(consumer, this.modResource(slotlessFolder + "overslime/sky_ball"));
        OverslimeModifierRecipeBuilder.modifier((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.SKY), 180).save(consumer, this.modResource(slotlessFolder + "overslime/sky_congealed"));
        OverslimeModifierRecipeBuilder.modifier((ItemLike)TinkerWorld.slime.get((Enum)SlimeType.SKY), 432).save(consumer, this.modResource(slotlessFolder + "overslime/sky_block"));
        OverslimeModifierRecipeBuilder.modifier((ItemLike)TinkerCommons.slimeball.get((Enum)SlimeType.ICHOR), 100).save(consumer, this.modResource(slotlessFolder + "overslime/ichor_ball"));
        OverslimeModifierRecipeBuilder.modifier((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR), 450).save(consumer, this.modResource(slotlessFolder + "overslime/ichor_congealed"));
        OverslimeModifierRecipeBuilder.modifier((ItemLike)TinkerWorld.slime.get((Enum)SlimeType.ICHOR), 1080).save(consumer, this.modResource(slotlessFolder + "overslime/ichor_block"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.experienced).addInput((ItemLike)Items.f_42612_).addInput((ItemLike)Items.f_42612_).addInput((ItemLike)Items.f_42612_).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE_OR_HARVEST, TinkerTags.Items.LEGGINGS)))).includeUnarmed())).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.experienced, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.experienced, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.magnetic).addInput((ItemLike)Items.f_42522_).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.MELEE_OR_HARVEST))).save(consumer, this.prefix(TinkerModifiers.magnetic, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.magnetic).addInput((ItemLike)Items.f_42522_).setMaxLevel(1))).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.ARMOR))).save(consumer, this.wrap(TinkerModifiers.magnetic, upgradeFolder, "_armor"));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.magnetic).setSlots(SlotType.UPGRADE, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE_OR_HARVEST, TinkerTags.Items.ARMOR)))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.magnetic, upgradeSalvage));
        ((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.shiny).addInput((ItemLike)Items.f_42437_).setMaxLevel(1))).save(consumer, this.prefix(ModifierIds.shiny, slotlessFolder));
        ((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.farsighted).setTools(TinkerTags.Items.MODIFIABLE))).setInput((TagKey<Item>)Tags.Items.CROPS_CARROT, 1, 45).save(consumer, this.prefix(TinkerModifiers.farsighted, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.nearsighted).setTools(TinkerTags.Items.MODIFIABLE))).setInput((ItemLike)Items.f_42532_, 1, 45).save(consumer, this.prefix(TinkerModifiers.nearsighted, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.offhanded).setTools(TinkerTags.Items.HELD))).addInput((ItemLike)Items.f_42454_).addInput((ItemLike)Items.f_42613_).addInput(SlimeType.ICHOR.getSlimeballTag()).setMaxLevel(1))).setSalvageLevelRange(1, 1))).saveSalvage((Consumer)consumer, this.wrap(TinkerModifiers.offhanded, upgradeSalvage, "_level_1"))).save(consumer, this.wrap(TinkerModifiers.offhanded, upgradeFolder, "_level_1"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.offhanded).setTools(TinkerTags.Items.HELD))).addInput((ItemLike)Items.f_42454_).addInput((TagKey<Item>)TinkerMaterials.cobalt.getIngotTag()).addInput(SlimeType.ICHOR.getSlimeballTag()).setMaxLevel(2))).setMinSalvageLevel(2))).setRequirements(ModifierMatch.entry(TinkerModifiers.offhanded, 1)))).setRequirementsError(ModifierRecipeProvider.makeRequirementsError("offhanded.level_2")))).saveSalvage((Consumer)consumer, this.wrap(TinkerModifiers.offhanded, upgradeSalvage, "_level_2"))).save(consumer, this.wrap(TinkerModifiers.offhanded, upgradeFolder, "_level_2"));
        this.hasteRecipes(consumer, TinkerModifiers.haste.getId(), Ingredient.m_204132_(TinkerTags.Items.HARVEST), 5, upgradeFolder, null);
        this.hasteRecipes(consumer, TinkerModifiers.haste.getId(), ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HARVEST, TinkerTags.Items.CHESTPLATES), 5, null, upgradeSalvage);
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.blasting).setTools(TinkerTags.Items.STONE_HARVEST))).setInput((TagKey<Item>)Tags.Items.GUNPOWDER, 1, 20).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.blasting, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.blasting, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.hydraulic).setTools(TinkerTags.Items.HARVEST))).setInput((TagKey<Item>)Tags.Items.DUSTS_PRISMARINE, 1, 36).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.hydraulic, upgradeSalvage))).save(consumer, this.wrap(TinkerModifiers.hydraulic, upgradeFolder, "_from_shard"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.hydraulic).setTools(TinkerTags.Items.HARVEST))).setInput((ItemLike)Blocks.f_50377_, 4, 36).setLeftover(new ItemStack((ItemLike)Items.f_42695_)).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).save(consumer, this.wrap(TinkerModifiers.hydraulic, upgradeFolder, "_from_block"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.hydraulic).setTools(TinkerTags.Items.HARVEST))).setInput((ItemLike)Blocks.f_50378_, 9, 36).setLeftover(new ItemStack((ItemLike)Items.f_42695_)).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).save(consumer, this.wrap(TinkerModifiers.hydraulic, upgradeFolder, "_from_bricks"));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.lightspeed).setTools(TinkerTags.Items.HARVEST))).setInput((TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE, 1, 64).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.lightspeed, upgradeSalvage))).save(consumer, this.wrap(TinkerModifiers.lightspeed, upgradeFolder, "_from_dust"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.lightspeed).setTools(TinkerTags.Items.HARVEST))).setInput((ItemLike)Blocks.f_50141_, 4, 64).setLeftover(new ItemStack((ItemLike)Items.f_42525_)).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).save(consumer, this.wrap(TinkerModifiers.lightspeed, upgradeFolder, "_from_block"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.knockback).addInput((ItemLike)Items.f_41869_).addInput(TinkerTags.Items.SLIME_BLOCK).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.MELEE))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.knockback, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.knockback, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.padded).addInput((ItemLike)Items.f_42454_).addInput((TagKey<Item>)ItemTags.f_13167_).addInput((ItemLike)Items.f_42454_).setMaxLevel(3))).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.MELEE))).includeUnarmed())).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.padded, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.padded, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.severing).addInput(TinkerTags.Items.WITHER_BONES).addInput((ItemLike)Items.f_151041_).addInput(TinkerTags.Items.WITHER_BONES).addInput((ItemLike)Items.f_41996_).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.MELEE))).includeUnarmed())).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.severing, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.severing, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.fiery).setTools(TinkerTags.Items.MELEE))).setInput((ItemLike)Items.f_42593_, 1, 25).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).includeUnarmed())).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.fiery, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.fiery, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.necrotic).addInput((ItemLike)TinkerMaterials.necroticBone).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.BLOOD)).addInput((ItemLike)Items.f_42586_).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.MELEE))).includeUnarmed())).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.necrotic, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.necrotic, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.piercing).setTools(TinkerTags.Items.MELEE))).setInput((ItemLike)Blocks.f_50128_, 1, 25).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.piercing, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.piercing, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.smite).setTools(TinkerTags.Items.MELEE))).setInput((ItemLike)Items.f_42546_, 1, 5).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).includeUnarmed())).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.smite, upgradeSalvage))).save(consumer, this.prefix(ModifierIds.smite, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.baneOfSssss).setTools(TinkerTags.Items.MELEE))).setInput((ItemLike)Items.f_42592_, 1, 15).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).includeUnarmed())).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.baneOfSssss, upgradeSalvage))).save(consumer, this.prefix(ModifierIds.baneOfSssss, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.antiaquatic).setTools(TinkerTags.Items.MELEE))).setInput((ItemLike)Items.f_42529_, 1, 20).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).includeUnarmed())).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.antiaquatic, upgradeSalvage))).save(consumer, this.prefix(ModifierIds.antiaquatic, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.cooling).setTools(TinkerTags.Items.MELEE))).setInput((ItemLike)Items.f_42696_, 1, 25).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).includeUnarmed())).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.cooling, upgradeSalvage))).save(consumer, this.prefix(ModifierIds.cooling, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.killager).setTools(TinkerTags.Items.MELEE))).setInput((TagKey<Item>)Tags.Items.GEMS_LAPIS, 1, 45).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).includeUnarmed())).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.killager, upgradeSalvage))).save(consumer, this.wrap(ModifierIds.killager, upgradeFolder, "_from_dust"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.killager).setTools(TinkerTags.Items.MELEE))).setInput((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS, 9, 45).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).includeUnarmed())).save(consumer, this.wrap(ModifierIds.killager, upgradeFolder, "_from_block"));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.sharpness).setTools(TinkerTags.Items.MELEE))).setInput((TagKey<Item>)Tags.Items.GEMS_QUARTZ, 1, 36).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).includeUnarmed())).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.sharpness, upgradeSalvage))).save(consumer, this.wrap(ModifierIds.sharpness, upgradeFolder, "_from_shard"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.sharpness).setTools(TinkerTags.Items.MELEE))).setInput((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_QUARTZ, 4, 36).setLeftover(new ItemStack((ItemLike)Items.f_42692_)).setMaxLevel(5))).includeUnarmed())).setSlots(SlotType.UPGRADE, 1))).save(consumer, this.wrap(ModifierIds.sharpness, upgradeFolder, "_from_block"));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.sweeping).setTools(TinkerTags.Items.SWORD))).setInput((ItemLike)Blocks.f_50184_, 1, 18).setMaxLevel(4))).setSlots(SlotType.UPGRADE, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.sweeping, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.sweeping, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.swiftstrike).setTools(TinkerTags.Items.MELEE))).setInput((ItemLike)Items.f_151049_, 1, 72).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.swiftstrike, upgradeSalvage))).save(consumer, this.wrap(ModifierIds.swiftstrike, upgradeFolder, "_from_shard"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.swiftstrike).setTools(TinkerTags.Items.MELEE))).setInput((ItemLike)Blocks.f_152490_, 4, 72).setLeftover(new ItemStack((ItemLike)Items.f_151049_)).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).save(consumer, this.wrap(ModifierIds.swiftstrike, upgradeFolder, "_from_block"));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.meleeProtection).setInput((ItemLike)TinkerModifiers.cobaltReinforcement, 1, 24).setSlots(SlotType.DEFENSE, 1))).setTools(TinkerTags.Items.ARMOR))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.meleeProtection, defenseSalvage))).save(consumer, this.prefix(TinkerModifiers.meleeProtection, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.projectileProtection).setInput((ItemLike)TinkerModifiers.bronzeReinforcement, 1, 24).setSlots(SlotType.DEFENSE, 1))).setTools(TinkerTags.Items.ARMOR))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.projectileProtection, defenseSalvage))).save(consumer, this.prefix(TinkerModifiers.projectileProtection, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.blastProtection).setInput((ItemLike)TinkerModifiers.emeraldReinforcement, 1, 24).setSlots(SlotType.DEFENSE, 1))).setTools(TinkerTags.Items.ARMOR))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.blastProtection, defenseSalvage))).save(consumer, this.prefix(TinkerModifiers.blastProtection, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.magicProtection).setInput((ItemLike)TinkerModifiers.goldReinforcement, 1, 24).setSlots(SlotType.DEFENSE, 1))).setTools(TinkerTags.Items.ARMOR))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.magicProtection, defenseSalvage))).save(consumer, this.prefix(TinkerModifiers.magicProtection, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.fireProtection).setInput((ItemLike)TinkerModifiers.searedReinforcement, 1, 24).setSlots(SlotType.DEFENSE, 1))).setTools(TinkerTags.Items.ARMOR))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.fireProtection, defenseSalvage))).save(consumer, this.prefix(TinkerModifiers.fireProtection, defenseFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.protection).addInput((ItemLike)TinkerModifiers.goldReinforcement, 4).addInput((ItemLike)TinkerModifiers.searedReinforcement, 4).addInput((ItemLike)TinkerModifiers.bronzeReinforcement, 4).addInput((ItemLike)TinkerModifiers.emeraldReinforcement, 4).addInput((ItemLike)TinkerModifiers.cobaltReinforcement, 4).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.ARMOR))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.protection, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.protection, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.knockbackResistance).setTools(TinkerTags.Items.ARMOR))).addInput(SizedIngredient.fromItems((ItemLike[])new ItemLike[]{Blocks.f_50322_, Blocks.f_50323_, Blocks.f_50324_})).setSlots(SlotType.DEFENSE, 1))).setMaxLevel(1))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.knockbackResistance, defenseSalvage))).save(consumer, this.prefix(ModifierIds.knockbackResistance, defenseFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.golden).setTools(TinkerTags.Items.ARMOR))).addInput((TagKey<Item>)Tags.Items.INGOTS_GOLD).addInput((TagKey<Item>)Tags.Items.INGOTS_GOLD).addInput((TagKey<Item>)Tags.Items.INGOTS_GOLD).setSlots(SlotType.DEFENSE, 1))).setMaxLevel(1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.golden, defenseSalvage))).save(consumer, this.prefix(TinkerModifiers.golden, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.turtleShell).setInput((ItemLike)Items.f_42355_, 1, 5).setSlots(SlotType.DEFENSE, 1))).setTools(TinkerTags.Items.ARMOR))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.turtleShell, defenseSalvage))).save(consumer, this.prefix(TinkerModifiers.turtleShell, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.shulking).setInput((ItemLike)Items.f_42748_, 1, 5).setSlots(SlotType.DEFENSE, 1))).setTools(TinkerTags.Items.ARMOR))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.shulking, defenseSalvage))).save(consumer, this.prefix(TinkerModifiers.shulking, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.dragonborn).setInput((ItemLike)TinkerModifiers.dragonScale, 1, 10).setSlots(SlotType.DEFENSE, 1))).setTools(TinkerTags.Items.ARMOR))).saveSalvage((Consumer)consumer, this.prefix((Supplier)TinkerModifiers.dragonScale, defenseSalvage))).save(consumer, this.prefix((Supplier)TinkerModifiers.dragonScale, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.revitalizing).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.CHESTPLATES, TinkerTags.Items.LEGGINGS)))).setInput((ItemLike)TinkerCommons.jeweledApple, 1, 2).setSlots(SlotType.DEFENSE, 1))).setMaxLevel(3))).save(consumer, this.wrap(ModifierIds.revitalizing, defenseFolder, "_large"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.revitalizing).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HELMETS, TinkerTags.Items.BOOTS)))).setInput((ItemLike)TinkerCommons.jeweledApple, 1, 2).setSlots(SlotType.DEFENSE, 1))).setMaxLevel(2))).save(consumer, this.wrap(ModifierIds.revitalizing, defenseFolder, "_small"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.revitalizing).setTools(TinkerTags.Items.ARMOR))).setSlots(SlotType.DEFENSE, 1))).setMaxLevel(3))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.revitalizing, defenseSalvage));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.thorns).setTools(TinkerTags.Items.ARMOR))).setInput((ItemLike)Blocks.f_50128_, 1, 25).setMaxLevel(3))).setSlots(SlotType.UPGRADE, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.thorns, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.thorns, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.sticky).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE, TinkerTags.Items.ARMOR)))).setInput((ItemLike)Blocks.f_50033_, 1, 5).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(3))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.sticky, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.sticky, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.springy).setTools(TinkerTags.Items.ARMOR))).addInput((ItemLike)Items.f_41869_).addInput((ItemLike)TinkerWorld.slime.get((Enum)SlimeType.ICHOR)).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(3))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.springy, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.springy, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.respiration).setTools(TinkerTags.Items.HELMETS))).addInput((TagKey<Item>)ItemTags.f_13156_).addInput((TagKey<Item>)Tags.Items.GLASS_COLORLESS).addInput((TagKey<Item>)ItemTags.f_13156_).addInput((ItemLike)Items.f_41910_).addInput((ItemLike)Items.f_41910_).setMaxLevel(3))).setSlots(SlotType.UPGRADE, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.respiration, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.respiration, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.itemFrame).setTools(TinkerTags.Items.HELMETS))).addInput(Ingredient.m_43921_(Arrays.stream(FrameType.values()).filter(type -> type != FrameType.CLEAR).map(type -> new ItemStack((ItemLike)TinkerGadgets.itemFrame.get((Enum)type))))).setSlots(SlotType.UPGRADE, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.itemFrame, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.itemFrame, upgradeFolder));
        this.hasteRecipes(consumer, TinkerModifiers.hasteArmor.getId(), Ingredient.m_204132_(TinkerTags.Items.CHESTPLATES), 5, upgradeFolder, upgradeSalvage);
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.knockbackArmor).setTools(TinkerTags.Items.CHESTPLATES))).addInput((ItemLike)Items.f_41869_).addInput((ItemLike)TinkerWorld.slime.get((Enum)SlimeType.EARTH)).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(3))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.knockbackArmor, upgradeSalvage))).save(consumer, this.prefix(ModifierIds.knockbackArmor, upgradeFolder));
        this.hasteRecipes(consumer, ModifierIds.speedy, Ingredient.m_204132_(TinkerTags.Items.LEGGINGS), 3, upgradeFolder, upgradeSalvage);
        IncrementalModifierRecipeBuilder leapGeodeBuilder = (IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.leaping).setTools(TinkerTags.Items.LEGGINGS))).setInput((ItemLike)TinkerWorld.skyGeode.m_5456_(), 1, 36).setMaxLevel(2))).setSlots(SlotType.UPGRADE, 1));
        IncrementalModifierRecipeBuilder leapNoGeodeBuilder = (IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.leaping).setTools(TinkerTags.Items.LEGGINGS))).setInput((ItemLike)TinkerWorld.slimeDirt.get((Enum)SlimeType.SKY), 1, 18).setMaxLevel(2))).setSlots(SlotType.UPGRADE, 1));
        ConditionalRecipe.builder().addCondition((ICondition)ConfigEnabledCondition.SKY_GEODES).addRecipe(leapGeodeBuilder::save).addCondition((ICondition)TrueCondition.INSTANCE).addRecipe(leapNoGeodeBuilder::save).build(consumer, this.prefix(TinkerModifiers.leaping, upgradeFolder));
        leapGeodeBuilder.saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.leaping, upgradeSalvage));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.stepUp).setTools(TinkerTags.Items.LEGGINGS))).addInput((ItemLike)Items.f_42454_).addInput((ItemLike)Items.f_42677_).addInput((ItemLike)Items.f_42454_).addInput((ItemLike)Items.f_42340_).addInput((ItemLike)Items.f_42340_).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(2))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.stepUp, upgradeSalvage))).save(consumer, this.prefix(ModifierIds.stepUp, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.pocketChain).setTools(TinkerTags.Items.LEGGINGS))).addInput((TagKey<Item>)TinkerMaterials.cobalt.getIngotTag()).addInput((ItemLike)Items.f_42026_).addInput((ItemLike)Items.f_42026_).setMaxLevel(1))).setSlots(SlotType.UPGRADE, 1))).setRequirementsError(ModifierRecipeProvider.makeRequirementsError("pocket_chain")))).setRequirements(ModifierMatch.list(1, ModifierMatch.entry(TinkerModifiers.shieldStrap), ModifierMatch.entry(TinkerModifiers.toolBelt))))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.pocketChain, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.pocketChain, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.featherFalling).setTools(TinkerTags.Items.BOOTS))).setInput((ItemLike)Items.f_42402_, 1, 40).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(4))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.featherFalling, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.featherFalling, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.soulspeed).setTools(TinkerTags.Items.BOOTS))).addInput((ItemLike)Items.f_42258_).addInput((ItemLike)Items.f_42754_).addInput((ItemLike)Items.f_42258_).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(3))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.soulspeed, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.soulspeed, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.lightspeedArmor).setTools(TinkerTags.Items.BOOTS))).setInput((TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE, 1, 64).setMaxLevel(3))).setSlots(SlotType.UPGRADE, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.lightspeedArmor, upgradeSalvage))).save(consumer, this.wrap(TinkerModifiers.lightspeedArmor, upgradeFolder, "_from_dust"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.lightspeedArmor).setTools(TinkerTags.Items.BOOTS))).setInput((ItemLike)Blocks.f_50141_, 4, 64).setLeftover(new ItemStack((ItemLike)Items.f_42525_)).setMaxLevel(3))).setSlots(SlotType.UPGRADE, 1))).save(consumer, this.wrap(TinkerModifiers.lightspeedArmor, upgradeFolder, "_from_block"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.ricochet).setTools(TinkerTags.Items.ARMOR))).addInput((ItemLike)Items.f_41869_).addInput((ItemLike)TinkerWorld.slime.get((Enum)SlimeType.SKY)).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(2))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.ricochet, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.ricochet, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.zoom).setTools(TinkerTags.Items.HELMETS))).addInput((ItemLike)Items.f_151059_).addInput((TagKey<Item>)Tags.Items.STRING).addInput((ItemLike)Items.f_151059_).addInput((TagKey<Item>)Tags.Items.DUSTS_REDSTONE).addInput((TagKey<Item>)Tags.Items.DUSTS_REDSTONE).setSlots(SlotType.ABILITY, 1))).setMaxLevel(1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.zoom, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.zoom, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.slurping).addInput((ItemLike)Items.f_42590_).addInput(TinkerTags.Items.TANKS).addInput((ItemLike)Items.f_42590_).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.HELMETS))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.slurping, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.slurping, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.aquaAffinity).addInput((ItemLike)Blocks.f_50378_).addInput((ItemLike)Items.f_42716_).addInput((ItemLike)Blocks.f_50378_).addInput((ItemLike)Blocks.f_50379_).addInput((ItemLike)Blocks.f_50379_).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.HELMETS))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.aquaAffinity, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.aquaAffinity, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.unarmed).setTools(TinkerTags.Items.UNARMED))).addInput((ItemLike)Items.f_42454_).addInput((TagKey<Item>)Tags.Items.GEMS_DIAMOND).addInput((ItemLike)Items.f_42454_).addInput((TagKey<Item>)Tags.Items.STRING).addInput((TagKey<Item>)Tags.Items.STRING).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.unarmed, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.unarmed, abilityFolder));
        IncrementalModifierRecipeBuilder strengthGeodeBuilder = (IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.strength).setTools(TinkerTags.Items.CHESTPLATES))).setInput((ItemLike)TinkerWorld.ichorGeode.m_5456_(), 1, 72).setSlots(SlotType.ABILITY, 1));
        IncrementalModifierRecipeBuilder strengthNoGeodeBuilder = (IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.strength).setTools(TinkerTags.Items.CHESTPLATES))).setInput((ItemLike)TinkerWorld.slimeDirt.get((Enum)SlimeType.ICHOR), 1, 36).setSlots(SlotType.ABILITY, 1));
        ConditionalRecipe.builder().addCondition((ICondition)ConfigEnabledCondition.ICHOR_GEODES).addRecipe(strengthGeodeBuilder::save).addCondition((ICondition)TrueCondition.INSTANCE).addRecipe(strengthNoGeodeBuilder::save).build(consumer, this.prefix(ModifierIds.strength, abilityFolder));
        strengthGeodeBuilder.saveSalvage((Consumer)consumer, this.prefix(ModifierIds.strength, abilitySalvage));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.pockets).setTools(TinkerTags.Items.LEGGINGS))).addInput((ItemLike)Items.f_42748_).addInput((TagKey<Item>)Tags.Items.INGOTS_IRON).addInput((ItemLike)Items.f_42748_).addInput((ItemLike)Items.f_42454_).addInput((ItemLike)Items.f_42454_).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.pockets, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.pockets, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.shieldStrap).addInput((ItemLike)TinkerWorld.skySlimeVine).addInput((TagKey<Item>)TinkerMaterials.slimesteel.getIngotTag()).addInput((ItemLike)TinkerWorld.skySlimeVine).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.LEGGINGS))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.shieldStrap, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.shieldStrap, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.toolBelt).addInput((ItemLike)Items.f_42454_).addInput((TagKey<Item>)TinkerMaterials.hepatizon.getIngotTag()).addInput((ItemLike)Items.f_42454_).addInput((ItemLike)Items.f_42454_).addInput((ItemLike)Items.f_42454_).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.LEGGINGS))).setMaxLevel(2))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.toolBelt, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.toolBelt, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.wetting).addInput((TagKey<Item>)Tags.Items.DUSTS_REDSTONE).addInput(TinkerTags.Items.TANKS).addInput((TagKey<Item>)Tags.Items.DUSTS_REDSTONE).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.LEGGINGS))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.wetting, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.wetting, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.doubleJump).setTools(TinkerTags.Items.BOOTS))).addInput((ItemLike)Items.f_41869_).addInput((ItemLike)TinkerWorld.slime.get((Enum)SlimeType.SKY)).addInput((ItemLike)Items.f_41869_).addInput((ItemLike)Items.f_42714_).addInput((ItemLike)Items.f_42714_).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.doubleJump, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.doubleJump, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.bouncy).setTools((Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.m_204132_(TinkerTags.Items.BOOTS), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerTools.slimesuit.get((Enum)ArmorSlotType.BOOTS)}))))).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.SKY), 4).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR), 4).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.SKY), 4).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.EARTH), 4).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.EARTH), 4).setSlots(SlotType.ABILITY, 1))).setMaxLevel(1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.bouncy, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.bouncy, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.frostWalker).setTools(TinkerTags.Items.BOOTS))).addInput((ItemLike)Items.f_42363_).addInput((ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.STRAY)).addInput((ItemLike)Items.f_42363_).addInput((ItemLike)Items.f_42363_).addInput((ItemLike)Items.f_42363_).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.frostWalker, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.frostWalker, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.snowdrift).setTools(TinkerTags.Items.BOOTS))).addInput((ItemLike)Items.f_41981_).addInput((ItemLike)Items.f_42047_).addInput((ItemLike)Items.f_41981_).addInput((ItemLike)Items.f_41981_).addInput((ItemLike)Items.f_41981_).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.snowdrift, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.snowdrift, abilityFolder));
        Ingredient bootsWithDuraibility = IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.BOOTS), Ingredient.m_204132_(TinkerTags.Items.DURABILITY)});
        SizedIngredient roundPlate = SizedIngredient.of((Ingredient)MaterialIngredient.fromItem((IMaterialItem)TinkerToolParts.roundPlate.get()));
        SizedIngredient smallBlade = SizedIngredient.of((Ingredient)MaterialIngredient.fromItem((IMaterialItem)TinkerToolParts.smallBlade.get()));
        SizedIngredient toolBinding = SizedIngredient.of((Ingredient)MaterialIngredient.fromItem((IMaterialItem)TinkerToolParts.toolBinding.get()));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.pathMaker).setTools(bootsWithDuraibility))).addInput(roundPlate).addInput(TinkerTags.Items.INGOTS_NETHERITE_SCRAP).addInput(toolBinding).addInput(roundPlate).addInput(toolBinding).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.pathMaker, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.pathMaker, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.plowing).setTools(bootsWithDuraibility))).addInput(smallBlade).addInput(TinkerTags.Items.INGOTS_NETHERITE_SCRAP).addInput(toolBinding).addInput(smallBlade).addInput(toolBinding).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.plowing, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.plowing, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.flamewake).setTools(bootsWithDuraibility))).addInput((ItemLike)Items.f_42484_).addInput(TinkerTags.Items.INGOTS_NETHERITE_SCRAP).addInput((ItemLike)Items.f_42484_).addInput((ItemLike)Items.f_42484_).addInput((ItemLike)Items.f_42484_).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.flamewake, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.flamewake, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.gilded).addInput((ItemLike)Items.f_42436_).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.gilded, abilitySalvage))).save(consumer, this.prefix(ModifierIds.gilded, abilityFolder));
        this.luckRecipes(consumer, ModifierIds.luck, TinkerTags.Items.MELEE_OR_HARVEST, SlotType.ABILITY, false, abilityFolder, abilitySalvage);
        this.luckRecipes(consumer, ModifierIds.looting, TinkerTags.Items.UNARMED, SlotType.UPGRADE, true, upgradeFolder, upgradeSalvage);
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.luck).setTools(TinkerTags.Items.LEGGINGS))).addInput(SizedIngredient.fromItems((ItemLike[])new ItemLike[]{Items.f_41949_, Items.f_41941_})).addInput((ItemLike)Items.f_42648_).addInput((ItemLike)Items.f_42677_).addInput((TagKey<Item>)Tags.Items.GEMS_DIAMOND).addInput((ItemLike)Items.f_42656_).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.wrap(ModifierIds.luck, abilitySalvage, "_pants"))).save(consumer, this.wrap(ModifierIds.luck, abilityFolder, "_pants"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.silky).addInput((ItemLike)TinkerModifiers.silkyCloth).addInput((ItemLike)TinkerModifiers.silkyCloth).addInput((ItemLike)TinkerModifiers.silkyCloth).addInput((ItemLike)TinkerModifiers.silkyCloth).addInput((ItemLike)TinkerModifiers.silkyCloth).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.HARVEST))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.silky, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.silky, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.exchanging).addInput((ItemLike)Items.f_41862_).addInput((TagKey<Item>)TinkerMaterials.hepatizon.getIngotTag()).addInput((ItemLike)Items.f_41862_).addInput((TagKey<Item>)Tags.Items.ENDER_PEARLS).addInput((TagKey<Item>)Tags.Items.ENDER_PEARLS).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.HARVEST))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.exchanging, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.exchanging, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.autosmelt).addInput((TagKey<Item>)Tags.Items.RAW_MATERIALS).addInput((ItemLike)Blocks.f_50620_).addInput((TagKey<Item>)Tags.Items.INGOTS).addInput((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COAL).addInput((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COAL).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.HARVEST))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.autosmelt, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.autosmelt, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.melting).addInput((ItemLike)Items.f_42585_).addInput((ItemLike)TinkerSmeltery.searedMelter).addInput((ItemLike)Items.f_42585_).addInput((ItemLike)Items.f_42448_).addInput((ItemLike)Items.f_42448_).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.MELEE_OR_HARVEST))).includeUnarmed())).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.melting, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.melting, abilityFolder));
        SizedIngredient faucets = SizedIngredient.fromItems((ItemLike[])new ItemLike[]{TinkerSmeltery.searedFaucet, TinkerSmeltery.scorchedFaucet});
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.bucketing).addInput(faucets).addInput((ItemLike)Items.f_42446_).addInput(faucets).addInput((TagKey<Item>)Tags.Items.ENDER_PEARLS).addInput((TagKey<Item>)Tags.Items.ENDER_PEARLS).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.INTERACTABLE))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.bucketing, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.bucketing, abilityFolder));
        SizedIngredient channels = SizedIngredient.fromItems((ItemLike[])new ItemLike[]{TinkerSmeltery.searedChannel, TinkerSmeltery.scorchedChannel});
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.spilling).addInput(channels).addInput(TinkerTags.Items.TANKS).addInput(channels).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).setSlots(SlotType.ABILITY, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE, TinkerTags.Items.CHESTPLATES)))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.spilling, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.spilling, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.tank).addInput(TinkerTags.Items.TANKS).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.INTERACTABLE, TinkerTags.Items.HELMETS, TinkerTags.Items.LEGGINGS)))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.tank, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.tank, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.expanded).addInput((ItemLike)Items.f_41869_).addInput((TagKey<Item>)TinkerMaterials.amethystBronze.getIngotTag()).addInput((ItemLike)Items.f_41869_).addInput(SlimeType.ICHOR.getSlimeballTag()).addInput(SlimeType.ICHOR.getSlimeballTag()).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.AOE))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.expanded, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.expanded, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.reach).setTools(TinkerTags.Items.CHESTPLATES))).addInput((ItemLike)Items.f_41869_).addInput((TagKey<Item>)TinkerMaterials.queensSlime.getIngotTag()).addInput((ItemLike)Items.f_41869_).addInput(SlimeType.ENDER.getSlimeballTag()).addInput(SlimeType.ENDER.getSlimeballTag()).setSlots(SlotType.ABILITY, 1))).save(consumer, this.prefix(ModifierIds.reach, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.reach).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HARVEST, TinkerTags.Items.CHESTPLATES)))).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.reach, abilitySalvage));
        Ingredient heldWithDurability = IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.DURABILITY), Ingredient.m_204132_(TinkerTags.Items.INTERACTABLE)});
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.pathing).setTools((Ingredient)DifferenceIngredient.of((Ingredient)heldWithDurability, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerTools.mattock, TinkerTools.excavator}))))).addInput(roundPlate).addInput((TagKey<Item>)TinkerMaterials.cobalt.getIngotTag()).addInput(toolBinding).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.pathing, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.pathing, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.stripping).setTools((Ingredient)DifferenceIngredient.of((Ingredient)heldWithDurability, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerTools.handAxe, TinkerTools.broadAxe}))))).addInput(SizedIngredient.of((Ingredient)MaterialIngredient.fromItem((IMaterialItem)TinkerToolParts.smallAxeHead.get()))).addInput((TagKey<Item>)TinkerMaterials.cobalt.getIngotTag()).addInput(toolBinding).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.stripping, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.stripping, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.tilling).setTools((Ingredient)DifferenceIngredient.of((Ingredient)heldWithDurability, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerTools.kama, TinkerTools.scythe}))))).addInput(smallBlade).addInput((TagKey<Item>)TinkerMaterials.cobalt.getIngotTag()).addInput(toolBinding).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.tilling, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.tilling, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.glowing).setTools(heldWithDurability))).addInput((ItemLike)Items.f_42054_).addInput((ItemLike)Items.f_42152_).addInput((ItemLike)Items.f_42783_).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.glowing, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.glowing, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.firestarter).setTools((Ingredient)DifferenceIngredient.of((Ingredient)heldWithDurability, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerTools.flintAndBrick}))))).addInput((TagKey<Item>)TinkerMaterials.cobalt.getIngotTag()).addInput((ItemLike)Items.f_42484_).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.firestarter, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.firestarter, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.fireprimer).setTools(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerTools.flintAndBrick})))).addInput((TagKey<Item>)TinkerMaterials.cobalt.getIngotTag()).addInput((ItemLike)Items.f_42484_).setMaxLevel(1))).setSlots(SlotType.UPGRADE, 1))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.fireprimer, upgradeSalvage))).save(consumer, this.prefix(TinkerModifiers.fireprimer, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.unbreakable).addInput((ItemLike)Items.f_42748_).addInput((ItemLike)Items.f_42735_).addInput((ItemLike)Items.f_42748_).addInput((TagKey<Item>)Tags.Items.INGOTS_NETHERITE).addInput((TagKey<Item>)Tags.Items.INGOTS_NETHERITE).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).setRequirements(ModifierMatch.list(2, ModifierMatch.entry(ModifierIds.netherite, 1), ModifierMatch.entry(TinkerModifiers.reinforced, 5))))).setRequirementsError(ModifierRecipeProvider.makeRequirementsError("unbreakable_requirements")))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.unbreakable, abilitySalvage))).save(consumer, this.prefix(TinkerModifiers.unbreakable, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.dualWielding).addInput((TagKey<Item>)TinkerMaterials.manyullyn.getIngotTag()).addInput((ItemLike)Items.f_42715_).addInput((TagKey<Item>)TinkerMaterials.manyullyn.getIngotTag()).addInput(SlimeType.SKY.getSlimeballTag()).addInput(SlimeType.SKY.getSlimeballTag()).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).setTools((Ingredient)DifferenceIngredient.of((Ingredient)IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.MELEE), Ingredient.m_204132_(TinkerTags.Items.ONE_HANDED)}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerTools.dagger}))))).save(consumer, this.wrap(TinkerModifiers.dualWielding, abilityFolder, "_one_handed"));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.dualWielding).addInput((TagKey<Item>)TinkerMaterials.manyullyn.getIngotTag()).addInput((ItemLike)Items.f_42715_).addInput((TagKey<Item>)TinkerMaterials.manyullyn.getIngotTag()).addInput(SlimeType.SKY.getSlimeballTag()).addInput(SlimeType.SKY.getSlimeballTag()).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).setRequirements(ModifierMatch.entry(TinkerModifiers.offhanded)))).setRequirementsError(ModifierRecipeProvider.makeRequirementsError("two_handed_dual_wielding")))).setTools(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.MELEE), Ingredient.m_204132_(TinkerTags.Items.TWO_HANDED)})))).save(consumer, this.wrap(TinkerModifiers.dualWielding, abilityFolder, "_two_handed"));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.dualWielding).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).setTools((Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.m_204132_(TinkerTags.Items.MELEE), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerTools.dagger}))))).saveSalvage((Consumer)consumer, this.prefix(TinkerModifiers.dualWielding, abilitySalvage));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.writable).addInput((ItemLike)Items.f_42614_).setMaxLevel(1))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.writable, slotlessSalvage))).save(consumer, this.prefix(ModifierIds.writable, slotlessFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.harmonious).addInput((TagKey<Item>)ItemTags.f_13158_).setMaxLevel(1))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.harmonious, slotlessSalvage))).save(consumer, this.prefix(ModifierIds.harmonious, slotlessFolder));
        ((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.recapitated).addInput(SizedIngredient.of((Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.HEADS), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42683_})))).setMaxLevel(1))).save(consumer, this.prefix(ModifierIds.recapitated, slotlessFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.resurrected).addInput((ItemLike)Items.f_42729_).setMaxLevel(1))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.resurrected, slotlessSalvage))).save(consumer, this.prefix(ModifierIds.resurrected, slotlessFolder));
        ((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.draconic).addInput((ItemLike)Items.f_42683_).setMaxLevel(1))).save(consumer, this.wrap(ModifierIds.draconic, slotlessFolder, "_from_head"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.draconic).addInput((ItemLike)Blocks.f_50070_).addInput((ItemLike)TinkerModifiers.dragonScale).addInput((ItemLike)Blocks.f_50070_).addInput((ItemLike)TinkerModifiers.dragonScale).addInput((ItemLike)TinkerModifiers.dragonScale).setMaxLevel(1))).saveSalvage((Consumer)consumer, this.prefix(ModifierIds.draconic, slotlessSalvage))).save(consumer, this.wrap(ModifierIds.draconic, slotlessFolder, "_from_scales"));
        SpecialRecipeBuilder.m_126357_((SimpleRecipeSerializer)((SimpleRecipeSerializer)TinkerModifiers.creativeSlotSerializer.get())).m_126359_(consumer, this.modPrefix(slotlessFolder + "creative_slot"));
        ModifierRemovalRecipe.Builder.removal(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50057_}), new ItemStack((ItemLike)Blocks.f_50056_)).save(consumer, this.modResource(slotlessFolder + "remove_modifier"));
        String theOneProbe = "theoneprobe";
        ResourceLocation probe = new ResourceLocation(theOneProbe, "probe");
        Consumer topConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded(theOneProbe)});
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.theOneProbe).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HELMETS, TinkerTags.Items.HELD)))).addInput((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{probe})).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(1))).saveSalvage(topConsumer, this.prefix(TinkerModifiers.theOneProbe, compatSalvage))).save(topConsumer, this.prefix(TinkerModifiers.theOneProbe, compatFolder));
    }

    private void addTextureRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/modifiers/slotless/";
        consumer.accept(new ArmorDyeingRecipe.Finished(this.modResource(folder + "travelers_dyeing"), Ingredient.m_43921_(TinkerTools.travelersGear.values().stream().map(ItemStack::new))));
        Ingredient plate = Ingredient.m_43921_(TinkerTools.plateArmor.values().stream().map(ItemStack::new));
        this.plateTexture(consumer, plate, MaterialIds.iron, false, folder);
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, MaterialIds.oxidizedIron.toString()).setTools(plate))).addInput((TagKey<Item>)Tags.Items.RAW_MATERIALS_IRON).addInput((TagKey<Item>)Tags.Items.RAW_MATERIALS_IRON).addInput((TagKey<Item>)Tags.Items.RAW_MATERIALS_IRON).save(consumer, this.wrap(TinkerModifiers.embellishment, folder, "_iron_oxidized"));
        this.plateTexture(consumer, plate, MaterialIds.copper, false, folder);
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, MaterialIds.oxidizedCopper.toString()).setTools(plate))).addInput((TagKey<Item>)Tags.Items.RAW_MATERIALS_COPPER).addInput((TagKey<Item>)Tags.Items.RAW_MATERIALS_COPPER).addInput((TagKey<Item>)Tags.Items.RAW_MATERIALS_COPPER).save(consumer, this.wrap(TinkerModifiers.embellishment, folder, "_copper_oxidized"));
        this.plateTexture(consumer, plate, MaterialIds.slimesteel, false, folder);
        this.plateTexture(consumer, plate, MaterialIds.amethystBronze, false, folder);
        this.plateTexture(consumer, plate, MaterialIds.roseGold, false, folder);
        this.plateTexture(consumer, plate, MaterialIds.pigIron, false, folder);
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, MaterialIds.obsidian.toString()).setTools(plate))).addInput((ItemLike)TinkerCommons.obsidianPane).addInput((ItemLike)TinkerCommons.obsidianPane).addInput((ItemLike)TinkerCommons.obsidianPane).save(consumer, this.wrap(TinkerModifiers.embellishment, folder, "_obsidian"));
        this.plateTexture(consumer, plate, MaterialIds.debris, "nuggets/netherite_scrap", false, folder);
        this.plateTexture(consumer, plate, MaterialIds.manyullyn, false, folder);
        this.plateTexture(consumer, plate, MaterialIds.hepatizon, false, folder);
        this.plateTexture(consumer, plate, MaterialIds.netherite, "nuggets/netherite", false, folder);
        this.plateTexture(consumer, plate, MaterialIds.osmium, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.tungsten, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.platinum, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.silver, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.lead, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.aluminum, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.nickel, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.tin, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.zinc, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.uranium, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.steel, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.bronze, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.constantan, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.invar, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.electrum, true, folder);
        this.plateTexture(consumer, plate, MaterialIds.brass, true, folder);
        Ingredient slimesuit = Ingredient.m_43921_(TinkerTools.slimesuit.values().stream().map(ItemStack::new));
        this.slimeTexture(consumer, slimesuit, MaterialIds.earthslime, SlimeType.EARTH, folder);
        this.slimeTexture(consumer, slimesuit, MaterialIds.skyslime, SlimeType.SKY, folder);
        this.slimeTexture(consumer, slimesuit, MaterialIds.blood, SlimeType.BLOOD, folder);
        this.slimeTexture(consumer, slimesuit, MaterialIds.ichor, SlimeType.ICHOR, folder);
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, MaterialIds.clay.toString()).setTools(slimesuit))).addInput((ItemLike)Blocks.f_50129_).addInput((ItemLike)Items.f_42461_).addInput((ItemLike)Blocks.f_50129_).save(consumer, this.wrap(TinkerModifiers.embellishment, folder, "_clay"));
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, MaterialIds.honey.toString()).setTools(slimesuit))).addInput((ItemLike)Blocks.f_50719_).addInput((ItemLike)Items.f_42787_).addInput((ItemLike)Blocks.f_50719_).save(consumer, this.wrap(TinkerModifiers.embellishment, folder, "_honey"));
    }

    private void addHeadRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/severing/";
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)EntityType.f_20501_), (ItemLike)Items.f_42681_).save(consumer, this.modResource(folder + "zombie_head"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)EntityType.f_20524_), (ItemLike)Items.f_42678_).save(consumer, this.modResource(folder + "skeleton_skull"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20497_, EntityType.f_20496_}), (ItemLike)Items.f_42679_).save(consumer, this.modResource(folder + "wither_skeleton_skull"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)EntityType.f_20558_), (ItemLike)Items.f_42682_).save(consumer, this.modResource(folder + "creeper_head"));
        SpecialRecipeBuilder.m_126357_((SimpleRecipeSerializer)((SimpleRecipeSerializer)TinkerModifiers.playerBeheadingSerializer.get())).m_126359_(consumer, this.modPrefix(folder + "player_head"));
        SpecialRecipeBuilder.m_126357_((SimpleRecipeSerializer)((SimpleRecipeSerializer)TinkerModifiers.snowGolemBeheadingSerializer.get())).m_126359_(consumer, this.modPrefix(folder + "snow_golem_head"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)EntityType.f_20460_), (ItemLike)Blocks.f_50143_).save(consumer, this.modResource(folder + "iron_golem_head"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)EntityType.f_20565_), (ItemLike)Items.f_42683_).save(consumer, this.modResource(folder + "ender_dragon_head"));
        TinkerWorld.headItems.forEach((type, head) -> SeveringRecipeBuilder.severing(EntityIngredient.of(type.getType()), (ItemLike)head).save(consumer, this.modResource(folder + type.m_7912_() + "_head")));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20479_, EntityType.f_20554_}), (ItemLike)Items.f_42591_).save(consumer, this.modResource(folder + "spider_eye"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)EntityType.f_20558_), (ItemLike)Blocks.f_50077_).save(consumer, this.modResource(folder + "creeper_tnt"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)EntityType.f_20509_), (ItemLike)Items.f_42714_).save(consumer, this.modResource(folder + "phantom_membrane"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)EntityType.f_20521_), (ItemLike)Items.f_42748_).save(consumer, this.modResource(folder + "shulker_shell"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20524_, EntityType.f_20525_, EntityType.f_20481_}), ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)Items.f_42500_, 2))).save(consumer, this.modResource(folder + "skeleton_bone"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)EntityType.f_20497_), ItemOutput.fromStack((ItemStack)new ItemStack(TinkerMaterials.necroticBone, 2))).save(consumer, this.modResource(folder + "wither_skeleton_bone"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)EntityType.f_20551_), ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)Items.f_42585_, 2))).save(consumer, this.modResource(folder + "blaze_rod"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20526_, (EntityType)TinkerWorld.earthSlimeEntity.get()}), (ItemLike)Items.f_42518_).save(consumer, this.modResource(folder + "earthslime_ball"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)((EntityType)TinkerWorld.skySlimeEntity.get())), (ItemLike)TinkerCommons.slimeball.get((Enum)SlimeType.SKY)).save(consumer, this.modResource(folder + "skyslime_ball"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)((EntityType)TinkerWorld.enderSlimeEntity.get())), (ItemLike)TinkerCommons.slimeball.get((Enum)SlimeType.ENDER)).save(consumer, this.modResource(folder + "enderslime_ball"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)((EntityType)TinkerWorld.terracubeEntity.get())), (ItemLike)Items.f_42461_).save(consumer, this.modResource(folder + "terracube_clay"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)EntityType.f_20468_), (ItemLike)Items.f_42542_).save(consumer, this.modResource(folder + "magma_cream"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20455_, EntityType.f_20563_}), ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)Items.f_42695_, 2))).save(consumer, this.modResource(folder + "guardian_shard"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)EntityType.f_20517_), (ItemLike)Items.f_42648_).setChildOutput(null).save(consumer, this.modResource(folder + "rabbit_foot"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)EntityType.f_20555_), ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)Items.f_42402_, 2))).setChildOutput(null).save(consumer, this.modResource(folder + "chicken_feather"));
        SpecialRecipeBuilder.m_126357_((SimpleRecipeSerializer)((SimpleRecipeSerializer)TinkerModifiers.mooshroomDemushroomingSerializer.get())).m_126359_(consumer, this.modPrefix(folder + "mooshroom_shroom"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType)EntityType.f_20490_), (ItemLike)Items.f_42354_).setChildOutput(ItemOutput.fromItem((ItemLike)Items.f_42355_)).save(consumer, this.modResource(folder + "turtle_shell"));
        SpecialRecipeBuilder.m_126357_((SimpleRecipeSerializer)((SimpleRecipeSerializer)TinkerModifiers.sheepShearing.get())).m_126359_(consumer, this.modPrefix(folder + "sheep_wool"));
    }

    private void addSpillingRecipes(Consumer<FinishedRecipe> consumer) {
    }

    private void plateTexture(Consumer<FinishedRecipe> consumer, Ingredient tool, MaterialId material, boolean optional, String folder) {
        this.plateTexture(consumer, tool, material, "ingots/" + material.m_135815_(), optional, folder);
    }

    private void plateTexture(Consumer<FinishedRecipe> consumer, Ingredient tool, MaterialVariantId material, String tag, boolean optional, String folder) {
        Ingredient ingot = Ingredient.m_204132_((TagKey)this.getItemTag("forge", tag));
        if (optional) {
            consumer = this.withCondition(consumer, new ICondition[]{this.tagCondition(tag)});
        }
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, material.toString()).setTools(tool))).addInput(ingot).addInput(ingot).addInput(ingot).save(consumer, this.wrap(TinkerModifiers.embellishment, folder, "_" + material.getLocation('_').m_135815_()));
    }

    private void slimeTexture(Consumer<FinishedRecipe> consumer, Ingredient tool, MaterialId material, SlimeType slime, String folder) {
        ItemLike congealed = (ItemLike)TinkerWorld.congealedSlime.get((Enum)slime);
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, material.toString()).setTools(tool))).addInput(congealed).addInput((ItemLike)TinkerWorld.slime.get((Enum)slime)).addInput(congealed).save(consumer, this.wrap(TinkerModifiers.embellishment, folder, "_" + slime.m_7912_()));
    }

    private void luckRecipes(Consumer<FinishedRecipe> consumer, ModifierId modifier, TagKey<Item> tools, SlotType slotType, boolean unarmed, String folder, String salvage) {
        String key = modifier.m_135815_();
        ModifierRecipeBuilder builder1 = (ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(modifier).setTools(tools))).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).addInput(SizedIngredient.fromItems((ItemLike[])new ItemLike[]{Items.f_41949_, Items.f_41941_})).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).addInput((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS).addInput((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS).setSalvageLevelRange(1, 1))).setMaxLevel(1))).setSlots(slotType, 1));
        if (unarmed) {
            builder1.setRequirements(ModifierMatch.entry(TinkerModifiers.unarmed));
            builder1.setRequirementsError(TConstruct.makeTranslationKey("recipe", "modifier.unarmed"));
        }
        ((ModifierRecipeBuilder)builder1.saveSalvage((Consumer)consumer, this.wrap(modifier, salvage, "_level_1"))).save(consumer, this.wrap(modifier, folder, "_level_1"));
        ModifierRecipeBuilder builder2 = (ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(modifier).setTools(tools))).addInput((TagKey<Item>)Tags.Items.INGOTS_GOLD).addInput((ItemLike)Items.f_42677_).addInput((TagKey<Item>)Tags.Items.INGOTS_GOLD).addInput((TagKey<Item>)Tags.Items.ENDER_PEARLS).addInput((TagKey<Item>)Tags.Items.ENDER_PEARLS).setRequirements(ModifierMatch.entry(modifier, 1)))).setRequirementsError(ModifierRecipeProvider.makeRequirementsError(key + ".level_2")))).setSalvageLevelRange(2, 2))).setMaxLevel(2));
        ModifierRecipeBuilder builder3 = (ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(modifier).setTools(tools))).addInput((TagKey<Item>)TinkerMaterials.roseGold.getIngotTag()).addInput((ItemLike)Items.f_42648_).addInput((TagKey<Item>)TinkerMaterials.roseGold.getIngotTag()).addInput((TagKey<Item>)Tags.Items.GEMS_DIAMOND).addInput((ItemLike)Items.f_42656_).setRequirements(ModifierMatch.entry(modifier, 2)))).setRequirementsError(ModifierRecipeProvider.makeRequirementsError(key + ".level_3")))).setSalvageLevelRange(3, 3))).setMaxLevel(3));
        if (slotType == SlotType.UPGRADE) {
            builder2.setSlots(slotType, 1);
            builder3.setSlots(slotType, 1);
        }
        ((ModifierRecipeBuilder)builder2.saveSalvage((Consumer)consumer, this.wrap(modifier, salvage, "_level_2"))).save(consumer, this.wrap(modifier, folder, "_level_2"));
        ((ModifierRecipeBuilder)builder3.saveSalvage((Consumer)consumer, this.wrap(modifier, salvage, "_level_3"))).save(consumer, this.wrap(modifier, folder, "_level_3"));
    }

    public void hasteRecipes(Consumer<FinishedRecipe> consumer, ModifierId modifier, Ingredient tools, int maxLevel, @Nullable String recipeFolder, @Nullable String salvageFolder) {
        IncrementalModifierRecipeBuilder builder = (IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(modifier).setTools(tools))).setInput((TagKey<Item>)Tags.Items.DUSTS_REDSTONE, 1, 45).setMaxLevel(maxLevel))).setSlots(SlotType.UPGRADE, 1));
        if (salvageFolder != null) {
            builder.saveSalvage((Consumer)consumer, this.prefix(modifier, salvageFolder));
        }
        if (recipeFolder != null) {
            builder.save(consumer, this.wrap(modifier, recipeFolder, "_from_dust"));
            ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(modifier).setTools(tools))).setInput((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE, 9, 45).setLeftover(new ItemStack((ItemLike)Items.f_42451_)).setMaxLevel(maxLevel))).setSlots(SlotType.UPGRADE, 1))).save(consumer, this.wrap(modifier, recipeFolder, "_from_block"));
        }
    }

    public ResourceLocation prefix(LazyModifier modifier, String prefix) {
        return this.prefix(modifier.getId(), prefix);
    }

    public ResourceLocation wrap(LazyModifier modifier, String prefix, String suffix) {
        return this.wrap(modifier.getId(), prefix, suffix);
    }

    private static String makeRequirementsError(String recipe) {
        return TConstruct.makeTranslationKey("recipe", "modifier." + recipe);
    }

    @SafeVarargs
    private static Ingredient ingredientFromTags(TagKey<Item> ... tags) {
        Ingredient[] tagIngredients = new Ingredient[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            tagIngredients[i] = Ingredient.m_204132_(tags[i]);
        }
        return CompoundIngredient.of((Ingredient[])tagIngredients);
    }
}

