/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.ISafeManagerReloadListener;
import slimeknights.tconstruct.tools.client.ArmorModelHelper;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.item.SlimesuitItem;

public class SlimelytraArmorModel
extends Model {
    private static final SlimelytraArmorModel INSTANCE = new SlimelytraArmorModel();
    private static final Map<String, RenderType> WING_RENDER_CACHE = new HashMap<String, RenderType>();
    private static final Function<String, RenderType> WING_GETTER = mat -> RenderType.m_110464_((ResourceLocation)new ResourceLocation(SlimesuitItem.makeArmorTexture(mat, "wings")));
    public static final ISafeManagerReloadListener RELOAD_LISTENER = manager -> {
        SlimelytraArmorModel.INSTANCE.elytraModel = null;
        WING_RENDER_CACHE.clear();
    };
    @Nullable
    private ElytraModel<LivingEntity> elytraModel;
    @Nullable
    private HumanoidModel<?> base;
    private String material = MaterialIds.enderslime.toString();
    private boolean hasGlint = false;

    public static Model getModel(LivingEntity living, ItemStack stack, HumanoidModel<?> baseModel) {
        INSTANCE.setup(baseModel, living, stack);
        return INSTANCE;
    }

    public SlimelytraArmorModel() {
        super(RenderType::m_110458_);
    }

    private ElytraModel<LivingEntity> getElytraModel() {
        if (this.elytraModel == null) {
            this.elytraModel = new ElytraModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171141_));
        }
        return this.elytraModel;
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.base != null) {
            this.base.m_7695_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            if (ArmorModelHelper.buffer != null) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_(0.0, 0.0, 0.125);
                VertexConsumer elytraBuffer = ItemRenderer.m_115184_((MultiBufferSource)ArmorModelHelper.buffer, (RenderType)WING_RENDER_CACHE.computeIfAbsent(this.material, WING_GETTER), (boolean)false, (boolean)this.hasGlint);
                this.getElytraModel().m_7695_(matrixStackIn, elytraBuffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                matrixStackIn.m_85849_();
            }
        }
    }

    private void setup(HumanoidModel<?> base, LivingEntity living, ItemStack stack) {
        this.base = base;
        ElytraModel<LivingEntity> elytraModel = this.getElytraModel();
        elytraModel.m_6973_(living, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        ArmorModelHelper.copyProperties(base, elytraModel);
        this.material = SlimesuitItem.getMaterial(stack);
        this.hasGlint = stack.m_41790_();
    }
}

