/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.menu;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.util.sync.LambdaDataSlot;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.entity.inventory.LazyResultContainer;
import slimeknights.tconstruct.tables.block.entity.table.PartBuilderBlockEntity;
import slimeknights.tconstruct.tables.menu.TabbedContainerMenu;
import slimeknights.tconstruct.tables.menu.slot.LazyResultSlot;

public class PartBuilderContainerMenu
extends TabbedContainerMenu<PartBuilderBlockEntity> {
    private final Slot patternSlot;
    private final Slot inputSlot;
    private final LazyResultSlot outputSlot;

    public PartBuilderContainerMenu(int windowIdIn, Inventory playerInventoryIn, @Nullable PartBuilderBlockEntity partBuilderTileEntity) {
        super((MenuType)TinkerTables.partBuilderContainer.get(), windowIdIn, playerInventoryIn, partBuilderTileEntity);
        if (this.tile != null) {
            this.outputSlot = new LazyResultSlot(((PartBuilderBlockEntity)this.tile).getCraftingResult(), 148, 33);
            this.m_38897_(this.outputSlot);
            this.patternSlot = new PatternSlot((PartBuilderBlockEntity)this.tile, 8, 34);
            this.m_38897_(this.patternSlot);
            this.inputSlot = new PartBuilderSlot((PartBuilderBlockEntity)this.tile, 0, 29, 34);
            this.m_38897_(this.inputSlot);
            this.addChestSideInventory();
            this.addInventorySlots();
            this.m_38895_((DataSlot)new LambdaDataSlot(-1, ((PartBuilderBlockEntity)this.tile)::getSelectedIndex, i -> {
                ((PartBuilderBlockEntity)this.tile).selectRecipe(i);
                this.updateScreen();
            }));
            this.updateScreen();
        } else {
            this.patternSlot = null;
            this.inputSlot = null;
            this.outputSlot = null;
        }
    }

    public PartBuilderContainerMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, (PartBuilderBlockEntity)PartBuilderContainerMenu.getTileEntityFromBuf((FriendlyByteBuf)buf, PartBuilderBlockEntity.class));
    }

    public void m_6199_(Container inventoryIn) {
    }

    public boolean m_6366_(Player playerIn, int id) {
        if (id >= 0 && this.tile != null) {
            ((PartBuilderBlockEntity)this.tile).selectRecipe(id);
        }
        return true;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn != this.outputSlot && super.m_5882_(stack, slotIn);
    }

    public Slot getPatternSlot() {
        return this.patternSlot;
    }

    public Slot getInputSlot() {
        return this.inputSlot;
    }

    public LazyResultSlot getOutputSlot() {
        return this.outputSlot;
    }

    private static class PatternSlot
    extends PartBuilderSlot {
        private PatternSlot(PartBuilderBlockEntity tile, int x, int y) {
            super(tile, 1, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_204117_(TinkerTags.Items.PATTERNS);
        }
    }

    private static class PartBuilderSlot
    extends Slot {
        private final LazyResultContainer craftResult;

        public PartBuilderSlot(PartBuilderBlockEntity tile, int index, int xPosition, int yPosition) {
            super((Container)tile, index, xPosition, yPosition);
            this.craftResult = tile.getCraftingResult();
        }

        public void m_6654_() {
            this.craftResult.m_6211_();
            super.m_6654_();
        }
    }
}

