/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.TabsWidget;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.tables.block.ITabbedBlock;
import slimeknights.tconstruct.tables.client.inventory.BaseTabbedScreen;
import slimeknights.tconstruct.tables.menu.TabbedContainerMenu;
import slimeknights.tconstruct.tables.network.StationTabPacket;

public class TinkerTabsWidget
implements Widget,
GuiEventListener,
NarratableEntry {
    private static final ResourceLocation TAB_IMAGE = TConstruct.getResource("textures/gui/icons.png");
    protected static final ElementScreen TAB_ELEMENT = new ElementScreen(0, 18, 26, 30, 256, 256);
    protected static final ElementScreen ACTIVE_TAB_L_ELEMENT = new ElementScreen(26, 18, 26, 30, 256, 256);
    protected static final ElementScreen ACTIVE_TAB_C_ELEMENT = new ElementScreen(52, 18, 26, 30, 256, 256);
    protected static final ElementScreen ACTIVE_TAB_R_ELEMENT = new ElementScreen(78, 18, 26, 30, 256, 256);
    private final int leftPos;
    private final int topPos;
    private final int imageWidth;
    private final int imageHeight;
    private final TabsWidget tabs;
    private final List<BlockPos> tabData;
    private final BaseTabbedScreen<?, ?> parent;

    public TinkerTabsWidget(BaseTabbedScreen<?, ?> parent) {
        this.parent = parent;
        List<Pair<ItemStack, BlockPos>> tabs = TinkerTabsWidget.collectTabs(this.parent.getMinecraft(), (TabbedContainerMenu)this.parent.getMenu());
        this.tabs = new TabsWidget(parent, TAB_ELEMENT, TAB_ELEMENT, TAB_ELEMENT, ACTIVE_TAB_L_ELEMENT, ACTIVE_TAB_C_ELEMENT, ACTIVE_TAB_R_ELEMENT);
        this.tabs.tabsResource = TAB_IMAGE;
        int count = tabs.size();
        this.imageWidth = count * TinkerTabsWidget.ACTIVE_TAB_C_ELEMENT.w + (count - 1) * this.tabs.spacing;
        this.imageHeight = TinkerTabsWidget.ACTIVE_TAB_C_ELEMENT.h;
        this.leftPos = parent.cornerX + 4;
        this.topPos = parent.cornerY - this.imageHeight;
        this.tabs.setPosition(this.leftPos, this.topPos);
        tabs.stream().map(Pair::getLeft).forEach(arg_0 -> ((TabsWidget)this.tabs).addTab(arg_0));
        this.tabData = tabs.stream().map(Pair::getRight).toList();
        Object blockEntity = this.parent.getTileEntity();
        if (blockEntity != null) {
            this.selectTabForPos(blockEntity.m_58899_());
        }
    }

    private static List<Pair<ItemStack, BlockPos>> collectTabs(Minecraft minecraft, TabbedContainerMenu<?> menu) {
        ArrayList tabs = Lists.newArrayList();
        ClientLevel level = minecraft.f_91073_;
        if (level != null) {
            for (Pair<BlockPos, BlockState> pair : menu.stationBlocks) {
                BlockState state = (BlockState)pair.getRight();
                BlockPos blockPos = (BlockPos)pair.getLeft();
                ItemStack stack = state.m_60734_().getCloneItemStack(state, null, (BlockGetter)level, blockPos, (Player)minecraft.f_91074_);
                tabs.add(Pair.of((Object)stack, (Object)blockPos));
            }
        }
        return tabs;
    }

    private void selectTabForPos(BlockPos pos) {
        for (int i = 0; i < this.tabData.size(); ++i) {
            if (!this.tabData.get(i).equals((Object)pos)) continue;
            this.tabs.selected = i;
            return;
        }
    }

    private void onNewTabSelection(BlockPos pos) {
        BlockState state;
        assert (this.parent.getMinecraft() != null);
        ClientLevel level = this.parent.getMinecraft().f_91073_;
        if (level != null && (state = level.m_8055_(pos)).m_60734_() instanceof ITabbedBlock) {
            TinkerNetwork.getInstance().sendToServer(new StationTabPacket(pos));
            this.parent.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)(this.leftPos - 1) && mouseX < (double)(this.guiRight() + 1) && mouseY >= (double)(this.topPos - 1) && mouseY < (double)(this.guiBottom() + 1);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.tabs.handleMouseClicked((int)mouseX, (int)mouseY, mouseButton);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        this.tabs.handleMouseReleased();
        return true;
    }

    public int guiRight() {
        return this.leftPos + this.imageWidth;
    }

    public int guiBottom() {
        return this.topPos + this.imageHeight;
    }

    public Rect2i getArea() {
        return new Rect2i(this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sel = this.tabs.selected;
        this.tabs.update(mouseX, mouseY);
        this.tabs.draw(poseStack);
        if (sel != this.tabs.selected && 0 <= this.tabs.selected && this.tabs.selected < this.tabData.size()) {
            this.onNewTabSelection(this.tabData.get(this.tabs.selected));
        }
        this.renterTooltip(poseStack, mouseX, mouseY);
    }

    protected void renterTooltip(PoseStack poseStack, int mouseX, int mouseY) {
        ClientLevel world = this.parent.getMinecraft().f_91073_;
        if (this.tabs.highlighted > -1 && world != null) {
            BlockPos pos = this.tabData.get(this.tabs.highlighted);
            BlockEntity te = world.m_7702_(pos);
            Object title = te instanceof MenuProvider ? ((MenuProvider)te).m_5446_() : world.m_8055_(pos).m_60734_().m_49954_();
            this.parent.m_96597_(poseStack, Lists.newArrayList((Object[])new Component[]{title}), mouseX, mouseY);
        }
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput narrationOutput) {
    }
}

