/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.material.IMaterialValue;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tables.block.entity.table.PartBuilderBlockEntity;
import slimeknights.tconstruct.tables.client.inventory.BaseTabbedScreen;
import slimeknights.tconstruct.tables.client.inventory.PartInfoPanelScreen;
import slimeknights.tconstruct.tables.menu.PartBuilderContainerMenu;

public class PartBuilderScreen
extends BaseTabbedScreen<PartBuilderBlockEntity, PartBuilderContainerMenu> {
    private static final Component INFO_TEXT = TConstruct.makeTranslation("gui", "part_builder.info");
    private static final Component TRAIT_TITLE = TConstruct.makeTranslation("gui", "part_builder.trait").m_130940_(ChatFormatting.UNDERLINE);
    private static final MutableComponent UNCRAFTABLE_MATERIAL = TConstruct.makeTranslation("gui", "part_builder.uncraftable").m_130940_(ChatFormatting.RED);
    private static final MutableComponent UNCRAFTABLE_MATERIAL_TOOLTIP = TConstruct.makeTranslation("gui", "part_builder.uncraftable.tooltip");
    private static final ResourceLocation BACKGROUND = TConstruct.getResource("textures/gui/partbuilder.png");
    protected PartInfoPanelScreen infoPanelScreen;
    private float sliderProgress = 0.0f;
    private boolean clickedOnScrollBar;
    private int recipeIndexOffset = 0;

    public PartBuilderScreen(PartBuilderContainerMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.infoPanelScreen = new PartInfoPanelScreen(this, (AbstractContainerMenu)container, playerInventory, title);
        this.infoPanelScreen.setTextScale(0.7777778f);
        this.infoPanelScreen.f_97727_ = this.f_97727_;
        this.addModule(this.infoPanelScreen);
        this.addChestSideInventory(playerInventory);
    }

    protected void m_7286_(PoseStack matrices, float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(matrices, BACKGROUND);
        this.m_93228_(matrices, this.cornerX + 126, this.cornerY + 15 + (int)(41.0f * this.sliderProgress), 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        this.drawRecipesBackground(matrices, mouseX, mouseY, this.cornerX + 51, this.cornerY + 15);
        this.drawIconEmpty(matrices, ((PartBuilderContainerMenu)this.getMenu()).getPatternSlot(), Icons.PATTERN);
        this.drawIconEmpty(matrices, ((PartBuilderContainerMenu)this.getMenu()).getInputSlot(), Icons.INGOT);
        this.drawRecipesItems(matrices, this.cornerX + 51, this.cornerY + 15);
        super.m_7286_(matrices, partialTicks, mouseX, mouseY);
    }

    private int getButtonAt(int mouseX, int mouseY) {
        List<Pattern> buttons = ((PartBuilderBlockEntity)this.tile).getSortedButtons();
        if (!buttons.isEmpty()) {
            int x = this.cornerX + 51;
            int y = this.cornerY + 15;
            int maxIndex = Math.min(this.recipeIndexOffset + 12, buttons.size());
            for (int l = this.recipeIndexOffset; l < maxIndex; ++l) {
                int relative = l - this.recipeIndexOffset;
                double buttonX = (double)mouseX - (double)(x + relative % 4 * 18);
                double buttonY = (double)mouseY - (double)(y + relative / 4 * 18);
                if (!(buttonX >= 0.0) || !(buttonY >= 0.0) || !(buttonX < 18.0) || !(buttonY < 18.0)) continue;
                return l;
            }
        }
        return -1;
    }

    protected void m_7025_(PoseStack matrixStack, int mouseX, int mouseY) {
        int index;
        super.m_7025_(matrixStack, mouseX, mouseY);
        List<Pattern> buttons = ((PartBuilderBlockEntity)this.tile).getSortedButtons();
        if (!buttons.isEmpty() && (index = this.getButtonAt(mouseX, mouseY)) >= 0) {
            this.m_96602_(matrixStack, buttons.get(index).getDisplayName(), mouseX, mouseY);
        }
    }

    private void drawRecipesBackground(PoseStack matrices, int mouseX, int mouseY, int left, int top) {
        int max = Math.min(this.recipeIndexOffset + 12, this.getPartRecipeCount());
        for (int i = this.recipeIndexOffset; i < max; ++i) {
            int relative = i - this.recipeIndexOffset;
            int x = left + relative % 4 * 18;
            int y = top + relative / 4 * 18;
            int u = this.f_97727_;
            if (i == ((PartBuilderBlockEntity)this.tile).getSelectedIndex()) {
                u += 18;
            } else if (mouseX >= x && mouseY >= y && mouseX < x + 18 && mouseY < y + 18) {
                u += 36;
            }
            this.m_93228_(matrices, x, y, 0, u, 18, 18);
        }
    }

    private void drawRecipesItems(PoseStack matrices, int left, int top) {
        assert (this.f_96541_ != null);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Function spriteGetter = this.f_96541_.m_91258_(InventoryMenu.f_39692_);
        List<Pattern> list = ((PartBuilderBlockEntity)this.tile).getSortedButtons();
        int max = Math.min(this.recipeIndexOffset + 12, this.getPartRecipeCount());
        for (int i = this.recipeIndexOffset; i < max; ++i) {
            int relative = i - this.recipeIndexOffset;
            int x = left + relative % 4 * 18 + 1;
            int y = top + relative / 4 * 18 + 1;
            Pattern pattern = list.get(i);
            TextureAtlasSprite sprite = (TextureAtlasSprite)spriteGetter.apply(pattern.getTexture());
            PartBuilderScreen.m_93200_((PoseStack)matrices, (int)x, (int)y, (int)100, (int)16, (int)16, (TextureAtlasSprite)sprite);
        }
    }

    @Override
    public void updateDisplay() {
        if (!this.canScroll()) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
        assert (this.tile != null);
        IMaterialValue materialRecipe = ((PartBuilderBlockEntity)this.tile).getMaterialRecipe();
        if (materialRecipe != null) {
            this.setDisplayForMaterial(materialRecipe);
        } else {
            this.infoPanelScreen.setCaption(this.m_96636_());
            this.infoPanelScreen.setText(INFO_TEXT);
            this.infoPanelScreen.clearMaterialValue();
        }
        IPartBuilderRecipe partRecipe = ((PartBuilderBlockEntity)this.tile).getPartRecipe();
        boolean skipCost = false;
        if (partRecipe == null) {
            partRecipe = ((PartBuilderBlockEntity)this.tile).getFirstRecipe();
            skipCost = true;
        }
        if (partRecipe != null) {
            int cost = partRecipe.getCost();
            if (cost > 0 && !skipCost) {
                this.infoPanelScreen.setPatternCost(cost);
            } else {
                this.infoPanelScreen.clearPatternCost();
            }
            Component title = partRecipe.getTitle();
            if (title != null) {
                this.infoPanelScreen.setCaption(title);
                this.infoPanelScreen.setText(partRecipe.getText(((PartBuilderBlockEntity)this.tile).getInventoryWrapper()));
            }
        } else {
            this.infoPanelScreen.clearPatternCost();
        }
    }

    private void setDisplayForMaterial(IMaterialValue materialRecipe) {
        MaterialVariant materialVariant = materialRecipe.getMaterial();
        this.infoPanelScreen.setCaption(MaterialTooltipCache.getColoredDisplayName(materialVariant.getVariant()));
        float value = materialRecipe.getMaterialValue(((PartBuilderBlockEntity)this.tile).getInventoryWrapper());
        TextComponent formatted = new TextComponent(Util.COMMA_FORMAT.format(value));
        IPartBuilderRecipe partRecipe = ((PartBuilderBlockEntity)this.tile).getPartRecipe();
        if (partRecipe != null && value < (float)partRecipe.getCost()) {
            formatted = formatted.m_130940_(ChatFormatting.DARK_RED);
        }
        this.infoPanelScreen.setMaterialValue((Component)formatted);
        LinkedList stats = Lists.newLinkedList();
        ArrayList tips = Lists.newArrayList();
        if (!materialVariant.get().isCraftable()) {
            stats.add(UNCRAFTABLE_MATERIAL);
            stats.add(TextComponent.f_131282_);
            tips.add(UNCRAFTABLE_MATERIAL_TOOLTIP);
            tips.add(TextComponent.f_131282_);
        }
        MaterialId id = materialVariant.getId();
        for (IMaterialStats stat : MaterialRegistry.getInstance().getAllStats(id)) {
            List<Component> info = stat.getLocalizedInfo();
            if (info.isEmpty()) continue;
            stats.add(stat.getLocalizedName().m_130940_(ChatFormatting.UNDERLINE));
            tips.add(TextComponent.f_131282_);
            stats.addAll(info);
            tips.addAll(stat.getLocalizedDescriptions());
            List<ModifierEntry> traits = MaterialRegistry.getInstance().getTraits(id, stat.getIdentifier());
            if (!traits.isEmpty()) {
                for (ModifierEntry trait : traits) {
                    Modifier mod = trait.getModifier();
                    stats.add(mod.getDisplayName(trait.getLevel()));
                    tips.add(mod.getDescription(trait.getLevel()));
                }
            }
            stats.add(TextComponent.f_131282_);
            tips.add(TextComponent.f_131282_);
        }
        if (!stats.isEmpty() && ((Component)stats.get(stats.size() - 1)).getString().isEmpty()) {
            stats.remove(stats.size() - 1);
            tips.remove(tips.size() - 1);
        }
        this.infoPanelScreen.setText(stats, tips);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.clickedOnScrollBar = false;
        if (this.infoPanelScreen.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        List<Pattern> buttons = ((PartBuilderBlockEntity)this.tile).getSortedButtons();
        if (!buttons.isEmpty()) {
            int index = this.getButtonAt((int)mouseX, (int)mouseY);
            assert (this.f_96541_ != null && this.f_96541_.f_91074_ != null);
            if (index >= 0 && ((PartBuilderContainerMenu)this.getMenu()).m_6366_((Player)this.f_96541_.f_91074_, index)) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                assert (this.f_96541_.f_91072_ != null);
                this.f_96541_.f_91072_.m_105208_(((PartBuilderContainerMenu)this.getMenu()).f_38840_, index);
                return true;
            }
            int x = this.cornerX + 126;
            int y = this.cornerY + 15;
            if (mouseX >= (double)x && mouseX < (double)(x + 12) && mouseY >= (double)y && mouseY < (double)(y + 54)) {
                this.clickedOnScrollBar = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLastClick, double unknown) {
        if (this.infoPanelScreen.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        if (this.clickedOnScrollBar && this.canScroll()) {
            int i = this.cornerY + 14;
            int j = i + 54;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = Mth.m_14036_((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, unknown);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (super.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = Mth.m_14036_((float)((float)((double)this.sliderProgress - delta / (double)i)), (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)(this.sliderProgress * (float)i + 0.5f) * 4;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        if (this.infoPanelScreen.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        return super.m_6348_(mouseX, mouseY, state);
    }

    @Override
    public void error(Component message) {
        this.infoPanelScreen.setCaption(COMPONENT_ERROR);
        this.infoPanelScreen.setText(message);
    }

    @Override
    public void warning(Component message) {
        this.infoPanelScreen.setCaption(COMPONENT_WARNING);
        this.infoPanelScreen.setText(message);
    }

    private int getPartRecipeCount() {
        return ((PartBuilderBlockEntity)this.tile).getSortedButtons().size();
    }

    private boolean canScroll() {
        return this.getPartRecipeCount() > 12;
    }

    private int getHiddenRows() {
        return (this.getPartRecipeCount() + 4 - 1) / 4 - 3;
    }
}

