/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.model.FaucetFluidLoader;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.fluid.FluidsModel;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.mantle.client.render.MantleRenderTypes;
import slimeknights.mantle.client.render.RenderingHelper;
import slimeknights.tconstruct.smeltery.block.FaucetBlock;
import slimeknights.tconstruct.smeltery.block.entity.FaucetBlockEntity;

public class FaucetBlockEntityRenderer
implements BlockEntityRenderer<FaucetBlockEntity> {
    public FaucetBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FaucetBlockEntity tileEntity, float partialTicks, PoseStack matrices, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        FluidStack renderFluid = tileEntity.getRenderFluid();
        if (!tileEntity.isPouring() || renderFluid.isEmpty()) {
            return;
        }
        Level world = tileEntity.m_58904_();
        if (world == null) {
            return;
        }
        BlockState state = tileEntity.m_58900_();
        FluidsModel.Baked model = (FluidsModel.Baked)ModelHelper.getBakedModel((BlockState)state, FluidsModel.Baked.class);
        if (model != null) {
            Direction direction = (Direction)state.m_61143_((Property)FaucetBlock.FACING);
            boolean isRotated = RenderingHelper.applyRotation((PoseStack)matrices, (Direction)direction);
            FluidAttributes attributes = renderFluid.getFluid().getAttributes();
            int color = attributes.getColor(renderFluid);
            Function spriteGetter = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
            TextureAtlasSprite still = (TextureAtlasSprite)spriteGetter.apply(attributes.getStillTexture(renderFluid));
            TextureAtlasSprite flowing = (TextureAtlasSprite)spriteGetter.apply(attributes.getFlowingTexture(renderFluid));
            boolean isGas = attributes.isGaseous(renderFluid);
            combinedLightIn = FluidRenderer.withBlockLight((int)combinedLightIn, (int)attributes.getLuminosity(renderFluid));
            VertexConsumer buffer = bufferIn.m_6299_(MantleRenderTypes.FLUID);
            for (FluidCuboid cube : model.getFluids()) {
                FluidRenderer.renderCuboid((PoseStack)matrices, (VertexConsumer)buffer, (FluidCuboid)cube, (float)0.0f, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (int)color, (int)combinedLightIn, (boolean)isGas);
            }
            FaucetFluidLoader.renderFaucetFluids((LevelAccessor)world, (BlockPos)tileEntity.m_58899_(), (Direction)direction, (PoseStack)matrices, (VertexConsumer)buffer, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (int)color, (int)combinedLightIn);
            if (isRotated) {
                matrices.m_85849_();
            }
        }
    }
}

