/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.tank;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.tconstruct.smeltery.block.entity.CastingBlockEntity;

public class CastingFluidHandler
implements IFluidHandler {
    private final CastingBlockEntity tile;
    private FluidStack fluid = FluidStack.EMPTY;
    private int capacity = 0;
    private Fluid filter = Fluids.f_76191_;
    private static final String TAG_FLUID = "fluid";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_CAPACITY = "capacity";

    public boolean isFluidValid(FluidStack stack) {
        return !stack.isEmpty() && (this.filter == Fluids.f_76191_ || stack.getFluid() == this.filter);
    }

    public boolean isEmpty() {
        return this.fluid.isEmpty();
    }

    public int getCapacity() {
        if (this.capacity == 0) {
            return this.fluid.getAmount();
        }
        return this.capacity;
    }

    public void reset() {
        this.capacity = 0;
        this.fluid = FluidStack.EMPTY;
        this.filter = Fluids.f_76191_;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        int capacity = this.capacity;
        if (this.filter == null || this.capacity == 0) {
            Fluid fluid = resource.getFluid();
            capacity = this.tile.initNewCasting(resource, action);
            if (capacity <= 0) {
                return 0;
            }
            if (action.execute()) {
                this.capacity = capacity;
                this.filter = fluid;
            }
        }
        if (this.fluid.isEmpty()) {
            int amount = Math.min(capacity, resource.getAmount());
            if (action.execute()) {
                this.fluid = new FluidStack(resource, amount);
                this.tile.onContentsChanged();
            }
            return amount;
        }
        if (!resource.isFluidEqual(this.fluid)) {
            return 0;
        }
        int space = capacity - this.fluid.getAmount();
        if (space <= 0) {
            return 0;
        }
        int amount = resource.getAmount();
        if (amount < space) {
            if (action.execute()) {
                this.fluid.grow(amount);
                this.tile.onContentsChanged();
            }
            return amount;
        }
        if (action.execute()) {
            this.fluid.setAmount(capacity);
            this.tile.onContentsChanged();
        }
        return space;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = Math.min(this.fluid.getAmount(), maxDrain);
        if (drained <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (action.execute()) {
            this.fluid.shrink(drained);
            if (this.fluid.isEmpty()) {
                this.tile.reset();
            } else {
                this.tile.onContentsChanged();
            }
        }
        return stack;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank == 0) {
            return this.fluid;
        }
        return FluidStack.EMPTY;
    }

    public int getTanks() {
        return 1;
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return tank == 0 && this.isFluidValid(stack);
    }

    public void readFromTag(CompoundTag nbt) {
        Fluid fluid;
        this.capacity = nbt.m_128451_(TAG_CAPACITY);
        if (nbt.m_128425_(TAG_FLUID, 10)) {
            this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_(TAG_FLUID)));
        }
        if (nbt.m_128425_(TAG_FILTER, 8) && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.m_128461_(TAG_FILTER)))) != null) {
            this.filter = fluid;
        }
    }

    public CompoundTag writeToTag(CompoundTag nbt) {
        nbt.m_128405_(TAG_CAPACITY, this.capacity);
        if (!this.fluid.isEmpty()) {
            nbt.m_128365_(TAG_FLUID, (Tag)this.fluid.writeToNBT(new CompoundTag()));
        }
        if (this.filter != Fluids.f_76191_) {
            nbt.m_128359_(TAG_FILTER, Objects.requireNonNull(this.filter.getRegistryName()).toString());
        }
        return nbt;
    }

    public CastingFluidHandler(CastingBlockEntity tile) {
        this.tile = tile;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }
}

