/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.controller;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.block.entity.NameableBlockEntity;
import slimeknights.mantle.client.model.data.SinglePropertyData;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.common.multiblock.IMasterLogic;
import slimeknights.tconstruct.common.multiblock.IServantLogic;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.controller.SmelteryControllerBlock;
import slimeknights.tconstruct.smeltery.block.entity.module.EntityMeltingModule;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.HeatingStructureMultiblock;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.MultiblockResult;
import slimeknights.tconstruct.smeltery.block.entity.tank.IDisplayFluidListener;
import slimeknights.tconstruct.smeltery.block.entity.tank.ISmelteryTankHandler;
import slimeknights.tconstruct.smeltery.block.entity.tank.SmelteryTank;
import slimeknights.tconstruct.smeltery.menu.HeatingStructureContainerMenu;
import slimeknights.tconstruct.smeltery.network.StructureErrorPositionPacket;
import slimeknights.tconstruct.smeltery.network.StructureUpdatePacket;

public abstract class HeatingStructureBlockEntity
extends NameableBlockEntity
implements IMasterLogic,
ISmelteryTankHandler {
    private static final String TAG_STRUCTURE = "structure";
    private static final String TAG_TANK = "tank";
    private static final String TAG_INVENTORY = "inventory";
    private static final String TAG_ERROR_POS = "errorPos";
    public static final BlockEntityTicker<HeatingStructureBlockEntity> SERVER_TICKER = (level, pos, state, self) -> self.serverTick(level, pos, state);
    public static final BlockEntityTicker<HeatingStructureBlockEntity> CLIENT_TICKER = (level, pos, state, self) -> self.clientTick(level, pos, state);
    private final HeatingStructureMultiblock<?> multiblock = this.createMultiblock();
    @Nullable
    private BlockPos errorPos;
    private int errorVisibleFor = 0;
    private boolean addedDrainListeners = false;
    @Nullable
    protected HeatingStructureMultiblock.StructureData structure;
    protected final SmelteryTank<HeatingStructureBlockEntity> tank = new SmelteryTank<HeatingStructureBlockEntity>(this);
    private LazyOptional<IFluidHandler> fluidCapability = LazyOptional.empty();
    protected final MeltingModuleInventory meltingInventory = this.createMeltingInventory();
    private final LazyOptional<IItemHandler> itemCapability = LazyOptional.of(() -> this.meltingInventory);
    protected final FuelModule fuelModule = new FuelModule((MantleBlockEntity)this, () -> this.structure != null ? this.structure.getTanks() : Collections.emptyList());
    protected int fuelRate = 1;
    protected final EntityMeltingModule entityModule = new EntityMeltingModule((MantleBlockEntity)this, this.tank, this::canMeltEntities, this::insertIntoInventory, () -> this.structure == null ? null : this.structure.getBounds());
    protected int tick = 0;
    private int expandCounter = 0;
    private boolean structureUpdateQueued = false;
    private boolean fluidUpdateQueued = false;
    private AABB defaultBounds;
    private final IModelData modelData = new SinglePropertyData(IDisplayFluidListener.PROPERTY);
    private final List<WeakReference<IDisplayFluidListener>> fluidDisplayListeners = new ArrayList<WeakReference<IDisplayFluidListener>>();
    protected final Consumer<ItemStack> dropItem = this::dropItem;

    protected HeatingStructureBlockEntity(BlockEntityType<? extends HeatingStructureBlockEntity> type, BlockPos pos, BlockState state, Component name) {
        super(type, pos, state, name);
    }

    protected abstract HeatingStructureMultiblock<?> createMultiblock();

    protected abstract MeltingModuleInventory createMeltingInventory();

    protected abstract void heat();

    private void updateErrorPos() {
        BlockPos oldErrorPos = this.errorPos;
        this.errorPos = this.multiblock.getLastResult().getPos();
        if (!Objects.equals(oldErrorPos, this.errorPos)) {
            TinkerNetwork.getInstance().sendToClientsAround(new StructureErrorPositionPacket(this.f_58858_, this.errorPos), (LevelAccessor)this.f_58857_, this.f_58858_);
        }
    }

    protected void clientTick(Level level, BlockPos pos, BlockState state) {
        if (this.errorVisibleFor > 0) {
            --this.errorVisibleFor;
        }
        if (!this.addedDrainListeners) {
            this.addedDrainListeners = true;
            if (this.structure != null) {
                FluidStack fluid;
                this.structure.forEachContained(sPos -> {
                    BlockEntity patt7961$temp = level.m_7702_((BlockPos)sPos);
                    if (patt7961$temp instanceof IDisplayFluidListener) {
                        IDisplayFluidListener listener = (IDisplayFluidListener)patt7961$temp;
                        this.fluidDisplayListeners.add(new WeakReference<IDisplayFluidListener>(listener));
                    }
                });
                if (!this.fluidDisplayListeners.isEmpty() && !(fluid = IDisplayFluidListener.normalizeFluid(this.tank.getFluidInTank(0))).isEmpty()) {
                    this.updateListeners(fluid);
                }
            }
        }
    }

    protected void serverTick(Level level, BlockPos pos, BlockState state) {
        if (level.f_46443_) {
            if (this.errorVisibleFor > 0) {
                --this.errorVisibleFor;
            }
            return;
        }
        if (!state.m_61138_((Property)ControllerBlock.IN_STRUCTURE)) {
            return;
        }
        if (this.structureUpdateQueued) {
            this.checkStructure();
            this.structureUpdateQueued = false;
        }
        if (this.structure != null && ((Boolean)state.m_61143_((Property)SmelteryControllerBlock.IN_STRUCTURE)).booleanValue()) {
            if (this.tick == 0) {
                ++this.expandCounter;
                if (this.expandCounter >= 10 && this.structure.getInnerY() < this.multiblock.getMaxHeight()) {
                    this.expandCounter = 0;
                    if (this.multiblock.canExpand(this.structure, level)) {
                        this.updateStructure();
                    } else {
                        this.updateErrorPos();
                    }
                }
            } else if (this.tick % 4 == 0 && !this.multiblock.isInnerBlock(level, this.structure.getNextInsideCheck())) {
                this.updateStructure();
            }
            this.heat();
            if (this.tick % 4 == 3 && this.fluidUpdateQueued) {
                this.fluidUpdateQueued = false;
                this.tank.syncFluids();
            }
        } else if (this.tick == 0) {
            this.updateStructure();
        }
        this.tick = (this.tick + 1) % 20;
    }

    protected void dropItem(ItemStack stack) {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_ && !stack.m_41619_()) {
            double x = (double)(this.f_58857_.f_46441_.nextFloat() * 0.5f) + 0.25;
            double y = (double)(this.f_58857_.f_46441_.nextFloat() * 0.5f) + 0.25;
            double z = (double)(this.f_58857_.f_46441_.nextFloat() * 0.5f) + 0.25;
            BlockPos pos = this.f_58858_.m_142300_((Direction)this.m_58900_().m_61143_((Property)ControllerBlock.FACING));
            ItemEntity itementity = new ItemEntity(this.f_58857_, (double)pos.m_123341_() + x, (double)pos.m_123342_() + y, (double)pos.m_123343_() + z, stack);
            itementity.m_32060_();
            this.f_58857_.m_7967_((Entity)itementity);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCapability.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void updateStructure() {
        this.structureUpdateQueued = true;
    }

    protected void setStructure(@Nullable HeatingStructureMultiblock.StructureData structure) {
        this.structure = structure;
    }

    protected void checkStructure() {
        boolean formed;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        boolean wasFormed = (Boolean)this.m_58900_().m_61143_((Property)ControllerBlock.IN_STRUCTURE);
        HeatingStructureMultiblock.StructureData oldStructure = this.structure;
        HeatingStructureMultiblock.StructureData newStructure = this.multiblock.detectMultiblock(this.f_58857_, this.f_58858_, (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_));
        boolean bl = formed = newStructure != null;
        if (formed != wasFormed) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ControllerBlock.IN_STRUCTURE, (Comparable)Boolean.valueOf(formed)));
        }
        if (formed) {
            TinkerNetwork.getInstance().sendToClientsAround(new StructureUpdatePacket(this.f_58858_, newStructure.getMinPos(), newStructure.getMaxPos(), newStructure.getTanks()), (LevelAccessor)this.f_58857_, this.f_58858_);
            if (!this.fluidCapability.isPresent()) {
                this.fluidCapability = LazyOptional.of(() -> this.tank);
            }
            newStructure.assignMaster(this, oldStructure);
            this.setStructure(newStructure);
        } else {
            if (this.fluidCapability.isPresent()) {
                this.fluidCapability.invalidate();
                this.fluidCapability = LazyOptional.empty();
            }
            if (oldStructure != null) {
                oldStructure.clearMaster(this);
            }
            this.setStructure(null);
        }
        this.updateErrorPos();
        this.expandCounter = 0;
    }

    public void invalidateStructure() {
        if (this.structure != null) {
            this.structure.clearMaster(this);
            this.structure = null;
            this.errorPos = null;
        }
    }

    @Override
    public void notifyChange(IServantLogic servant, BlockPos pos, BlockState state) {
        if (this.structure == null) {
            return;
        }
        assert (this.f_58857_ != null);
        if (this.multiblock.shouldUpdate(this.f_58857_, this.structure, pos, state)) {
            this.updateStructure();
        }
    }

    public MultiblockResult getStructureResult() {
        return this.multiblock.getLastResult();
    }

    @Override
    public void updateFluidsFromPacket(List<FluidStack> fluids) {
        this.tank.setFluids(fluids);
    }

    private void updateListeners(FluidStack fluid) {
        Iterator<WeakReference<IDisplayFluidListener>> iterator = this.fluidDisplayListeners.iterator();
        while (iterator.hasNext()) {
            IDisplayFluidListener listener = (IDisplayFluidListener)iterator.next().get();
            if (listener == null) {
                iterator.remove();
                continue;
            }
            listener.notifyDisplayFluidUpdated(fluid);
        }
    }

    private void updateDisplayFluid(FluidStack fluid) {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            fluid = IDisplayFluidListener.normalizeFluid(fluid);
            this.modelData.setData(IDisplayFluidListener.PROPERTY, (Object)fluid);
            this.requestModelDataUpdate();
            BlockState state = this.m_58900_();
            this.f_58857_.m_7260_(this.f_58858_, state, state, 48);
            this.updateListeners(fluid);
        }
    }

    @Override
    public void addDisplayListener(IDisplayFluidListener listener) {
        boolean have = false;
        for (WeakReference<IDisplayFluidListener> existing : this.fluidDisplayListeners) {
            if (existing.get() != listener) continue;
            have = true;
            break;
        }
        if (!have) {
            this.fluidDisplayListeners.add(new WeakReference<IDisplayFluidListener>(listener));
        }
        listener.notifyDisplayFluidUpdated(IDisplayFluidListener.normalizeFluid(this.tank.getFluidInTank(0)));
    }

    @Override
    public void notifyFluidsChanged(ISmelteryTankHandler.FluidChange type, FluidStack fluid) {
        if (type == ISmelteryTankHandler.FluidChange.ORDER_CHANGED) {
            this.updateDisplayFluid(fluid);
        } else {
            this.fluidUpdateQueued = true;
            this.setChangedFast();
        }
    }

    public AABB getRenderBoundingBox() {
        if (this.structure != null) {
            return this.structure.getBounds();
        }
        if (this.defaultBounds == null) {
            this.defaultBounds = new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 1, 1));
        }
        return this.defaultBounds;
    }

    private boolean canMeltEntities() {
        if (this.fuelModule.hasFuel()) {
            return true;
        }
        return this.fuelModule.findFuel(false) > 0;
    }

    private ItemStack insertIntoInventory(ItemStack stack) {
        return ItemHandlerHelper.insertItem((IItemHandler)this.meltingInventory, (ItemStack)stack, (boolean)false);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new HeatingStructureContainerMenu(id, inv, this);
    }

    public void setStructureSize(BlockPos minPos, BlockPos maxPos, List<BlockPos> tanks) {
        this.setStructure(this.multiblock.createClient(minPos, maxPos, tanks));
        this.fuelModule.clearCachedDisplayListeners();
        if (this.structure == null) {
            this.fluidDisplayListeners.clear();
        } else {
            this.fluidDisplayListeners.removeIf(reference -> {
                IDisplayFluidListener listener = (IDisplayFluidListener)reference.get();
                return listener == null || !this.structure.contains(listener.getListenerPos());
            });
        }
    }

    public void setErrorPos(@Nullable BlockPos errorPos) {
        this.errorPos = errorPos;
        if (errorPos != null && this.f_58857_ != null) {
            this.errorVisibleFor = 200;
        }
    }

    public boolean isHighlightError() {
        return this.errorVisibleFor > 0;
    }

    protected abstract boolean isDebugItem(ItemStack var1);

    public boolean showDebugBlockBorder(Player player) {
        return this.isDebugItem(player.m_21205_()) || this.isDebugItem(player.m_21206_()) || this.isDebugItem(player.m_6844_(EquipmentSlot.HEAD));
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_(TAG_TANK, 10)) {
            this.tank.read(nbt.m_128469_(TAG_TANK));
            FluidStack first = this.tank.getFluidInTank(0);
            if (!first.isEmpty()) {
                this.updateDisplayFluid(first);
            }
        }
        if (nbt.m_128425_(TAG_INVENTORY, 10)) {
            this.meltingInventory.readFromTag(nbt.m_128469_(TAG_INVENTORY));
        }
        if (nbt.m_128425_(TAG_STRUCTURE, 10)) {
            this.setStructure(this.multiblock.readFromTag(nbt.m_128469_(TAG_STRUCTURE)));
            if (this.structure != null) {
                this.fluidCapability = LazyOptional.of(() -> this.tank);
            }
        }
        if (nbt.m_128425_(TAG_ERROR_POS, 10)) {
            this.errorPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_(TAG_ERROR_POS));
        }
        this.fuelModule.readFromTag(nbt);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.structure != null) {
            compound.m_128365_(TAG_STRUCTURE, (Tag)this.structure.writeToTag());
        }
        this.fuelModule.writeToTag(compound);
    }

    public void saveSynced(CompoundTag compound) {
        super.saveSynced(compound);
        compound.m_128365_(TAG_TANK, (Tag)this.tank.write(new CompoundTag()));
        compound.m_128365_(TAG_INVENTORY, (Tag)this.meltingInventory.writeToTag());
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.structure != null) {
            nbt.m_128365_(TAG_STRUCTURE, (Tag)this.structure.writeClientTag());
        }
        if (this.errorPos != null) {
            nbt.m_128365_(TAG_ERROR_POS, (Tag)NbtUtils.m_129224_((BlockPos)this.errorPos));
        }
        return nbt;
    }

    @Nullable
    public static <HAVE extends HeatingStructureBlockEntity, RET extends BlockEntity> BlockEntityTicker<RET> getTicker(Level level, BlockEntityType<RET> expected, BlockEntityType<HAVE> have) {
        return BlockEntityHelper.castTicker(expected, have, level.f_46443_ ? CLIENT_TICKER : SERVER_TICKER);
    }

    @Nullable
    public BlockPos getErrorPos() {
        return this.errorPos;
    }

    @Nullable
    public HeatingStructureMultiblock.StructureData getStructure() {
        return this.structure;
    }

    public SmelteryTank<HeatingStructureBlockEntity> getTank() {
        return this.tank;
    }

    @Override
    public LazyOptional<IFluidHandler> getFluidCapability() {
        return this.fluidCapability;
    }

    public MeltingModuleInventory getMeltingInventory() {
        return this.meltingInventory;
    }

    public FuelModule getFuelModule() {
        return this.fuelModule;
    }

    public IModelData getModelData() {
        return this.modelData;
    }
}

