/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.DistExecutor;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.block.TankModel;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.library.fluid.IFluidTankUpdater;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;

public interface ITankBlockEntity
extends IFluidTankUpdater,
FluidUpdatePacket.IFluidPacketReceiver {
    public FluidTankAnimated getTank();

    default public int comparatorStrength() {
        FluidTankAnimated tank = this.getTank();
        return 15 * tank.getFluidAmount() / tank.getCapacity();
    }

    public int getLastStrength();

    public void setLastStrength(int var1);

    @Override
    default public void onTankContentsChanged() {
        int newStrength = this.comparatorStrength();
        BlockEntity te = this.getTE();
        Level world = te.m_58904_();
        if (newStrength != this.getLastStrength() && world != null) {
            world.m_46672_(te.m_58899_(), te.m_58900_().m_60734_());
            this.setLastStrength(newStrength);
        }
    }

    default public boolean isFluidInModel() {
        return (Boolean)Config.CLIENT.tankFluidModel.get();
    }

    @Override
    default public void updateFluidTo(FluidStack fluid) {
        FluidTankAnimated tank = this.getTank();
        int oldAmount = tank.getFluidAmount();
        int newAmount = fluid.getAmount();
        tank.setFluid(fluid);
        tank.setRenderOffset(tank.getRenderOffset() + (float)newAmount - (float)oldAmount);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            BlockEntity te;
            TankModel.Baked model;
            if (this.isFluidInModel() && (model = (TankModel.Baked)ModelHelper.getBakedModel((BlockState)(te = this.getTE()).m_58900_(), TankModel.Baked.class)) != null && (Math.abs(newAmount - oldAmount) >= tank.getCapacity() / model.getFluid().getIncrements() || oldAmount == 0 != (newAmount == 0))) {
                Minecraft.m_91087_().f_91060_.m_109544_(null, te.m_58899_(), null, null, 3);
            }
        });
    }

    default public BlockEntity getTE() {
        return (BlockEntity)this;
    }

    public static int getComparatorInputOverride(LevelAccessor world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof ITankBlockEntity)) {
            return 0;
        }
        return ((ITankBlockEntity)te).comparatorStrength();
    }
}

