/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.math.Vector3f;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.FaucetBlockEntity;

public class FaucetBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61373_;
    private static final EnumMap<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.DOWN, (Object)Shapes.m_83113_((VoxelShape)FaucetBlock.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape)FaucetBlock.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (BooleanOp)BooleanOp.f_82685_), (Object)Direction.NORTH, (Object)Shapes.m_83113_((VoxelShape)FaucetBlock.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)10.0, (double)16.0), (VoxelShape)FaucetBlock.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0), (BooleanOp)BooleanOp.f_82685_), (Object)Direction.SOUTH, (Object)Shapes.m_83113_((VoxelShape)FaucetBlock.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)10.0, (double)6.0), (VoxelShape)FaucetBlock.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0), (BooleanOp)BooleanOp.f_82685_), (Object)Direction.WEST, (Object)Shapes.m_83113_((VoxelShape)FaucetBlock.m_49796_((double)10.0, (double)4.0, (double)4.0, (double)16.0, (double)10.0, (double)12.0), (VoxelShape)FaucetBlock.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), (BooleanOp)BooleanOp.f_82685_), (Object)Direction.EAST, (Object)Shapes.m_83113_((VoxelShape)FaucetBlock.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)6.0, (double)10.0, (double)12.0), (VoxelShape)FaucetBlock.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), (BooleanOp)BooleanOp.f_82685_)));
    private static final Vector3f RED = new Vector3f(1.0f, 0.0f, 0.0f);

    public FaucetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction dir = context.m_43719_();
        if (dir == Direction.UP) {
            dir = Direction.DOWN;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir);
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new FaucetBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> type) {
        return BlockEntityHelper.serverTicker((Level)pLevel, type, (BlockEntityType)((BlockEntityType)TinkerSmeltery.faucet.get()), FaucetBlockEntity.SERVER_TICKER);
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        this.getFaucet(worldIn, pos).ifPresent(FaucetBlockEntity::activate);
        return InteractionResult.SUCCESS;
    }

    @Deprecated
    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.m_5776_()) {
            return;
        }
        this.getFaucet(worldIn, pos).ifPresent(faucet -> {
            faucet.neighborChanged(fromPos);
            faucet.handleRedstone(worldIn.m_46753_(pos));
        });
    }

    @Deprecated
    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        this.getFaucet((Level)worldIn, pos).ifPresent(FaucetBlockEntity::activate);
    }

    private Optional<FaucetBlockEntity> getFaucet(Level world, BlockPos pos) {
        return BlockEntityHelper.get(FaucetBlockEntity.class, (BlockGetter)world, (BlockPos)pos);
    }

    private static void addParticles(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        double x = (double)pos.m_123341_() + 0.5 - 0.3 * (double)direction.m_122429_();
        double y = (double)pos.m_123342_() + 0.5 - 0.3 * (double)direction.m_122430_();
        double z = (double)pos.m_123343_() + 0.5 - 0.3 * (double)direction.m_122431_();
        worldIn.m_7106_((ParticleOptions)new DustParticleOptions(RED, 0.5f), x, y, z, 0.0, 0.0, 0.0);
    }

    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        this.getFaucet(worldIn, pos).ifPresent(faucet -> {
            if (faucet.isPouring() && faucet.getRenderFluid().isEmpty() && rand.nextFloat() < 0.25f) {
                FaucetBlock.addParticles(stateIn, (LevelAccessor)worldIn, pos);
            }
        });
    }
}

