/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.layout;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;

public abstract class LayoutIcon {
    public static final Serializer SERIALIZER = new Serializer();
    public static final LayoutIcon EMPTY = new LayoutIcon(){

        @Override
        @Nullable
        public <T> T getValue(Class<T> clazz) {
            return null;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)Type.EMPTY);
        }

        @Override
        public JsonObject toJson() {
            return new JsonObject();
        }
    };

    public static LayoutIcon ofItem(ItemStack stack) {
        return new ItemStackIcon(stack);
    }

    public static LayoutIcon ofPattern(Pattern pattern) {
        return new PatternIcon(pattern);
    }

    @Nullable
    public abstract <T> T getValue(Class<T> var1);

    public static LayoutIcon read(FriendlyByteBuf buffer) {
        Type type = (Type)buffer.m_130066_(Type.class);
        switch (type) {
            case EMPTY: {
                return EMPTY;
            }
            case ITEM: {
                ItemStack stack = buffer.m_130267_();
                return new ItemStackIcon(stack);
            }
            case PATTERN: {
                Pattern pattern = new Pattern(buffer.m_130281_());
                return new PatternIcon(pattern);
            }
        }
        throw new DecoderException("Invalid LayoutButtonIcon " + type);
    }

    public abstract void write(FriendlyByteBuf var1);

    public abstract JsonObject toJson();

    @VisibleForTesting
    protected static class ItemStackIcon
    extends LayoutIcon {
        private final ItemStack stack;

        @Override
        public <T> T getValue(Class<T> clazz) {
            if (clazz == ItemStack.class) {
                return (T)this.stack;
            }
            return null;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)Type.ITEM);
            buffer.m_130055_(this.stack);
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("item", Objects.requireNonNull(this.stack.m_41720_().getRegistryName()).toString());
            CompoundTag tag = this.stack.m_41783_();
            if (tag != null) {
                json.addProperty("nbt", tag.toString());
            }
            return json;
        }

        public ItemStackIcon(ItemStack stack) {
            this.stack = stack;
        }
    }

    @VisibleForTesting
    protected static class PatternIcon
    extends LayoutIcon {
        private final Pattern pattern;

        @Override
        public <T> T getValue(Class<T> clazz) {
            if (clazz == Pattern.class) {
                return (T)((Object)this.pattern);
            }
            return null;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)Type.PATTERN);
            buffer.m_130085_((ResourceLocation)this.pattern);
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("pattern", this.pattern.toString());
            return json;
        }

        public PatternIcon(Pattern pattern) {
            this.pattern = pattern;
        }
    }

    private static enum Type {
        EMPTY,
        ITEM,
        PATTERN;

    }

    protected static class Serializer
    implements JsonSerializer<LayoutIcon>,
    JsonDeserializer<LayoutIcon> {
        protected Serializer() {
        }

        public LayoutIcon deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = GsonHelper.m_13918_((JsonElement)json, (String)"button_icon");
            if (object.has("pattern")) {
                Pattern pattern = new Pattern(JsonHelper.getResourceLocation((JsonObject)object, (String)"pattern"));
                return new PatternIcon(pattern);
            }
            if (object.has("item")) {
                ItemStack stack = CraftingHelper.getItemStack((JsonObject)object, (boolean)true);
                return new ItemStackIcon(stack);
            }
            if (object.entrySet().isEmpty()) {
                return EMPTY;
            }
            throw new JsonSyntaxException("LayoutButtonIcon must have either pattern or item");
        }

        public JsonElement serialize(LayoutIcon icon, java.lang.reflect.Type typeOfSrc, JsonSerializationContext context) {
            return icon.toJson();
        }
    }
}

