/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.harvest;

import com.google.gson.JsonObject;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.tools.definition.harvest.IHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class TagHarvestLogic
implements IHarvestLogic {
    public static final Loader LOADER = new Loader();
    protected final TagKey<Block> tag;

    @Override
    public boolean isEffective(IToolStackView tool, BlockState state) {
        return state.m_204336_(this.tag) && TierSortingRegistry.isCorrectTierForDrops((Tier)tool.getStats().get(ToolStats.HARVEST_TIER), (BlockState)state);
    }

    @Override
    public float getDestroySpeed(IToolStackView tool, BlockState state) {
        return state.m_204336_(this.tag) ? tool.getStats().get(ToolStats.MINING_SPEED).floatValue() : 1.0f;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends IHarvestLogic> getLoader() {
        return LOADER;
    }

    public TagHarvestLogic(TagKey<Block> tag) {
        this.tag = tag;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<TagHarvestLogic> {
        private Loader() {
        }

        public TagHarvestLogic deserialize(JsonObject json) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)JsonHelper.getResourceLocation((JsonObject)json, (String)"effective"));
            return new TagHarvestLogic((TagKey<Block>)tag);
        }

        public TagHarvestLogic fromNetwork(FriendlyByteBuf buffer) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)buffer.m_130281_());
            return new TagHarvestLogic((TagKey<Block>)tag);
        }

        public void serialize(TagHarvestLogic object, JsonObject json) {
            json.addProperty("effective", object.tag.f_203868_().toString());
        }

        public void toNetwork(TagHarvestLogic object, FriendlyByteBuf buffer) {
            buffer.m_130085_(object.tag.f_203868_());
        }
    }
}

