/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.utils.JsonUtils;

public final class SlotType {
    private static final String KEY_PREFIX = TConstruct.makeTranslationKey("stat", "slot.prefix.");
    private static final String KEY_DISPLAY = TConstruct.makeTranslationKey("stat", "slot.display.");
    private static final Map<String, SlotType> SLOT_TYPES = new HashMap<String, SlotType>();
    private static final List<SlotType> ALL_SLOTS = new ArrayList<SlotType>();
    private static final Pattern VALIDATOR = Pattern.compile("^[a-z0-9_]*$");
    public static final SlotType UPGRADE = SlotType.create("upgrades", -3360185);
    public static final SlotType DEFENSE = SlotType.create("defense", -5701728);
    public static final SlotType ABILITY = SlotType.create("abilities", -4677377);
    public static final SlotType SOUL = SlotType.create("souls", -1);
    private final String name;
    private final TextColor color;
    private Component displayName = null;

    public static void init() {
    }

    public static boolean isValidName(String name) {
        return VALIDATOR.matcher(name).matches();
    }

    public static SlotType create(String name, int color) {
        if (SLOT_TYPES.containsKey(name)) {
            return SLOT_TYPES.get(name);
        }
        if (!SlotType.isValidName(name)) {
            throw new IllegalArgumentException("Non [a-z0-9_] character in slot name: " + name);
        }
        SlotType type = new SlotType(name, TextColor.m_131266_((int)color));
        SLOT_TYPES.put(name, type);
        ALL_SLOTS.add(type);
        return type;
    }

    public static SlotType getOrCreate(String name) {
        return SlotType.create(name, -1);
    }

    @Nullable
    public static SlotType getIfPresent(String name) {
        return SLOT_TYPES.get(name);
    }

    public static SlotType read(FriendlyByteBuf buffer) {
        return SlotType.getOrCreate(buffer.m_130277_());
    }

    public static Collection<SlotType> getAllSlotTypes() {
        return ALL_SLOTS;
    }

    public String getPrefix() {
        return KEY_PREFIX + this.name;
    }

    public Component getDisplayName() {
        if (this.displayName == null) {
            this.displayName = new TranslatableComponent(KEY_DISPLAY + this.name);
        }
        return this.displayName;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.name);
    }

    public String toString() {
        return "SlotType{" + this.name + "}";
    }

    private SlotType(String name, TextColor color) {
        this.name = name;
        this.color = color;
    }

    public String getName() {
        return this.name;
    }

    public TextColor getColor() {
        return this.color;
    }

    public static class SlotCount {
        private final SlotType type;
        private final int count;

        public static SlotCount fromJson(JsonObject json) {
            if (json.entrySet().size() != 1) {
                throw new JsonSyntaxException("Cannot set multiple slot types");
            }
            Map.Entry entry = (Map.Entry)json.entrySet().iterator().next();
            String typeString = (String)entry.getKey();
            if (!SlotType.isValidName(typeString)) {
                throw new JsonSyntaxException("Invalid slot type name '" + typeString + "'");
            }
            SlotType slotType = SlotType.getOrCreate(typeString);
            int slots = JsonUtils.getIntMin((JsonElement)entry.getValue(), "count", 1);
            return new SlotCount(slotType, slots);
        }

        @Nullable
        public static SlotCount read(FriendlyByteBuf buffer) {
            int count = buffer.m_130242_();
            if (count > 0) {
                SlotType type = SlotType.read(buffer);
                return new SlotCount(type, count);
            }
            return null;
        }

        public static int get(@Nullable SlotCount slots, SlotType type) {
            if (slots != null && slots.getType() == type) {
                return slots.getCount();
            }
            return 0;
        }

        public static void write(@Nullable SlotCount slots, FriendlyByteBuf buffer) {
            if (slots == null) {
                buffer.m_130130_(0);
            } else {
                buffer.m_130130_(slots.getCount());
                slots.getType().write(buffer);
            }
        }

        public String toString() {
            return "SlotCount{" + this.type.name + ": " + this.count + "}";
        }

        public SlotCount(SlotType type, int count) {
            this.type = type;
            this.count = count;
        }

        public SlotType getType() {
            return this.type;
        }

        public int getCount() {
            return this.count;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SlotCount)) {
                return false;
            }
            SlotCount other = (SlotCount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            SlotType this$type = this.getType();
            SlotType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SlotCount;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCount();
            SlotType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }
}

