/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;

public class MaterialRecipeSerializer
extends LoggingRecipeSerializer<MaterialRecipe> {
    private static final ItemOutput EMPTY = ItemOutput.fromStack((ItemStack)ItemStack.f_41583_);

    public MaterialRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
        int value = GsonHelper.m_13824_((JsonObject)json, (String)"value", (int)1);
        int needed = GsonHelper.m_13824_((JsonObject)json, (String)"needed", (int)1);
        MaterialVariantId materialId = MaterialVariantId.fromJson(json, "material");
        ItemOutput leftover = EMPTY;
        if (value > 1 && json.has("leftover")) {
            leftover = ItemOutput.fromJson((JsonElement)json.get("leftover"));
        }
        return new MaterialRecipe(recipeId, group, ingredient, value, needed, materialId, leftover);
    }

    @Nullable
    protected MaterialRecipe fromNetworkSafe(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        String group = buffer.m_130136_(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int value = buffer.readInt();
        int needed = buffer.readInt();
        MaterialVariantId materialId = MaterialVariantId.parse(buffer.m_130136_(Short.MAX_VALUE));
        ItemOutput leftover = ItemOutput.read((FriendlyByteBuf)buffer);
        return new MaterialRecipe(recipeId, group, ingredient, value, needed, materialId, leftover);
    }

    protected void toNetworkSafe(FriendlyByteBuf buffer, MaterialRecipe recipe) {
        buffer.m_130070_(recipe.group);
        recipe.ingredient.m_43923_(buffer);
        buffer.writeInt(recipe.value);
        buffer.writeInt(recipe.needed);
        buffer.m_130070_(recipe.material.getVariant().toString());
        recipe.leftover.write(buffer);
    }
}

