/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.fuel;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MeltingFuelBuilder
extends AbstractRecipeBuilder<MeltingFuelBuilder> {
    private final FluidIngredient input;
    private final int duration;
    private final int temperature;

    public static MeltingFuelBuilder fuel(FluidStack fluid, int duration) {
        return MeltingFuelBuilder.fuel(FluidIngredient.of((FluidStack)fluid), duration, fluid.getFluid().getAttributes().getTemperature(fluid) - 300);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        if (this.input.getFluids().isEmpty()) {
            throw new IllegalStateException("Must have at least one fluid for dynamic input");
        }
        this.save(consumer, Objects.requireNonNull(((FluidStack)this.input.getFluids().get(0)).getFluid().getRegistryName()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "melting_fuel");
        consumer.accept((FinishedRecipe)new Result(id, advancementId));
    }

    private MeltingFuelBuilder(FluidIngredient input, int duration, int temperature) {
        this.input = input;
        this.duration = duration;
        this.temperature = temperature;
    }

    public static MeltingFuelBuilder fuel(FluidIngredient input, int duration, int temperature) {
        return new MeltingFuelBuilder(input, duration, temperature);
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)MeltingFuelBuilder.this, ID, advancementID);
        }

        public void m_7917_(JsonObject json) {
            if (!MeltingFuelBuilder.this.group.isEmpty()) {
                json.addProperty("group", MeltingFuelBuilder.this.group);
            }
            json.add("fluid", MeltingFuelBuilder.this.input.serialize());
            json.addProperty("duration", (Number)MeltingFuelBuilder.this.duration);
            json.addProperty("temperature", (Number)MeltingFuelBuilder.this.temperature);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TinkerSmeltery.fuelSerializer.get();
        }
    }
}

