/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialCastingRecipeBuilder
extends AbstractRecipeBuilder<MaterialCastingRecipeBuilder> {
    private final IMaterialItem result;
    private final MaterialCastingRecipe.Serializer<?> recipeSerializer;
    private Ingredient cast = Ingredient.f_43901_;
    private int itemCost = 0;
    private boolean consumed = false;
    private boolean switchSlots = false;

    public static MaterialCastingRecipeBuilder basinRecipe(IMaterialItem result) {
        return MaterialCastingRecipeBuilder.castingRecipe(result, (MaterialCastingRecipe.Serializer)((Object)TinkerSmeltery.basinMaterialSerializer.get()));
    }

    public static MaterialCastingRecipeBuilder tableRecipe(IMaterialItem result) {
        return MaterialCastingRecipeBuilder.castingRecipe(result, (MaterialCastingRecipe.Serializer)((Object)TinkerSmeltery.tableMaterialSerializer.get()));
    }

    public MaterialCastingRecipeBuilder setCast(TagKey<Item> tag, boolean consumed) {
        return this.setCast(Ingredient.m_204132_(tag), consumed);
    }

    public MaterialCastingRecipeBuilder setCast(ItemLike item, boolean consumed) {
        return this.setCast(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), consumed);
    }

    public MaterialCastingRecipeBuilder setCast(Ingredient cast, boolean consumed) {
        this.cast = cast;
        this.consumed = consumed;
        return this;
    }

    public MaterialCastingRecipeBuilder setSwitchSlots() {
        this.switchSlots = true;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Objects.requireNonNull(this.result.m_5456_().getRegistryName()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.itemCost <= 0) {
            throw new IllegalStateException("Material casting recipes require a positive amount of fluid");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        consumer.accept((FinishedRecipe)new Result(id, advancementId));
    }

    private MaterialCastingRecipeBuilder(IMaterialItem result, MaterialCastingRecipe.Serializer<?> recipeSerializer) {
        this.result = result;
        this.recipeSerializer = recipeSerializer;
    }

    public static MaterialCastingRecipeBuilder castingRecipe(IMaterialItem result, MaterialCastingRecipe.Serializer<?> recipeSerializer) {
        return new MaterialCastingRecipeBuilder(result, recipeSerializer);
    }

    public MaterialCastingRecipeBuilder setItemCost(int itemCost) {
        this.itemCost = itemCost;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)MaterialCastingRecipeBuilder.this, ID, advancementID);
        }

        public RecipeSerializer<?> m_6637_() {
            return MaterialCastingRecipeBuilder.this.recipeSerializer;
        }

        public void m_7917_(JsonObject json) {
            if (!MaterialCastingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", MaterialCastingRecipeBuilder.this.group);
            }
            if (MaterialCastingRecipeBuilder.this.cast != Ingredient.f_43901_) {
                json.add("cast", MaterialCastingRecipeBuilder.this.cast.m_43942_());
                if (MaterialCastingRecipeBuilder.this.consumed) {
                    json.addProperty("cast_consumed", Boolean.valueOf(true));
                }
            }
            if (MaterialCastingRecipeBuilder.this.switchSlots) {
                json.addProperty("switch_slots", Boolean.valueOf(true));
            }
            json.addProperty("item_cost", (Number)MaterialCastingRecipeBuilder.this.itemCost);
            json.addProperty("result", Objects.requireNonNull(MaterialCastingRecipeBuilder.this.result.m_5456_().getRegistryName()).toString());
        }
    }
}

