/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.container;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.library.recipe.casting.container.ContainerFillingRecipe;

public class ContainerFillingRecipeSerializer<T extends ContainerFillingRecipe>
extends LoggingRecipeSerializer<T> {
    private final IFactory<T> factory;

    public T fromJson(ResourceLocation recipeId, JsonObject json) {
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        int fluidAmount = GsonHelper.m_13927_((JsonObject)json, (String)"fluid_amount");
        Item result = GsonHelper.m_13909_((JsonObject)json, (String)"container");
        return this.factory.create(recipeId, group, fluidAmount, result);
    }

    @Nullable
    protected T fromNetworkSafe(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        String group = buffer.m_130136_(Short.MAX_VALUE);
        int fluidAmount = buffer.readInt();
        Item result = RecipeHelper.readItem((FriendlyByteBuf)buffer);
        return this.factory.create(recipeId, group, fluidAmount, result);
    }

    protected void toNetworkSafe(FriendlyByteBuf buffer, T recipe) {
        buffer.m_130070_(((ContainerFillingRecipe)recipe).group);
        buffer.writeInt(((ContainerFillingRecipe)recipe).fluidAmount);
        RecipeHelper.writeItem((FriendlyByteBuf)buffer, (ItemLike)((ContainerFillingRecipe)recipe).container);
    }

    public ContainerFillingRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    public static interface IFactory<T extends ContainerFillingRecipe> {
        public T create(ResourceLocation var1, String var2, int var3, Item var4);
    }
}

