/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.AbstractCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public abstract class ItemCastingRecipe
extends AbstractCastingRecipe
implements IDisplayableCastingRecipe {
    protected final FluidIngredient fluid;
    protected final ItemOutput result;
    protected final int coolingTime;

    public ItemCastingRecipe(RecipeType<?> type, ResourceLocation id, String group, Ingredient cast, FluidIngredient fluid, ItemOutput result, int coolingTime, boolean consumed, boolean switchSlots) {
        super(type, id, group, cast, consumed, switchSlots);
        this.fluid = fluid;
        this.result = result;
        this.coolingTime = coolingTime;
    }

    @Override
    public int getFluidAmount(ICastingContainer inv) {
        return this.fluid.getAmount(inv.getFluid());
    }

    public boolean matches(ICastingContainer inv, Level worldIn) {
        return this.getCast().test(inv.getStack()) && this.fluid.test(inv.getFluid());
    }

    @Override
    public ItemStack m_8043_() {
        return this.result.get();
    }

    @Override
    public int getCoolingTime(ICastingContainer inv) {
        return this.coolingTime;
    }

    @Override
    public boolean hasCast() {
        return this.cast != Ingredient.f_43901_;
    }

    @Override
    public List<ItemStack> getCastItems() {
        return Arrays.asList(this.cast.m_43908_());
    }

    @Override
    public ItemStack getOutput() {
        return this.result.get();
    }

    @Override
    public List<FluidStack> getFluids() {
        return this.fluid.getFluids();
    }

    public FluidIngredient getFluid() {
        return this.fluid;
    }

    @Override
    public int getCoolingTime() {
        return this.coolingTime;
    }

    public static interface IFactory<T extends AbstractCastingRecipe> {
        public T create(ResourceLocation var1, String var2, @Nullable Ingredient var3, FluidIngredient var4, ItemOutput var5, int var6, boolean var7, boolean var8);
    }

    public static class Serializer<T extends ItemCastingRecipe>
    extends AbstractCastingRecipe.Serializer<T> {
        private final IFactory<T> factory;

        @Override
        protected T create(ResourceLocation idIn, String groupIn, @Nullable Ingredient cast, boolean consumed, boolean switchSlots, JsonObject json) {
            FluidIngredient fluid = FluidIngredient.deserialize((JsonObject)json, (String)"fluid");
            ItemOutput output = ItemOutput.fromJson((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"result"));
            int coolingTime = GsonHelper.m_13927_((JsonObject)json, (String)"cooling_time");
            return (T)((ItemCastingRecipe)this.factory.create(idIn, groupIn, cast, fluid, output, coolingTime, consumed, switchSlots));
        }

        @Override
        protected T create(ResourceLocation idIn, String groupIn, @Nullable Ingredient cast, boolean consumed, boolean switchSlots, FriendlyByteBuf buffer) {
            FluidIngredient fluid = FluidIngredient.read((FriendlyByteBuf)buffer);
            ItemOutput result = ItemOutput.read((FriendlyByteBuf)buffer);
            int coolingTime = buffer.readInt();
            return (T)((ItemCastingRecipe)this.factory.create(idIn, groupIn, cast, fluid, result, coolingTime, consumed, switchSlots));
        }

        @Override
        public void writeExtra(FriendlyByteBuf buffer, T recipe) {
            ((ItemCastingRecipe)recipe).fluid.write(buffer);
            ((ItemCastingRecipe)recipe).result.write(buffer);
            buffer.writeInt(((ItemCastingRecipe)recipe).coolingTime);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    public static class Table
    extends ItemCastingRecipe {
        public Table(ResourceLocation id, String group, Ingredient cast, FluidIngredient fluid, ItemOutput result, int coolingTime, boolean consumed, boolean switchSlots) {
            super((RecipeType)TinkerRecipeTypes.CASTING_TABLE.get(), id, group, cast, fluid, result, coolingTime, consumed, switchSlots);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)TinkerSmeltery.tableRecipeSerializer.get();
        }
    }

    public static class Basin
    extends ItemCastingRecipe {
        public Basin(ResourceLocation id, String group, Ingredient cast, FluidIngredient fluid, ItemOutput result, int coolingTime, boolean consumed, boolean switchSlots) {
            super((RecipeType)TinkerRecipeTypes.CASTING_BASIN.get(), id, group, cast, fluid, result, coolingTime, consumed, switchSlots);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)TinkerSmeltery.basinRecipeSerializer.get();
        }
    }
}

