/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public abstract class DurabilityShieldModifier
extends Modifier {
    @Override
    public Component getDisplayName(IToolStackView tool, int level) {
        return this.getDisplayName(level).m_6881_().m_130946_(": " + this.getShield(tool) + " / " + this.getShieldCapacity(tool, level));
    }

    @Override
    public ValidatedResult validate(IToolStackView tool, int level) {
        if (level > 0) {
            int cap = this.getShieldCapacity(tool, level);
            if (this.getShield(tool) > cap) {
                this.setShield(tool.getPersistentData(), cap);
            }
        }
        return ValidatedResult.PASS;
    }

    @Override
    public void onRemoved(IToolStackView tool) {
        tool.getPersistentData().remove(this.getShieldKey());
    }

    @Override
    public int onDamageTool(IToolStackView tool, int level, int amount, @Nullable LivingEntity holder) {
        int shield = this.getShield(tool);
        if (shield > 0) {
            if (shield >= amount) {
                this.setShield(tool, level, shield - amount);
                return 0;
            }
            amount -= shield;
            this.setShield(tool, level, 0);
        }
        return amount;
    }

    @Override
    public double getDamagePercentage(IToolStackView tool, int level) {
        int shield = this.getShield(tool);
        if (shield > 0) {
            int cap = this.getShieldCapacity(tool, level);
            if (shield > cap) {
                return 0.0;
            }
            return (double)(cap - shield) / (double)cap;
        }
        return Double.NaN;
    }

    protected ResourceLocation getShieldKey() {
        return this.getId();
    }

    protected int getShield(IToolStackView tool) {
        return tool.getPersistentData().getInt(this.getShieldKey());
    }

    protected abstract int getShieldCapacity(IToolStackView var1, int var2);

    protected void setShield(ModDataNBT persistentData, int amount) {
        persistentData.putInt(this.getShieldKey(), Math.max(amount, 0));
    }

    protected void setShield(IToolStackView tool, int level, int amount) {
        this.setShield(tool.getPersistentData(), Math.min(amount, this.getShieldCapacity(tool, level)));
    }

    protected void addShield(IToolStackView tool, int level, int amount) {
        this.setShield(tool, level, amount + this.getShield(tool));
    }
}

