/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.JsonRedirect;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.UpdateModifiersPacket;
import slimeknights.tconstruct.library.utils.JsonUtils;

public class ModifierManager
extends SimpleJsonResourceReloadListener {
    private static final Logger log = LogManager.getLogger(ModifierManager.class);
    public static final String FOLDER = "tinkering/modifiers";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final ModifierId EMPTY = new ModifierId("tconstruct", "empty");
    public static final ModifierManager INSTANCE = new ModifierManager();
    private final Modifier defaultValue;
    private boolean modifiersRegistered = false;
    @VisibleForTesting
    final Map<ModifierId, Modifier> staticModifiers = new HashMap<ModifierId, Modifier>();
    private final Map<ModifierId, Class<?>> expectedDynamicModifiers = new HashMap();
    public static final GenericLoaderRegistry<Modifier> MODIFIER_LOADERS = new GenericLoaderRegistry();
    private Map<ModifierId, Modifier> dynamicModifiers = Collections.emptyMap();
    boolean dynamicModifiersLoaded = false;
    private ICondition.IContext conditionContext = ICondition.IContext.EMPTY;

    private ModifierManager() {
        super(GSON, FOLDER);
        this.defaultValue = new EmptyModifier();
        this.defaultValue.setId(EMPTY);
        this.staticModifiers.put(EMPTY, this.defaultValue);
    }

    @Deprecated
    public void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, FMLCommonSetupEvent.class, e -> e.enqueueWork(this::fireRegistryEvent));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, AddReloadListenerEvent.class, this::addDataPackListeners);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, OnDatapackSyncEvent.class, e -> JsonUtils.syncPackets(e, new ISimplePacket[]{new UpdateModifiersPacket(this.dynamicModifiers)}));
    }

    private void fireRegistryEvent() {
        ModLoader.get().runEventGenerator(x$0 -> new ModifierRegistrationEvent((ModContainer)x$0));
        this.modifiersRegistered = true;
    }

    private void addDataPackListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this);
        this.conditionContext = event.getConditionContext();
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        long time = System.nanoTime();
        HashMap redirects = new HashMap();
        this.dynamicModifiers = splashList.entrySet().stream().map(entry -> this.loadModifier((ResourceLocation)entry.getKey(), (JsonElement)((JsonElement)entry.getValue()).getAsJsonObject(), redirects)).filter(Objects::nonNull).collect(Collectors.toMap(Modifier::getId, mod -> mod));
        HashMap<ModifierId, Modifier> resolvedRedirects = new HashMap<ModifierId, Modifier>();
        for (Map.Entry redirect : redirects.entrySet()) {
            ModifierId from = (ModifierId)((Object)redirect.getKey());
            ModifierId to = (ModifierId)((Object)redirect.getValue());
            if (!this.contains(to)) {
                log.error("Invalid modifier redirect {} as modifier {} does not exist", (Object)from, (Object)to);
                continue;
            }
            resolvedRedirects.put(from, this.get(to));
        }
        int modifierSize = this.dynamicModifiers.size();
        this.dynamicModifiers.putAll(resolvedRedirects);
        for (Map.Entry<ModifierId, Class<?>> entry2 : this.expectedDynamicModifiers.entrySet()) {
            Modifier modifier = this.dynamicModifiers.get((Object)entry2.getKey());
            if (modifier == null) {
                log.error("Missing expected modifier '" + (Object)((Object)entry2.getKey()) + "'");
                continue;
            }
            if (entry2.getValue().isInstance(modifier)) continue;
            log.error("Modifier '" + (Object)((Object)entry2.getKey()) + "' was loaded with the wrong class type. Expected " + entry2.getValue().getName() + ", got " + modifier.getClass().getName());
        }
        this.dynamicModifiersLoaded = true;
        log.info("Loaded {} dynamic modifiers and {} modifier redirects in {} ms", (Object)modifierSize, (Object)redirects.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
        MinecraftForge.EVENT_BUS.post((Event)new ModifiersLoadedEvent());
    }

    @Nullable
    private Modifier loadModifier(ResourceLocation key, JsonElement element, Map<ModifierId, ModifierId> redirects) {
        try {
            JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)"modifier");
            if (json.has("redirects")) {
                for (JsonRedirect redirect : JsonHelper.parseList((JsonObject)json, (String)"redirects", JsonRedirect::fromJson)) {
                    ICondition redirectCondition = redirect.getCondition();
                    if (redirectCondition != null && !redirectCondition.test(this.conditionContext)) continue;
                    ModifierId redirectTarget = new ModifierId(redirect.getId());
                    log.debug("Redirecting modifier {} to {}", (Object)key, (Object)redirectTarget);
                    redirects.put(new ModifierId(key), redirectTarget);
                    return null;
                }
            }
            if (json.has("condition") && !CraftingHelper.getCondition((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"condition")).test(this.conditionContext)) {
                return null;
            }
            Modifier modifier = (Modifier)MODIFIER_LOADERS.deserialize((JsonElement)json);
            modifier.setId(new ModifierId(key));
            return modifier;
        }
        catch (JsonSyntaxException e) {
            log.error("Failed to load modifier {}", (Object)key, (Object)e);
            return null;
        }
    }

    void updateModifiersFromServer(Map<ModifierId, Modifier> modifiers) {
        this.dynamicModifiers = modifiers;
        this.dynamicModifiersLoaded = true;
        MinecraftForge.EVENT_BUS.post((Event)new ModifiersLoadedEvent());
    }

    public Modifier getStatic(ModifierId id) {
        return this.staticModifiers.getOrDefault((Object)id, this.defaultValue);
    }

    public boolean contains(ModifierId id) {
        return this.staticModifiers.containsKey((Object)id) || this.dynamicModifiers.containsKey((Object)id);
    }

    public Modifier get(ModifierId id) {
        Modifier modifier = this.staticModifiers.get((Object)id);
        if (modifier != null) {
            return modifier;
        }
        return this.dynamicModifiers.getOrDefault((Object)id, this.defaultValue);
    }

    public Stream<ResourceLocation> getAllLocations() {
        return Stream.concat(this.staticModifiers.entrySet().stream(), this.dynamicModifiers.entrySet().stream()).filter(entry -> ((ModifierId)((Object)((Object)entry.getKey()))).equals((Object)((Modifier)entry.getValue()).getId())).map(Map.Entry::getKey);
    }

    public Stream<Modifier> getAllValues() {
        return Stream.concat(this.staticModifiers.values().stream(), this.dynamicModifiers.values().stream()).distinct();
    }

    public static Modifier getValue(ModifierId name) {
        return INSTANCE.get(name);
    }

    public static Modifier convertToModifier(JsonElement element, String key) {
        ModifierId name = new ModifierId(JsonHelper.convertToResourceLocation((JsonElement)element, (String)key));
        if (INSTANCE.contains(name)) {
            return INSTANCE.get(name);
        }
        throw new JsonSyntaxException("Unknown modifier " + name);
    }

    public static Modifier deserializeModifier(JsonObject parent, String key) {
        return ModifierManager.convertToModifier(JsonHelper.getElement((JsonObject)parent, (String)key), key);
    }

    public static Modifier fromNetwork(FriendlyByteBuf buffer) {
        return INSTANCE.get(new ModifierId(buffer.m_130136_(Short.MAX_VALUE)));
    }

    public static void toNetwork(Modifier modifier, FriendlyByteBuf buffer) {
        buffer.m_130070_(modifier.getId().toString());
    }

    public Modifier getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isModifiersRegistered() {
        return this.modifiersRegistered;
    }

    public boolean isDynamicModifiersLoaded() {
        return this.dynamicModifiersLoaded;
    }

    private static class EmptyModifier
    extends Modifier {
        private EmptyModifier() {
        }

        @Override
        public boolean shouldDisplay(boolean advanced) {
            return false;
        }
    }

    public static class ModifiersLoadedEvent
    extends Event {
    }

    public class ModifierRegistrationEvent
    extends Event
    implements IModBusEvent {
        private final ModContainer container;

        private void checkModNamespace(ResourceLocation name) {
            String activeMod = this.container.getNamespace();
            if (!name.m_135827_().equals(activeMod)) {
                TConstruct.LOG.warn("Potentially Dangerous alternative prefix for name `{}`, expected `{}`. This could be a intended override, but in most cases indicates a broken mod.", (Object)name, (Object)activeMod);
            }
        }

        public void registerStatic(ModifierId name, Modifier modifier) {
            this.checkModNamespace(name);
            if (ModifierManager.this.expectedDynamicModifiers.containsKey((Object)name)) {
                throw new IllegalArgumentException(name + " is already expected as a dynamic modifier");
            }
            modifier.setId(name);
            Modifier existing = ModifierManager.this.staticModifiers.putIfAbsent(name, modifier);
            if (existing != null) {
                throw new IllegalArgumentException("Attempting to register a duplicate static modifier, this is not supported. Original value " + existing);
            }
        }

        public void registerExpected(ModifierId name, Class<?> classFilter) {
            this.checkModNamespace(name);
            if (ModifierManager.this.staticModifiers.containsKey((Object)name)) {
                throw new IllegalArgumentException(name + " is already registered as a static modifier");
            }
            Class<?> existing = ModifierManager.this.expectedDynamicModifiers.putIfAbsent(name, classFilter);
            if (existing != null) {
                throw new IllegalArgumentException("Attempting to register a duplicate expected modifier, this is not supported. Original value " + existing);
            }
        }

        protected ModifierRegistrationEvent(ModContainer container) {
            this.container = container;
        }
    }
}

